// ftp.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "ftp.h"
#include <process.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static char s_szFileName[128] = {0};
/////////////////////////////////////////////////////////////////////////////
// ftp dialog
static void _SearchFtpUpdateDevice(void *param)
{
	char szMac[32];
	int i = 0;

	ftp *pftp = (ftp*)param;
	while(!pftp->m_run){	
		memset(szMac, 0, sizeof(szMac));
		if(MRNSDK_SearchFtpUpdateDevice(pftp->m_fd, szMac) < 0){
			continue;
		}

		CString szText;
		szText.Format("%d", ++i);
		pftp->m_listdevice.InsertItem(i - 1, szText);
		pftp->m_listdevice.SetItemText(i - 1, 1, szMac);
	}
}

ftp::ftp(CWnd* pParent /*=NULL*/)
	: CDialog(ftp::IDD, pParent)
{
	//{{AFX_DATA_INIT(ftp)
	m_ftp_password = _T("admin");
	m_ftp_ip = _T("192.168.5.163");
	m_ftp_port = 21;
	m_ftp_usr = _T("admin");
	m_ftp_filename = _T("");
	m_ftp_dir = _T("Ftp");
	//}}AFX_DATA_INIT
}


void ftp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ftp)
	DDX_Control(pDX, IDD_FTP_LIST_DEVICE, m_listdevice);
	DDX_Text(pDX, IDC_PASSWORD, m_ftp_password);
	DDX_Text(pDX, IDC_IP, m_ftp_ip);
	DDX_Text(pDX, IDC_PORT, m_ftp_port);
	DDX_Text(pDX, IDC_USRNAME, m_ftp_usr);
	DDX_Text(pDX, IDC_FILENAME, m_ftp_filename);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ftp, CDialog)
	//{{AFX_MSG_MAP(ftp)
	ON_BN_CLICKED(ID_FTP_UPDATE, OnFtpUpdate)
	ON_BN_CLICKED(ID_FTP_QUIT, OnFtpQuit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ftp message handlers
void ftp::OnFtpUpdate() 
{
	m_listdevice.DeleteAllItems(); // clear all history lists
	
	if(!UpdateData(TRUE))
		return;
	
	if(m_ftp_filename.IsEmpty())
	{
		AfxMessageBox("Please input the filename used to ftp update");
		return;
	}
	
	if(AfxMessageBox("Are you sure to batch ftp update?", MB_YESNO) != IDYES)
		return;

	if(!m_ftp_filename.IsEmpty())
	{
		snprintf(s_szFileName, sizeof(s_szFileName), "%s", m_ftp_filename);
	}
	
	m_run = 1;

	if(m_fd > 0){
		MRNSDK_SearchFtpUpdateDeviceStop(m_fd);
		m_fd = 0;
	}
	
	if(m_ftp_thread)
	{
		WaitForSingleObject(m_ftp_thread, -1);
		CloseHandle(m_ftp_thread);
		m_ftp_thread = NULL;
	}
	m_run = 0;
	if((m_fd = MRNSDK_SearchFtpUpdate(m_ftp_ip, m_ftp_port, m_ftp_dir, m_ftp_usr, m_ftp_password, m_ftp_filename)) < 0)
	{
		return;
	}

	UINT uThreadID;
	m_ftp_thread = (HANDLE)_beginthreadex(0, 0, (UINT(__stdcall*)(void *))_SearchFtpUpdateDevice, this, 0, &uThreadID);
}

void ftp::OnFtpQuit() 
{
	m_run = 1;

	if(m_fd > 0){
		MRNSDK_SearchFtpUpdateDeviceStop(m_fd);
		m_fd = 0;
	}
	
	if(m_ftp_thread)
	{
		WaitForSingleObject(m_ftp_thread, -1);
		CloseHandle(m_ftp_thread);
		m_ftp_thread = NULL;
	}
	PostMessage(WM_SYSCOMMAND, SC_CLOSE);	
}

BOOL ftp::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ftp_filename = s_szFileName;
	m_run = 0;
	m_fd = 0;

	m_listdevice.InsertColumn(0, "sequence",	LVCFMT_CENTER, 120);
	m_listdevice.InsertColumn(1, "mac address",	LVCFMT_CENTER, 393);
	
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
