// NetSearchDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "NetSearchDlg.h"
#include "DlgModifyIP.h"
#include "DlgUpdate.h"
#include "DlgExtUsr.h"
#include "DlgOsd.h"
#include "ftp.h"
#include "libavserver_v3.h"
#include <winsock2.h>  

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetSearchDlg dialog

CNetSearchDlg::CNetSearchDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetSearchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetSearchDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	//m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetSearchDlg)
	DDX_Control(pDX, IDC_LST_DEVICE, m_lstDevs);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CNetSearchDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BTN_SEARCH, OnBtnSearch)
	ON_BN_CLICKED(IDC_BTN_MODIFYIP, OnBtnModifyip)
	ON_BN_CLICKED(IDC_BTN_MODIFYNAME, OnBtnModifyname)
	ON_BN_CLICKED(IDC_BTN_EXPENV, OnBtnExpenv)
	ON_BN_CLICKED(IDC_BTN_IMPENV, OnBtnImpenv)
	ON_BN_CLICKED(IDC_BTN_OSD, OnBtnOsd)
	ON_BN_CLICKED(IDC_BTN_DEFAULT, OnBtnDefault)
	ON_BN_CLICKED(IDC_BTN_UPDATE, OnBtnUpdate)
	ON_BN_CLICKED(IDC_BTN_REBOOT, OnBtnReboot)
	ON_BN_CLICKED(IDC_BTN_FTPUPDATE, OnBtnFtpupdate)
	ON_BN_CLICKED(IDC_MULDEFAULT, OnMuldefault)
	ON_BN_CLICKED(IDC_STOP_TRACK, OnStopTrack)
	ON_BN_CLICKED(IDC_CHECK_LENS, OnCheckLens)
	ON_BN_CLICKED(IDC_CHECK_BAD_POINT, OnCheckBadPoint)
	ON_BN_CLICKED(IDC_SYNC_TIME, OnSyncTime)
	ON_BN_CLICKED(IDC_CHECK_IRIS, OnCheckIris)
	ON_BN_CLICKED(IDC_AUTO_CALIBRATION, OnAutoCalibration)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetSearchDlg message handlers

void CNetSearchDlg::GetIPAddrList()
{
	struct hostent *pHost;
	char hostname[128];
	CString szIPAddr;
	int i;
    gethostname(hostname, sizeof(hostname));
	pHost = gethostbyname(hostname);
	if(!pHost)
		return;
    for(i = 0; pHost != NULL && pHost->h_addr_list[i] != NULL; i++)   
    {   
		szIPAddr = inet_ntoa(*(struct in_addr *)pHost->h_addr_list[i]);
		((CComboBox*)GetDlgItem(IDC_CMB_IPADDR))->AddString(szIPAddr);
    }  
	((CComboBox*)GetDlgItem(IDC_CMB_IPADDR))->SetCurSel(0);
}

BOOL CNetSearchDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	MRNSDK_Init(FALSE);
	
	GetClientRect(&m_clientRect);
	AdjWindowSize(m_clientRect);
	
	m_lstDevs.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_CHECKBOXES);
	m_lstDevs.InsertColumn(0, "Seq",		LVCFMT_CENTER, 60);
	m_lstDevs.InsertColumn(1, "OSD name",	LVCFMT_CENTER, 120);
	m_lstDevs.InsertColumn(2, "ID",			LVCFMT_CENTER, 120);
	m_lstDevs.InsertColumn(3, "IP address",	LVCFMT_CENTER, 100);
	m_lstDevs.InsertColumn(4, "Netmask",	LVCFMT_CENTER, 100);
	m_lstDevs.InsertColumn(5, "Gateway",	LVCFMT_CENTER, 100);
	m_lstDevs.InsertColumn(6, "Port web",	LVCFMT_CENTER, 80);
	m_lstDevs.InsertColumn(7, "Version",	LVCFMT_CENTER, 80);
	m_lstDevs.InsertColumn(8, "Date",	LVCFMT_CENTER, 80);
	m_lstDevs.InsertColumn(9, "MAC Address", LVCFMT_CENTER, 160);

	GetIPAddrList();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetSearchDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetSearchDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetSearchDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetSearchDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	MRNSDK_Cleanup();
	CleanAllDevice();
}

void CNetSearchDlg::CleanAllDevice()
{
	while(m_stDevList.GetSize())
	{
		NETSEARCH_INFO_T *pInfo = (NETSEARCH_INFO_T*)m_stDevList.GetAt(0);
		delete pInfo;
		m_stDevList.RemoveAt(0);
	}
}

void CNetSearchDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if ((cx ==0 && cy == 0) || 
		(cx == m_clientRect.Width() && cy == m_clientRect.Height())) 
	{
		return;
	}
	else if(m_lstDevs.m_hWnd)
	{
		GetClientRect(&m_clientRect);
		AdjWindowSize(m_clientRect);
	}
}

void CNetSearchDlg::AdjWindowSize(CRect &rcClient)
{
	CRect rcWnd, rcTmp;
	rcWnd     = rcClient;
	rcWnd.bottom = rcClient.bottom - 80;
	m_lstDevs.MoveWindow(&rcWnd, TRUE);

	GetDlgItem(IDC_CMB_IPADDR)->GetWindowRect(&rcTmp);
	rcWnd.left = rcClient.left + 110;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	rcWnd.top  = rcClient.bottom - 72;
	rcWnd.bottom = rcWnd.top + rcTmp.Height();
	GetDlgItem(IDC_CMB_IPADDR)->MoveWindow(&rcWnd, TRUE);

	GetDlgItem(IDC_BTN_SEARCH)->GetWindowRect(&rcTmp);
	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	rcWnd.top  = rcClient.bottom - 72;
	rcWnd.bottom = rcWnd.top + rcTmp.Height();
	GetDlgItem(IDC_BTN_SEARCH)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_SELECTALL)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_MODIFYIP)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_MODIFYNAME)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_EXPENV)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_IMPENV)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_FTPUPDATE)->MoveWindow(&rcWnd, TRUE);
	
	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_AUTO_CALIBRATION)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcClient.left + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	rcWnd.top  = rcClient.bottom - 36;
	rcWnd.bottom = rcWnd.top + rcTmp.Height();
	GetDlgItem(IDC_BTN_OSD)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width() + 30;
	GetDlgItem(IDC_BTN_DEFAULT)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_REBOOT)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_BTN_UPDATE)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_MULDEFAULT)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_STOP_TRACK)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_CHECK_LENS)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_CHECK_BAD_POINT)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_SYNC_TIME)->MoveWindow(&rcWnd, TRUE);

	rcWnd.left = rcWnd.right + 10;
	rcWnd.right= rcWnd.left + rcTmp.Width();
	GetDlgItem(IDC_CHECK_IRIS)->MoveWindow(&rcWnd, TRUE);
}

void CNetSearchDlg::LoadDevToList()
{
	int i;
	CString szText;
	NETSEARCH_INFO_T *pInfo;
	for(i=0; i<m_stDevList.GetSize(); i++)
	{
		pInfo = (NETSEARCH_INFO_T *)m_stDevList.GetAt(i);

		szText.Format("%d", i + 1);
		m_lstDevs.InsertItem(i, szText);

		m_lstDevs.SetItemText(i, 1, pInfo->szDevName);
		m_lstDevs.SetItemText(i, 2, pInfo->szClientDevID);
		m_lstDevs.SetItemText(i, 3, pInfo->szIP);
		m_lstDevs.SetItemText(i, 4, pInfo->szSubMask);
		m_lstDevs.SetItemText(i, 5, pInfo->szGateway);

		//szText.Format("%d", pInfo->wDataPort);
		//m_lstDevs.SetItemText(i, 6, szText);

		//szText.Format("%d", pInfo->wSoapPort);
		//m_lstDevs.SetItemText(i, 7, szText);

		szText.Format("%d", pInfo->wWebPort);
		m_lstDevs.SetItemText(i, 6, szText);

		//szText.Format("%d", pInfo->wRtspPort);
		//m_lstDevs.SetItemText(i, 9, szText);

		//szText.Format("%d", pInfo->wRtmpPort);
		//m_lstDevs.SetItemText(i, 10, szText);

		//szText.Format("%d", pInfo->wOnvifPort);
		//m_lstDevs.SetItemText(i, 11, szText);

		szText.Format("V%d.%d.%d", 
			//(pInfo->stVersion.dwKernelVersion >> 24) & 0xFF,
			(pInfo->stVersion.dwKernelVersion >> 16) & 0xFF,
			(pInfo->stVersion.dwKernelVersion >> 8) & 0xFF,
			(pInfo->stVersion.dwKernelVersion & 0xff));
		m_lstDevs.SetItemText(i, 7, szText);

		szText.Format("%d-%d-%d", 
			(pInfo->stVersion.dwKernelBuildDate >> 16) & 0xFFFF,
			(pInfo->stVersion.dwKernelBuildDate >> 8) & 0xFF,
			(pInfo->stVersion.dwKernelBuildDate & 0xff));
		m_lstDevs.SetItemText(i, 8, szText);

		m_lstDevs.SetItemText(i, 9, pInfo->szMacAddr);

		this->UpdateWindow();
	}
}
void CNetSearchDlg::LoadDevice(json_t *pJsHead, NETSEARCH_INFO_T *pInfo)
{
	json_t *pJsItem;
	json_t *pJsVer;
	const char *szTempTxt;
	
	memset(pInfo, 0, sizeof(NETSEARCH_INFO_T));
	pJsItem = json_object_get(pJsHead, "szClientProcName");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szClientProcName, szTempTxt, sizeof(pInfo->szClientProcName) - 1 );
		

	pJsItem = json_object_get(pJsHead, "szDeviceID");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szClientDevID, szTempTxt, sizeof(pInfo->szClientDevID) - 1 );

	pJsItem = json_object_get(pJsHead, "szIP");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szIP, szTempTxt, sizeof(pInfo->szIP) - 1 );

	pJsItem = json_object_get(pJsHead, "szSubMask");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szSubMask, szTempTxt, sizeof(pInfo->szSubMask) - 1 );

	pJsItem = json_object_get(pJsHead, "szGateway");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szGateway, szTempTxt, sizeof(pInfo->szGateway) - 1 );

	pJsItem = json_object_get(pJsHead, "wDataPort");
	if(pJsItem)
		pInfo->wDataPort = (WORD)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "wSoapPort");
	if(pJsItem)
		pInfo->wSoapPort = (WORD)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "wWebPort");
	if(pJsItem)
		pInfo->wWebPort = (WORD)json_integer_value(pJsItem);
	
	pJsItem = json_object_get(pJsHead, "wRtspPort");
	if(pJsItem)
		pInfo->wRtspPort = (WORD)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "wRtmpPort");
	if(pJsItem)
		pInfo->wRtmpPort = (WORD)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "wOnvifPort");
	if(pJsItem)
		pInfo->wOnvifPort = (WORD)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "szMacAddr");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szMacAddr, szTempTxt, sizeof(pInfo->szMacAddr) - 1 );

	pJsItem = json_object_get(pJsHead, "nChannels");
	if(pJsItem)
		pInfo->nChannels = json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "nDeviceType");
	if(pJsItem)
		pInfo->nDeviceType = json_integer_value(pJsItem);

	pJsItem = json_object_get(pJsHead, "szDeviceID");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szDeviceID, szTempTxt, sizeof(pInfo->szDeviceID) - 1 );

	pJsItem = json_object_get(pJsHead, "szDevName");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szDevName, szTempTxt, sizeof(pInfo->szDevName) - 1 );

	pJsItem = json_object_get(pJsHead, "szDns1");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szDns1, szTempTxt, sizeof(pInfo->szDns1) - 1 );

	pJsItem = json_object_get(pJsHead, "szDns2");
	szTempTxt = json_string_value(pJsItem);
	if(szTempTxt)
		strncpy(pInfo->szDns2, szTempTxt, sizeof(pInfo->szDns2) - 1 );

	pJsVer = json_object_get(pJsHead, "stVersion");
	if(pJsVer)
	{
		pJsItem = json_object_get(pJsVer, "dwKernelVersion");
		if(pJsItem)
			pInfo->stVersion.dwKernelVersion = json_integer_value(pJsItem);

		pJsItem = json_object_get(pJsVer, "dwKernelBuildDate");
		if(pJsItem)
			pInfo->stVersion.dwKernelBuildDate = json_integer_value(pJsItem);

		pJsItem = json_object_get(pJsVer, "dwWebVersion");
		if(pJsItem)
			pInfo->stVersion.dwWebVersion = json_integer_value(pJsItem);
		
		pJsItem = json_object_get(pJsVer, "dwWebDate");
		if(pJsItem)
			pInfo->stVersion.dwWebDate = json_integer_value(pJsItem);
	}

	pJsVer = json_object_get(pJsHead, "stClientVersion");
	if(pJsVer)
	{
		pJsItem = json_object_get(pJsVer, "dwKernelVersion");
		if(pJsItem)
			pInfo->stClientVersion.dwKernelVersion = json_integer_value(pJsItem);
		
		pJsItem = json_object_get(pJsVer, "dwKernelBuildDate");
		if(pJsItem)
			pInfo->stClientVersion.dwKernelBuildDate = json_integer_value(pJsItem);
		
		pJsItem = json_object_get(pJsVer, "dwWebVersion");
		if(pJsItem)
			pInfo->stClientVersion.dwWebVersion = json_integer_value(pJsItem);
		
		pJsItem = json_object_get(pJsVer, "dwWebDate");
		if(pJsItem)
			pInfo->stClientVersion.dwWebDate = json_integer_value(pJsItem);
	}	
}

static void fdMRSearchCB(const char *szDeviceID, const char *szInfo, void *context)
{
	json_t *pJsHead, *pJsSap;
	NETSEARCH_INFO_T *pInfo = NULL;
	CNetSearchDlg *pDlg = (CNetSearchDlg*)context;
	/*FILE *fpFile = fopen("search.json", "w");
	if(fpFile)
	{
		fwrite(szInfo, 1, strlen(szInfo), fpFile);
		fclose(fpFile);
	}*/
	pJsHead = json_loads(szInfo, 0, NULL);
	if(!pJsHead)
	{
		DPERROR(("invalid json format string\n"));
		return;
	}
	pJsSap = json_object_get(pJsHead, "SapSearch");
	if(!pJsSap)
	{
		DPERROR(("not net search\n"));
		json_delete(pJsHead);
		return;
	}

	pJsSap = json_object_get(pJsSap, "stNetInfo");
	if(!pJsSap)
	{
		DPERROR(("not net stNetInfo\n"));
		json_delete(pJsHead);
		return;
	}
	pInfo = new NETSEARCH_INFO_T();
	pDlg->LoadDevice(pJsSap, pInfo);
	json_delete(pJsHead);
	pDlg->m_stDevList.Add(pInfo);
}

void CNetSearchDlg::OnBtnSearch() 
{
	int nDevices;
	CString szIPAddr = "";
	m_lstDevs.DeleteAllItems();
	CleanAllDevice();
	this->UpdateWindow();
	GetDlgItem(IDC_CMB_IPADDR)->GetWindowText(szIPAddr);
	if(szIPAddr.IsEmpty())
	{
		AfxMessageBox("Please selecting IP address!");
		return;
	}
	nDevices = MRNSDK_SearchDevice(szIPAddr, 3000, fdMRSearchCB, this);
	TRACE("search device=%d\n", nDevices);
	LoadDevToList();
}


NETSEARCH_INFO_T *CNetSearchDlg::GetSelectDev()
{
	int nItem;
	if(!m_lstDevs.GetItemCount())
		return NULL;
	if(!m_lstDevs.GetSelectedCount())
	{
		AfxMessageBox("Please selecting device!");
		return NULL;
	}
	nItem = m_lstDevs.GetNextItem(-1, LVNI_SELECTED);
	if(nItem == -1)
		return NULL;
	return (NETSEARCH_INFO_T*)m_stDevList.GetAt(nItem);
}

void CNetSearchDlg::OnBtnModifyip() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;

	CDlgModifyIP dlg;
	dlg.m_pDevice = pInfo;
	dlg.DoModal();
}

void CNetSearchDlg::OnBtnModifyname() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	CDlgExtUsr dlg;
	dlg.m_pDevice = pInfo;
	dlg.DoModal();
}

void CNetSearchDlg::OnBtnExpenv() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	LONG pMsgHandle;
	int iRet;
	char *pRetCmd = NULL, *pRetFileName = NULL;
	CString szDstFileName;// = "All Files(*.*)|*.*|";
	CFileDialog dlg(FALSE, NULL, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, 
		szDstFileName, this);
	if(dlg.DoModal() != IDOK)
		return;
	szDstFileName = dlg.GetPathName();
	if(szDstFileName.IsEmpty())
	{
		AfxMessageBox("Please input file to save params!");
		return;
	}

	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, pInfo->szIP, pInfo->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}

	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"ImpExp\":{\"ExportConfig\":{}}}", NULL, &pRetCmd, &pRetFileName, 1000);
	if(iRet || !pRetFileName)
	{
		AfxMessageBox("Export config failed!");
		MRNSDK_MsgPort_Close(pMsgHandle);
		return;
	}
	CopyFile(pRetFileName, szDstFileName, TRUE);
	MRNSDK_MsgPort_Close(pMsgHandle);
}

void CNetSearchDlg::OnBtnImpenv() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	LONG pMsgHandle;
	int iRet;
	char *pRetCmd = NULL;
	CString szDstFileName;// = "All Files(*.*)|*.*|";
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, 
		szDstFileName, this);
		
	if(dlg.DoModal() != IDOK)
		return;
	szDstFileName = dlg.GetPathName();

	if(szDstFileName.IsEmpty())
	{
		AfxMessageBox("Please input file");
		return;
	}

	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, pInfo->szIP, pInfo->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}

	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"ImpExp\":{\"ImportConfig\":{}}}", szDstFileName, &pRetCmd, NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Import failed!");
		MRNSDK_MsgPort_Close(pMsgHandle);
		return;
	}
	AfxMessageBox("Import successed!");
	MRNSDK_MsgPort_Close(pMsgHandle);
}

void CNetSearchDlg::OnBtnOsd() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	CDlgOsd dlg;
	dlg.m_pDevice = pInfo;
	dlg.DoModal();
}

void CNetSearchDlg::OnBtnDefault() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	if(AfxMessageBox("Sure to restore factory default?", MB_YESNO) != IDYES)
		return;
	MRNSDK_SearchControl(pInfo->szDeviceID, "SapDefault");
}

void CNetSearchDlg::OnBtnUpdate() 
{
	CDlgUpdate dlg;
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;

	dlg.m_pDevice = pInfo;
	dlg.DoModal();
}

void CNetSearchDlg::OnBtnReboot() 
{
	NETSEARCH_INFO_T *pInfo = GetSelectDev();
	if(!pInfo)
		return;
	if(AfxMessageBox("Sure to reboot?", MB_YESNO) != IDYES)
		return;
	MRNSDK_SearchControl(pInfo->szDeviceID, "SapReboot");
}

void CNetSearchDlg::OnBtnFtpupdate() 
{
	ftp dlg;
	dlg.DoModal();
}

void CNetSearchDlg::OnMuldefault() 
{
	int i;
	NETSEARCH_INFO_T *pInfo;

	if(!m_stDevList.GetSize())
	{
		AfxMessageBox("Clicking button of Search");
		return;
	}
	
	if(AfxMessageBox("Sure to restore factory default?", MB_YESNO) != IDYES)
		return;

	for(i = 0; i < m_stDevList.GetSize(); i++)
	{
		pInfo = (NETSEARCH_INFO_T *)m_stDevList.GetAt(i);
		if(pInfo)
		{
			MRNSDK_SearchControl(pInfo->szDeviceID, "SapDefault");
		}
	}
}

void CNetSearchDlg::OnStopTrack() 
{
	char szTmpbuff[128];
	
	sprintf(szTmpbuff, "%s", "{\"SysCtrl\":{\"TrackEnable\":{\"bEnable\":0}}}");
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}

void CNetSearchDlg::OnCheckLens() 
{
	char szTmpbuff[128];
	
	sprintf(szTmpbuff, "%s", "{\"SysCtrl\":{\"LensCalibration\":{}}}");
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}

void CNetSearchDlg::OnCheckBadPoint() 
{
	char szTmpbuff[128];
	
	sprintf(szTmpbuff, "%s", "{\"SysCtrl\":{\"badpixeldo\":{}}}");
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}

void CNetSearchDlg::OnSyncTime() 
{
	char szTmpbuff[256];
	SYSTEMTIME sys;
	
	GetLocalTime( &sys);

	sprintf(szTmpbuff, "{\"SysCtrl\":{\"SetTime\":{\"nZone\":13, \"bTimeType\":1, \"stDateTime\":{\"dwYear\":%d, \"byMonth\":%d, \"byDay\":%d, \"byHour\":%d, \"byMinute\":%d, \"bySecond\":%d}}}}",
		sys.wYear, sys.wMonth,  sys.wDay, sys.wHour, sys.wMinute, sys.wSecond);
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}

void CNetSearchDlg::OnCheckIris() 
{
	char szTmpbuff[128];
	
	sprintf(szTmpbuff, "%s", "{\"SysCtrl\":{\"IrisCalibration\":{}}}");
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}

void CNetSearchDlg::OnAutoCalibration() 
{
	char szTmpbuff[128];

	sprintf(szTmpbuff, "%s", "{\"SysCtrl\":{\"AutoCalibration\":{}}}");
	libavmc_netsearch_sendcmd((unsigned char*)szTmpbuff, strlen(szTmpbuff));
}
