// DlgUpdate.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "DlgUpdate.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgUpdate dialog


CDlgUpdate::CDlgUpdate(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgUpdate::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgUpdate)
	m_szFileName = _T("");
	//}}AFX_DATA_INIT
}


void CDlgUpdate::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgUpdate)
	DDX_Text(pDX, IDC_EDT_FILE, m_szFileName);
	DDV_MaxChars(pDX, m_szFileName, 256);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgUpdate, CDialog)
	//{{AFX_MSG_MAP(CDlgUpdate)
	ON_BN_CLICKED(IDC_BTN_FILE, OnBtnFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgUpdate message handlers

void CDlgUpdate::OnBtnFile() 
{
	CString strFilter = "All Files(*.*)|*.*|";
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, 
		strFilter, this);
	if(dlg.DoModal() == IDOK)
	{
		m_szFileName = dlg.GetPathName();
		UpdateData(FALSE);
	}
}

void CDlgUpdate::OnOK() 
{
	if(!UpdateData())
		return;
	if(m_szFileName.IsEmpty())
	{
		OnBtnFile();
	}
	if(m_szFileName.IsEmpty())
		return;

	LONG pMsgHandle = 0;
	int iRet;
	CString szCmd;
	char *pRetInfo = NULL;
	if(!UpdateData())
		return;
	
	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, m_pDevice->szIP, m_pDevice->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		TRACE("error=%08X\n", iRet);
		AfxMessageBox("Connecting device failed!");
		return;
	}
	szCmd.Format("{\"ImpExp\":{\"ImportUpdate\":{}}}");
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, szCmd, m_szFileName, &pRetInfo, NULL, 1000 * 180);
	if(iRet)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Updating failed!");
		return;
	}
	MRNSDK_MsgPort_Close(pMsgHandle);
	CDialog::OnOK();
}
