// DlgOsd.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "DlgOsd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgOsd dialog


CDlgOsd::CDlgOsd(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgOsd::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgOsd)
	m_szOsdName = _T("Test Name");
	m_nNameX = 50;
	m_nNameY = 9000;
	m_nTimeX = 50;
	m_nTimeY = 50;
	//}}AFX_DATA_INIT
}

void CDlgOsd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOsd)
	DDX_Text(pDX, IDC_EDT_NAME, m_szOsdName);
	DDV_MaxChars(pDX, m_szOsdName, 64);
	DDX_Text(pDX, IDC_EDT_NAME_X, m_nNameX);
	DDV_MinMaxInt(pDX, m_nNameX, 0, 10000);
	DDX_Text(pDX, IDC_EDT_NAME_Y, m_nNameY);
	DDV_MinMaxInt(pDX, m_nNameY, 0, 10000);
	DDX_Text(pDX, IDC_EDT_TIME_X, m_nTimeX);
	DDV_MinMaxInt(pDX, m_nTimeX, 0, 10000);
	DDX_Text(pDX, IDC_EDT_TIME_Y, m_nTimeY);
	DDV_MinMaxInt(pDX, m_nTimeY, 0, 10000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDlgOsd, CDialog)
	//{{AFX_MSG_MAP(CDlgOsd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgOsd message handlers

static void GetRGBColor(json_t *pJson, MR_RGBA *pRgb)
{
	json_t *pJsItem;
	pJsItem = json_object_get(pJson, "byRed");
	pRgb->byRed = (BYTE)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJson, "byGreen");
	pRgb->byGreen = (BYTE)json_integer_value(pJsItem);

	pJsItem = json_object_get(pJson, "byBlue");
	pRgb->byBlue = (BYTE)json_integer_value(pJsItem);
}

static int GetOsdColor(int nInx, MR_RGBA *pRGB)
{
	pRGB->byAlpha = 128;
	if(nInx == 0)			// white
	{
		pRGB->byRed   = 0xFF;
		pRGB->byGreen = 0xFF;
		pRGB->byBlue  = 0xFF;
	}
	else if(nInx == 1)		// red
	{
		pRGB->byRed   = 0xFF;
		pRGB->byGreen = 0;
		pRGB->byBlue  = 0;
	}
	else if(nInx == 2)		// greeb
	{
		pRGB->byRed   = 0;
		pRGB->byGreen = 0xFF;
		pRGB->byBlue  = 0;
	}
	else if(nInx == 3)		// blue
	{
		pRGB->byRed   = 0;
		pRGB->byGreen = 0;
		pRGB->byBlue  = 0xFF;
	}
	else if(nInx == 4)		// yellow
	{
		pRGB->byRed   = 0xFF;
		pRGB->byGreen = 0xFF;
		pRGB->byBlue  = 0;
	}
	else if(nInx == 5)		// black
	{
		pRGB->byRed   = 0;
		pRGB->byGreen = 0;
		pRGB->byBlue  = 0;
	}
	else
	{
		pRGB->byRed   = 0xFF;
		pRGB->byGreen = 0xFF;
		pRGB->byBlue  = 0xFF;
	}
	return 0;
}

static int GetColorIndex(MR_RGBA *pRGB)
{
	if(pRGB->byBlue == 0xFF && pRGB->byGreen == 0xFF && pRGB->byRed == 0xFF)
		return 0;
	else if(pRGB->byBlue == 0 && pRGB->byGreen == 0 && pRGB->byRed == 0xFF)
		return 1;
	else if(pRGB->byBlue == 0xFF && pRGB->byGreen == 0 && pRGB->byRed == 0)
		return 2;
	else if(pRGB->byBlue == 0 && pRGB->byGreen == 0xFF && pRGB->byRed == 0)
		return 3;
	else if(pRGB->byBlue == 0 && pRGB->byGreen == 0xFF && pRGB->byRed == 0xFF)
		return 4;
	else if(pRGB->byBlue == 0 && pRGB->byGreen == 0 && pRGB->byRed == 0)
		return 5;
	return 0;
}
void CDlgOsd::LoadOsdParam()
{
	LONG pMsgHandle = 0;
	int iRet;
	char *pRetCmd  = NULL;
	char *szOsdCmd = NULL, *szTimeCmd = NULL;
	json_t *pJsHead, *pJsType, *pJsItem, *pJsArry, *pJsRet;
	MR_RGBA stRgb;
	
	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, m_pDevice->szIP, m_pDevice->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"GetEnv\":{\"VideoOsd\":{\"nChannel\":0}}}", NULL, &pRetCmd, NULL, 1000);
	if(iRet || !pRetCmd)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	
	pJsHead = json_loads(pRetCmd, 0, NULL);
	if(!pJsHead)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsArry = json_object_get(pJsHead, "stValue");
	if(!pJsArry)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		json_delete(pJsHead);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsRet = json_array_get(pJsArry, 0);
	pJsType = json_object_get(pJsRet, "stTime");
	if(pJsType)
	{
		pJsItem = json_object_get(pJsType, "bEnable");
		((CButton*)GetDlgItem(IDC_CHK_ENTIME))->SetCheck(json_integer_value(pJsItem));

		pJsItem = json_object_get(pJsType, "nXPos");
		m_nTimeX = json_integer_value(pJsItem);

		pJsItem = json_object_get(pJsType, "nYPos");
		m_nTimeY = json_integer_value(pJsItem);

		pJsItem = json_object_get(pJsType, "stFtColor");
		if(pJsItem)
		{
			GetRGBColor(pJsItem, &stRgb);
			((CComboBox*)GetDlgItem(IDC_CMB_TIME_COLOR))->SetCurSel(GetColorIndex(&stRgb));
		}
	}
	
	pJsType = json_object_get(pJsRet, "stTitle");
	if(pJsType)
	{
		const char *szTextName;
		pJsItem = json_object_get(pJsType, "bEnable");
		((CButton*)GetDlgItem(IDC_CHK_ENNAME))->SetCheck(json_integer_value(pJsItem));
		
		pJsItem = json_object_get(pJsType, "nXPos");
		m_nNameX = json_integer_value(pJsItem);
		
		pJsItem = json_object_get(pJsType, "nYPos");
		m_nNameY = json_integer_value(pJsItem);

		pJsItem = json_object_get(pJsType, "szText");
		szTextName = json_string_value(pJsItem);
		if(szTextName)
		{
			char *szText = CCodeTransfer::utf8togb2312Ex(szTextName);
			m_szOsdName = szText;
			delete szText;
		}

		pJsItem = json_object_get(pJsType, "stFtColor");
		if(pJsItem)
		{
			GetRGBColor(pJsItem, &stRgb);
			((CComboBox*)GetDlgItem(IDC_CMB_NAME_COLOR))->SetCurSel(GetColorIndex(&stRgb));
		}
	}
	json_delete(pJsHead);

	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"GetEnv\":{\"SysTime\":{}}}", NULL, &pRetCmd, NULL, 1000);
	if(!iRet && pRetCmd)
	{
		pJsHead = json_loads(pRetCmd, 0, NULL);
		if(!pJsHead)
		{
			MRNSDK_MsgPort_Close(pMsgHandle);
			return;
		}
		pJsRet = json_object_get(pJsHead, "stValue");
		if(!pJsRet)
		{
			MRNSDK_MsgPort_Close(pMsgHandle);
			json_delete(pJsHead);
			return;
		}
		pJsItem = json_object_get(pJsRet, "nDateFormat");
		((CComboBox*)GetDlgItem(IDC_CMB_TIMETYPE))->SetCurSel(json_integer_value(pJsItem));

		pJsItem = json_object_get(pJsRet, "nDateSprtr");
		((CComboBox*)GetDlgItem(IDC_CMB_TIMECHAR))->SetCurSel(json_integer_value(pJsItem));

		json_delete(pJsHead);
	}
	
	MRNSDK_MsgPort_Close(pMsgHandle);
	UpdateData(FALSE);
}

BOOL CDlgOsd::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	((CComboBox*)GetDlgItem(IDC_CMB_TIMETYPE))->SetCurSel(0);
	((CComboBox*)GetDlgItem(IDC_CMB_TIMECHAR))->SetCurSel(1);
	((CComboBox*)GetDlgItem(IDC_CMB_NAME_COLOR))->SetCurSel(0);
	((CComboBox*)GetDlgItem(IDC_CMB_TIME_COLOR))->SetCurSel(0);

	LoadOsdParam();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

static json_t *MakeColorJson(MR_RGBA *pRGB)
{
	json_t *pJsHead = json_object();
	JSON_ADD_INT(pJsHead, "byRed",		pRGB->byRed);
	JSON_ADD_INT(pJsHead, "byGreen",	pRGB->byGreen);
	JSON_ADD_INT(pJsHead, "byBlue",		pRGB->byBlue);
	JSON_ADD_INT(pJsHead, "byAlpha",	pRGB->byAlpha);
	return pJsHead;
}
void CDlgOsd::OnOK() 
{
	LONG pMsgHandle = 0;
	int iRet;
	BOOL bNameOsd, bTimeOsd;
	char *pRetCmd  = NULL;
	char *szOsdCmd = NULL, *szTimeCmd = NULL;
	json_t *pJsHead, *pJsType, *pJsItem, *pJsArry, *pJsRet;
	MR_RGBA stRgb;
	char szCmd[512];
	if(!UpdateData())
		return;

	bNameOsd = ((CButton*)GetDlgItem(IDC_CHK_ENNAME))->GetCheck();
	bTimeOsd = ((CButton*)GetDlgItem(IDC_CHK_ENTIME))->GetCheck();
	if(bNameOsd && m_szOsdName.IsEmpty())
	{
		AfxMessageBox("Please input name!");
		GetDlgItem(IDC_EDT_NAME)->SetFocus();
		return;
	}
	if( ((CComboBox*)GetDlgItem(IDC_CMB_TIMETYPE))->GetCurSel() == -1
		|| ((CComboBox*)GetDlgItem(IDC_CMB_TIMECHAR))->GetCurSel() == -1
		|| ((CComboBox*)GetDlgItem(IDC_CMB_NAME_COLOR))->GetCurSel() == -1
		|| ((CComboBox*)GetDlgItem(IDC_CMB_TIME_COLOR))->GetCurSel() == -1
		)
	{
		AfxMessageBox("Please select the right params!");
		return;
	}
	
	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, m_pDevice->szIP, m_pDevice->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"GetEnv\":{\"VideoOsd\":{\"nChannel\":0}}}", NULL, &pRetCmd, NULL, 1000);
	if(iRet || !pRetCmd)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	
	pJsHead = json_loads(pRetCmd, 0, NULL);
	if(!pJsHead)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsArry = json_object_get(pJsHead, "stValue");
	if(!pJsArry)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		json_delete(pJsHead);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsRet = json_array_get(pJsArry, 0);
	pJsType = json_object_get(pJsRet, "stTime");
	if(pJsType)
	{
		GetOsdColor(((CComboBox*)GetDlgItem(IDC_CMB_TIME_COLOR))->GetCurSel(), &stRgb);
		JSON_ADD_INT(pJsType, "bEnable",	bTimeOsd);
		JSON_ADD_INT(pJsType, "nXPos",		m_nTimeX);
		JSON_ADD_INT(pJsType, "nYPos",		m_nTimeY);
		JSON_ADD_OBJ(pJsType, "stFtColor",	MakeColorJson(&stRgb));
	}

	pJsType = json_object_get(pJsRet, "stTitle");
	if(pJsType)
	{
		char *szText = CCodeTransfer::gb2312toutf8Ex(m_szOsdName);
		GetOsdColor(((CComboBox*)GetDlgItem(IDC_CMB_NAME_COLOR))->GetCurSel(), &stRgb);
		JSON_ADD_INT(pJsType, "bEnable",	bNameOsd);
		JSON_ADD_STR(pJsType, "szText",		szText);
		JSON_ADD_INT(pJsType, "nXPos",		m_nNameX);
		JSON_ADD_INT(pJsType, "nYPos",		m_nNameY);
		JSON_ADD_OBJ(pJsType, "stFtColor",	MakeColorJson(&stRgb));
		delete szText;
	}

	pJsItem = json_object();
	pJsType = json_object();
	JSON_ADD_OBJ(pJsItem, "SetEnv",		pJsType);
	JSON_ADD_OBJ(pJsType, "VideoOsd",	json_copy(pJsArry));
	
	szOsdCmd = json_dumpptr(pJsItem, 4);
	json_delete(pJsItem);
	json_delete(pJsHead);
	
	MRNSDK_MsgPort_SendMsg(pMsgHandle, szOsdCmd, NULL, &pRetCmd, NULL, 1000);
	free(szOsdCmd);

	sprintf(szCmd, "{\"SetEnv\":{\"SysTime\":{\"nDateFormat\":%d, \"nDateSprtr\":%d}}}",
		((CComboBox*)GetDlgItem(IDC_CMB_TIMETYPE))->GetCurSel(), 
		((CComboBox*)GetDlgItem(IDC_CMB_TIMECHAR))->GetCurSel());
	MRNSDK_MsgPort_SendMsg(pMsgHandle, szCmd, NULL, &pRetCmd, NULL, 1000);

	MRNSDK_MsgPort_Close(pMsgHandle);
	CDialog::OnOK();
}
