// DlgModifyIP.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "DlgModifyIP.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgModifyIP dialog


CDlgModifyIP::CDlgModifyIP(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgModifyIP::IDD, pParent)
	, m_mac(_T(""))
{
	//{{AFX_DATA_INIT(CDlgModifyIP)
	m_wDataPort = 0;
	m_szDns1 = _T("");
	m_szDns2 = _T("");
	m_szGetWay = _T("");
	m_szIP = _T("");
	m_wOnvifPort = 0;
	m_szSubmask = _T("");
	m_wWebPort = 0;
	//}}AFX_DATA_INIT
}


void CDlgModifyIP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgModifyIP)
	DDX_Text(pDX, IDC_EDT_DATAPORT, m_wDataPort);
	DDX_Text(pDX, IDC_EDT_DNS1, m_szDns1);
	DDX_Text(pDX, IDC_EDT_DNS2, m_szDns2);
	DDX_Text(pDX, IDC_EDT_GETWAY, m_szGetWay);
	DDX_Text(pDX, IDC_EDT_IP, m_szIP);
	DDX_Text(pDX, IDC_EDT_ONVIFPORT, m_wOnvifPort);
	DDX_Text(pDX, IDC_EDT_SUBMASK, m_szSubmask);
	DDX_Text(pDX, IDC_EDT_WEBPORT, m_wWebPort);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_EDT_MAC, m_mac);
	DDV_MaxChars(pDX, m_mac, 24);
}


BEGIN_MESSAGE_MAP(CDlgModifyIP, CDialog)
	//{{AFX_MSG_MAP(CDlgModifyIP)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgModifyIP message handlers

BOOL CDlgModifyIP::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_wDataPort = m_pDevice->wDataPort;
	m_wWebPort  = m_pDevice->wWebPort;
	m_wOnvifPort= m_pDevice->wOnvifPort;
	m_szIP      = m_pDevice->szIP;
	m_szSubmask = m_pDevice->szSubMask;
	m_szGetWay  = m_pDevice->szGateway;
	m_szDns1    = m_pDevice->szDns1;
	m_szDns2    = m_pDevice->szDns2;
	m_mac		= m_pDevice->szMacAddr;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgModifyIP::OnOK() 
{
	LONG pMsgHandle = 0;
	int iRet;
	char *pRetCmd = NULL;
	char *szTempCmd;
	json_t *pJsHead, *pJsType, *pJsItem, *pJsRet;
	if(!UpdateData())
		return;
	
	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, m_pDevice->szIP, m_pDevice->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"GetEnv\":{\"NetWork\":{}}}", NULL, &pRetCmd, NULL, 1000);
	if(iRet || !pRetCmd)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsHead = json_loads(pRetCmd, 0, NULL);
	if(!pJsHead)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsRet = json_object_get(pJsHead, "stValue");
	if(!pJsRet)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsType = json_object_get(pJsRet, "stBase");
	if(pJsType)
	{
		JSON_ADD_INT(pJsType, "wPortData", m_wDataPort);
		JSON_ADD_INT(pJsType, "wPortWeb",  m_wWebPort);
		JSON_ADD_INT(pJsType, "wPortOnvif",  m_wOnvifPort);
	}
	
	pJsType = json_object_get(pJsRet, "stDns");
	if(pJsType)
	{
		JSON_ADD_STR(pJsType, "szDns1", m_szDns1);
		JSON_ADD_STR(pJsType, "szDns2", m_szDns2);
	}

	pJsType = json_object_get(pJsRet, "stEth");
	if(pJsType)
	{
		pJsItem = json_array_get(pJsType, 0);
		if(pJsItem)
		{
			JSON_ADD_INT(pJsItem, "byValid",   MR_ETHVALID_ENABLE);
			JSON_ADD_STR(pJsItem, "szIPAddr",  m_szIP);
			JSON_ADD_STR(pJsItem, "szSubMask", m_szSubmask);
			JSON_ADD_STR(pJsItem, "szGateway", m_szGetWay);
			JSON_ADD_STR(pJsItem, "szMacAddr", m_mac);
		}
	}
	
	pJsItem = json_object();
	pJsType = json_object();
	JSON_ADD_OBJ(pJsItem, "SetEnv", pJsType);
	JSON_ADD_OBJ(pJsType, "NetWork", json_copy(pJsRet));
	
	szTempCmd = json_dumpptr(pJsItem, 4);
	json_delete(pJsItem);
	json_delete(pJsHead);

	MRNSDK_MsgPort_SendMsg(pMsgHandle, szTempCmd, NULL, &pRetCmd, NULL, 1000);
	free(szTempCmd);

	// reboot
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"SysCtrl\":{\"Reboot\":{}}}", NULL, &pRetCmd, NULL, 1000);
	MRNSDK_MsgPort_Close(pMsgHandle);
	CDialog::OnOK();
}
