// DlgExtUsr.cpp : implementation file
//

#include "stdafx.h"
#include "NetSearch.h"
#include "DlgExtUsr.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgExtUsr dialog


CDlgExtUsr::CDlgExtUsr(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgExtUsr::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgExtUsr)
	m_szBuildDate = _T("");
	m_szDeviceID = _T("");
	m_szDevType = _T("");
	m_szVersion = _T("");
	//}}AFX_DATA_INIT
	m_pDevice = NULL;
}


void CDlgExtUsr::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgExtUsr)
	DDX_Text(pDX, IDC_EDT_BUILDDATE, m_szBuildDate);
	DDX_Text(pDX, IDC_EDT_DEVID, m_szDeviceID);
	DDX_Text(pDX, IDC_EDT_DEVTYPE, m_szDevType);
	DDX_Text(pDX, IDC_EDT_VERSION, m_szVersion);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgExtUsr, CDialog)
	//{{AFX_MSG_MAP(CDlgExtUsr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgExtUsr message handlers

BOOL CDlgExtUsr::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_szVersion.Format("%d.%d.%d.%d", 
			(m_pDevice->stClientVersion.dwKernelBuildDate >> 24) & 0xFF,
			(m_pDevice->stClientVersion.dwKernelBuildDate >> 16) & 0xFF,
			(m_pDevice->stClientVersion.dwKernelBuildDate >> 8) & 0xFF,
			m_pDevice->stClientVersion.dwKernelBuildDate & 0xFF);
	m_szBuildDate.Format("%04d-%02d-%02d",
			(m_pDevice->stClientVersion.dwKernelBuildDate >> 16),
			(m_pDevice->stClientVersion.dwKernelBuildDate >> 8) & 0xff,
			m_pDevice->stClientVersion.dwKernelBuildDate & 0xff);
	m_szDeviceID = m_pDevice->szClientDevID;
	m_szDevType  = m_pDevice->szClientProcName;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgExtUsr::OnOK() 
{
	LONG pMsgHandle = 0;
	int iRet;
	char *pRetCmd = NULL;
	char *szTempCmd;
	json_t *pJsHead, *pJsType, *pJsItem, *pJsRet;
	if(!UpdateData())
		return;
	if(m_szBuildDate.IsEmpty() || m_szDeviceID.IsEmpty() || m_szDevType.IsEmpty() ||m_szVersion.IsEmpty())
	{
		AfxMessageBox("Please input params!");
		return;
	}

	iRet = MRNSDK_MsgPort_Open(&pMsgHandle, m_pDevice->szIP, m_pDevice->wDataPort, "admin", "admin", NULL, 1000);
	if(iRet)
	{
		AfxMessageBox("Connecting device failed!");
		return;
	}
	iRet = MRNSDK_MsgPort_SendMsg(pMsgHandle, "{\"GetEnv\":{\"SysAttr\":{}}}", NULL, &pRetCmd, NULL, 1000);
	if(iRet || !pRetCmd)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsHead = json_loads(pRetCmd, 0, NULL);
	if(!pJsHead)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		AfxMessageBox("Get params failed!");
		return;
	}
	pJsRet = json_object_get(pJsHead, "stValue");
	if(!pJsRet)
	{
		MRNSDK_MsgPort_Close(pMsgHandle);
		json_delete(pJsHead);
		AfxMessageBox("Get params failed!");
		return;
	}

	JSON_ADD_STR(pJsRet, "szClientName",	m_szDevType);
	JSON_ADD_STR(pJsRet, "szClientDevID",  m_szDeviceID);
	JSON_ADD_STR(pJsRet, "szClientDevID",  m_szDeviceID);

	pJsItem = json_object();
	JSON_ADD_INT(pJsItem, "dwKernelVersion",	(1<<24) | (2<<16) | (3<<8) | 4);
	JSON_ADD_INT(pJsItem, "dwKernelBuildDate",	(2014 << 16) | (10 << 8) | 9);
	JSON_ADD_OBJ(pJsRet, "dwKernelBuildDate", pJsItem);

	pJsItem = json_object();
	pJsType = json_object();
	JSON_ADD_OBJ(pJsItem, "SetEnv", pJsType);
	JSON_ADD_OBJ(pJsType, "SysAttr", json_copy(pJsRet));

	szTempCmd = json_dumpptr(pJsItem, 4);
	json_delete(pJsItem);
	json_delete(pJsHead);
	
	MRNSDK_MsgPort_SendMsg(pMsgHandle, szTempCmd, NULL, &pRetCmd, NULL, 1000);
	free(szTempCmd);
	
	MRNSDK_MsgPort_Close(pMsgHandle);

	CDialog::OnOK();
}
