#include "StdAfx.h"
#include "CodeTransfer.h"

CCodeTransfer::CCodeTransfer(void)
{
}


CCodeTransfer::~CCodeTransfer(void)
{
}

int CCodeTransfer::utf8togb2312(const char *szUtf8, char *szmutibyte, int outbuflen)
{
	int iRet;
	int srclen = strlen(szUtf8) + 1;
	int unilen = (srclen << 2);
	WCHAR *szUniCode = new WCHAR[unilen];
	iRet = MultiByteToWideChar(CP_UTF8, 0, szUtf8, srclen, szUniCode, unilen);
	iRet = WideCharToMultiByte(CP_ACP, NULL, szUniCode, iRet, szmutibyte, outbuflen, NULL, NULL);
	delete szUniCode;
	return iRet;
}

int CCodeTransfer::gb2312toutf8(const char *szmutibyte, char *szUtf8, int outbuflen)
{
	int iRet;
	int srclen = strlen(szmutibyte) + 1;
	int unilen = (srclen << 2);
	WCHAR *szUniCode = new WCHAR[unilen];
	iRet = MultiByteToWideChar(CP_ACP, MB_COMPOSITE, szmutibyte, srclen, szUniCode, unilen);
	iRet = WideCharToMultiByte(CP_UTF8, 0, szUniCode, iRet, szUtf8, outbuflen, NULL, NULL);
	szUtf8[outbuflen - 1] = 0;
	delete szUniCode;
	return iRet;
}

char *CCodeTransfer::utf8togb2312Ex(const char *szUtf8)
{
	char *szTemp = NULL;
	int nLen = szUtf8 ? strlen(szUtf8) * 3 : 0;
	szTemp = new char[nLen + 1];
	if(!szTemp)
		return NULL;
	if(szUtf8 && nLen > 0)
		utf8togb2312(szUtf8, szTemp, nLen);
	else
		szTemp[0] = '\0';
	return szTemp;
}

char *CCodeTransfer::gb2312toutf8Ex(const char *szmutibyte)
{
	char *szTemp = NULL;
	int nLen = szmutibyte ? strlen(szmutibyte) * 3 : 0;
	szTemp = new char[nLen + 1];
	if(!szTemp)
		return NULL;
	if(szmutibyte && nLen > 0)
		gb2312toutf8(szmutibyte, szTemp, nLen);
	else
		szTemp[0] = '\0';
	return szTemp;
}
