//libmedserver.h
#ifndef __LIBMEDSERVER_H__
#define __LIBMEDSERVER_H__
#ifdef __cplusplus
extern "C" {
#endif

#if defined(WIN32)
#define LIBMRMS_API		extern __declspec(dllexport)
#define LIBMRMS_CALL	__stdcall
#else
#define LIBMRMS_API
#define LIBMRMS_CALL
#include <netinet/in.h>
#endif//WIN32

#include "MRComm.h"

/* HAVMStream
 * ͨlibavms_addlivestreamķֵ
*/
typedef void* HAVMStream;

/* HAVCStream
 * ͻͨlibavmc_stream_live_single, libavmc_stream_live_multicast, libavmc_stream_vodķֵ
*/
typedef void* HAVCStream;

/* HAVMSG
 * Ϣͨ
*/
typedef void* HAVMSG;

/* HSTranDataPort
 * ͸ͨ
*/
typedef void* HSTranDataPort;

/* HCTranDataPort
 * ͻ͸ͨ
*/
typedef void* HCTranDataPort;

/* HSTranMsgPort
 * ͸Ϣͨ
*/
typedef void* HSTranMsgPort;

/* HCTranMsgPort
 * ͻ͸Ϣͨ
*/
typedef void* HCTranMsgPort;

/* HCMsgChnPort
 * ͻϢͨ
*/
typedef void* HCMsgChnPort;

/* HSrcPushStream
 * 
*/
typedef void* HSrcPushStream;

/* HDstPushStream
 * 
*/
typedef void* HDstPushStream;

/* HCUploadMsgChnPort
 * ͻϴϢ
*/
typedef void* HCUploadMsgChnPort;

// ͨ״̬
typedef enum{
	LIBMS_CHNSTATE_RECONNT = 1,		// ӶϿ, ѯ 1
	LIBMS_CHNSTATE_EXIT,			// ˳
	LIBMS_CHNSTATE_OK = 10,			// 
}LIBMS_CHNSTATE_TYPE;


// ͸֪ͨͨϢṹ
typedef struct{
	MRPARAM_IN HSTranDataPort pDataPort;	// ͸ͨ
	MRPARAM_IN const char *szUserName;		// Զû
	MRPARAM_IN const char *szPassword;		// Զ
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_IN const char *szUserCmd;		// ԶûԶϢ(jsonʽ)
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_OUT char *szRetMsg;				// شϢ(jsonʽ)
	MRPARAM_OUT int  nFifoNums;				// FIFOС
	MRPARAM_OUT int(*fdclosehandle)(HSTranDataPort pTranPort, void *userdata);
	MRPARAM_OUT int(*fddatahandle)(HSTranDataPort pTranPort, MRAVFrame *pkt, void *userdata);
	MRPARAM_OUT void *pUserData;			// û
}LIBMS_TRAN_DATAPORT_NOTIFY_T;

// ͸Ϣ֪ͨͨϢṹ
typedef struct{
	MRPARAM_IN HSTranMsgPort pMsgPort;		// ͸Ϣͨ
	MRPARAM_IN const char *szUserName;		// Զû
	MRPARAM_IN const char *szPassword;		// Զ
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_IN const char *szUserCmd;		// ԶûԶϢ(jsonʽ)
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_OUT char *szRetMsg;				// ûشϢ
	MRPARAM_OUT int(*fdclosehandle)(HSTranMsgPort pTranPort, void *userdata);
	MRPARAM_OUT int(*fdmsghandle)(HSTranMsgPort pMsgPort, const char *szMsg, const char *szFileName, void *userdata);
	MRPARAM_OUT void *pUserData;			// û
}LIBMS_TRAN_MSGPORT_NOTIFY_T;

// ϴ֪ͨϢ
typedef struct{
	MRPARAM_IN HDstPushStream hstream;		// 
	MRPARAM_IN const char *szStreamName;	// 
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_IN int nChannel;				// ͨ
	MRPARAM_IN int nStreamType;				// 
	MRPARAM_IN const char *szUserName;		// û
	MRPARAM_IN const char *szPassword;		// 
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_OUT int(*fdEventHanle)(
			MRPARAM_IN HDstPushStream hstream,
			MRPARAM_IN int nState,			// ״̬, LIBMS_CHNSTATE_TYPE
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT int(*fdRecvHandle)(			// ջص
			MRPARAM_IN HDstPushStream hstream,	// 
			MRPARAM_IN void *userdata,		// û
			MRPARAM_IN MRAVFrame *pkt		// ֡
			);
	MRPARAM_IO void *userdata;				// û, ûøֵ״̬Ϊֵ
}LIBMS_PUSHSTREAM_NOTIFY_T;

typedef struct{
	int rtspport;				// rtsp ˿ , 0 -   Ĭ554
	int rtmpport;				// rtmp ˿ , 0 - , Ĭ1935
	int lvmsport;				// lvms ˿ , 0 - , Ĭ3000
	int brtsp_single;			// ̷߳ͱ־
	int brtmp_single;			// ̷߳ͱ־
	int blvms_single;			// ̷߳ͱ־
	int nTotalStreamUsers;		// û0 - Ϊ
	int bauthentication;		// network stream authentication flag
	char szUserName[MR_SLEN_USERNAME];//camera login name
	char szPassword[MR_SLEN_PASSWORD];//camera login pwd
	char szDownLoadPath[256];	// ϴļĿ¼
	
	/* user_sharke
	 * ûУص
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * Уɹ0Ϊ
    */
	int(*user_sharke)(
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);
	/* stream_request
	 * ûص(ڲûҵ)
	   szStreamName : 
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*stream_request)(
		MRPARAM_IN const char *szStreamName,
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* stream_rights
	 * ȨУص
	   userdata		: û, libavms_addlivestreamвuserdata
	   szStreamName : 
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*stream_rights)(
		MRPARAM_IN void *userdata, 
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* vodfile_rights
	 * 㲥ȨУص
	   szFileName	: ļ
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*vodfile_rights)(
		MRPARAM_IN const char *szFileName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* stream_codec
	 * Ϣص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   stream_inx	: 
	   pcodec		: Ϣָ
	 * 0ΪɹΪ
    */
	int(*stream_codec)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int stream_inx, 
		MRPARAM_IN MRAVSTREAM_T *pcodec
	);

	/* stream_start
	 * /ֹͣص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   bStart	    : TRUE - FALSE - ֹͣ
	 * 0ΪɹΪ
    */
	int(*stream_start)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int bStart
	);

	/* stream_start
	 * ͣ/ָص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   bPause	    : TRUE - ͣFALSE - ָ
	 * 0ΪɹΪ
    */
	int(*stream_pause)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int bPause
	);

	/* stream_start
	 * Ϣ֪ͨص
	   hmsg			: Ϣ
	   szMsg		: Ϣı
	   szFileName	: ļNULLΪЧ
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*msg_handle)(
		MRPARAM_IN HAVMSG hmsg, 
		MRPARAM_IN const char *szMsg, 
		MRPARAM_IN const char *szFileName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac,
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);
	
	/* pushstream_eventhandle
	 * ֪ͨص
	   hstream		: ͻ
	   pNotify		: Ϣṹ
	 * 0ΪɹΪ
    */
	int(*pushstream_eventhandle)(
		MRPARAM_IO LIBMS_PUSHSTREAM_NOTIFY_T *pNotify
	);
	
	/* trandataport_notify
	 * ͸ͨ()ص
	   hstream		: ͻ
	   userdata		: û
	   pkt			: ָ֡
	 * 0ΪɹΪ
    */
	int(*tran_dataport_notify)(
		MRPARAM_IO LIBMS_TRAN_DATAPORT_NOTIFY_T *pNotify
	);

	/* tranmsgport_notify
	 * ͸Ϣͨ()ص
	   hstream		: ͻ
	   userdata		: û
	   pkt			: ָ֡
	 * 0ΪɹΪ
    */
	int(*tran_msgport_notify)(
		MRPARAM_IO LIBMS_TRAN_MSGPORT_NOTIFY_T *pNotify
	);

	/* stream_useroutline
	 * û֪ͨص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   nCurUsers	: ǰû
    */
	void(*stream_useroutline)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata,
		MRPARAM_IN int nCurUsers
	);

	/* user_online_notify
	 * û\֪ͨص
	   bOnLine		: ߱־1 - ߣ0 - 
	   szIP			: IPַ
	   wPort		: ˿
	   szUserName	: û(ʱΪ)
	   szPassword	: (ʱΪ)
	   szDeviceID	: 豸ID
	   userdata		: û, bOnLine = 1ʱ userdataΪMRPARAM_OUT, bOnLine = 0ʱuserdataΪMRPARAM_IN
	 * 0ΪɹΪ룬ز0ڲոû
	 * úƵʱ
	 * , *((void**)userdata) = app user data
	 * , app user data = userdata
    */
	int(*user_online_notify)(
		MRPARAM_IN BOOL  bOnLine,
		MRPARAM_IN const char *szIP,
		MRPARAM_IN WORD wPort,
		MRPARAM_IN const char *szUserName,
		MRPARAM_IN const char *szPassword,
		MRPARAM_IN const char *szDeviceID,
		MRPARAM_IO void *userdata
	);
}LIBAVMS_CONFIG;

// ϴ
typedef struct{
	HSrcPushStream hstream;		// ͨ
	int emProtocol;				// Э飬 MR_NETSTMPRO_TYPE
	int nChannel;				// ͨ
	int nStreamType;			// , 0 - , 1 -  2 - ¼
	const char *szPublishName;	// 
	const char *szServerIP;		// IP
	unsigned short wServerPort;	// ˿
	const char *szUserName;		// û
	const char *szPassword;		// 
	const char *szDeviceID;		// 豸ID		
	
	/* event_handle
	 * ֪ͨص
	   hPushHandle	: , libavms_stream_push_startֵ
	   hstream		: ͨ
	   userdata		: û
	   nState		: ״̬, -1 : ʧܣ0 - ӶϿ1 - ӳɹ
	 * 0ΪɹΪ
    */
	int (*event_handle)(
		MRPARAM_IN void *hPushHandle, 
		MRPARAM_IN HAVMStream hstream, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int nState
	);
}LIBAVMS_PUSHSTRM_PARAM_T;

/******************************************************** ˽ӿ *******************************************/
/* libavms_threadpoll_init
 * ʼ̳߳
   nIniNums		: ʼʱ߳
   nPeekNums	: ÿδ߳
 * ɹ0 Ϊ
 * libavms_initĲΪTRUEҪȵøúʼ̳߳ģ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_threadpoll_init(
								MRPARAM_IN int nIniNums, 
								MRPARAM_IN int nPeekNums
								);

/* libavms_threadpoll_free
 * ж̳߳
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_threadpoll_free();

/* libavms_init
 * ʼAVMSģ
   bUserThreadPoll	: ʹ̳߳ر־
 * ɹ0 Ϊ
 * Ҫʹ̳߳أȵlibavms_threadpoll_initʼ̳߳ģ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_init(
								MRPARAM_IN int bUserThreadPoll
								);

/* libsrt_start
 * SRTģ
   szStreamName	: 
   szIp: ipַ
   nPort: srt ˿
   szKey: ַ
   nKeyLen: ܵĳ֧ 16, 24, 32 
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_start_srt(
								MRPARAM_IN char *szStreamName,
								MRPARAM_IN char *szIp, 
								MRPARAM_IN int nPort,
								MRPARAM_IN char *szKey,
								MRPARAM_IN int nKeyLen);

/* libsrt_stop_srt
 * ֹͣSRTģ
*/
LIBMRMS_API void LIBMRMS_CALL libavms_stop_srt();


/* libavms_start
 * AVMSģ
   pconfig	: ģòNULL
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_start(
								MRPARAM_IN LIBAVMS_CONFIG *pconfig
								);

/* libavms_stop
 * ֹͣAVMSģ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stop();

/* libavms_watchdog
 * Ź
 * ؿŹ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_watchdog();


/* libavms_cleanup
 * жAVMSģ飬Դ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_cleanup();

/* libavms_gettime
 * ʱ
 * ʱλ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_gettime();

/* libavms_addlivestream
 * AVMSģм
   szStreamName : , ûڷʱʹø
   userdata		: û
   nb_streams	: 
   fifonums		: FIFOһΪnb_streams * 50
   nMaxUser		: û0 - 
 * ɹ NULLΪ
*/
LIBMRMS_API HAVMStream LIBMRMS_CALL libavms_addlivestream(
								MRPARAM_IN const char *szStreamName, 
								MRPARAM_IN void *userdata, 
								MRPARAM_IN int nb_streams, 
								MRPARAM_IN int fifonums,
								MRPARAM_IN int nMaxUser
								);

/* libavms_stream_reset
 * λûϿû
   hstream		: 
 * ûС0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_reset(
								MRPARAM_IN HAVMStream hstream
								);

/* libavms_stream_users
 * ͨû
   hstream		: 
   bAllUsers	: TRUE - û, FALSE - ͣû
 * ûС0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_users(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN int bAllUsers
								);

/* libavms_getstream_byname
 * AVMSģл
   szStreamName	: 
 * ɹ NULLΪ
*/
LIBMRMS_API HAVMStream LIBMRMS_CALL libavms_getstream_byname(
								MRPARAM_IN const char *szStreamName
								);

/* libavms_stream_multicat_info
 * 鲥ַ˿ںTTL
   hstream		: 
   szMultiAddr	: 鲥ַ
   wPort		: 鲥˿
   nTTL			: TTL
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_multicat_info(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN const char *szMultiAddr, 
								MRPARAM_IN int wPort, 
								MRPARAM_IN int nTTL
								);

/* libavms_stream_multicast
 * /ֹͣ鲥
   hstream		: 
   bStart		: TRUE - , FALSE - ֹͣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_multicast(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN int bStart
								);

/* libavms_stream_rtp_multicast
 * RTP鲥/ֹͣ
   hstream		: 
   bStart		: TRUE - , FALSE - ֹͣ
   szMultiCastIPaddr : IPַ(bStart = TRUEЧ)
   wPort		: ˿(bStart = TRUEЧ)   
   rtp_udp_way  : 0 rtp鲥1 udp鲥
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_rtp_multicast(
													  MRPARAM_IN HAVMStream hstream, 
													  MRPARAM_IN int bStart,
													  MRPARAM_IN const char *szMultiCastIPaddr,
													  MRPARAM_IN int wPort,
													  MRPARAM_IN int rtp_udp_way
													  );

/* libavms_stream_hls_live
 * hls live/ֹͣ
   hstream		: 
   bStart		: TRUE - , FALSE - ֹͣ
   hls_index	: 0 1
 * ɹ0 Ϊ
*/
int LIBMRMS_CALL libavms_stream_hls_live(
						MRPARAM_IN HAVMStream hstream, 
						MRPARAM_IN int bStart,
						MRPARAM_IN int hls_index
						);

/* libavms_stream_pause
 * ͣ/ֱָ
   hstream		: 
   bPause		: TRUE - ͣ, FALSE - ָ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_pause(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN int bPause
								);

/* libavms_stream_del
 * AVMSģƳ
   hstream		: 
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_del(
								MRPARAM_IN HAVMStream hstream
								);

/* libavms_stream_sendframe
 * һ֡
   hstream		: 
   stream_index : , 0 -  - 1
   media_type   : ͣAVMediaType
   frametype    : ֡, MR_FRAME_TYPE
   pts			: ʱ
   pbuff		: ָ֡
   size			: ֡С
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_sendframe(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN int stream_index, 
								MRPARAM_IN int media_type, 
								MRPARAM_IN int frametype, 
								MRPARAM_IN int pts, 
								MRPARAM_IN unsigned char *pbuff, 
								MRPARAM_IN int size
								);

/* libavms_stream_sendframe_timeout
 * ʱһ֡
   hstream		: 
   stream_index : , 0 -  - 1
   media_type   : ͣAVMediaType
   frametype    : ֡, MR_FRAME_TYPE
   pts			: ʱ
   pbuff		: ָ֡
   size			: ֡С
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_sendframe_timeout(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN int stream_index, 
								MRPARAM_IN int media_type, 
								MRPARAM_IN int frametype, 
								MRPARAM_IN int pts, 
								MRPARAM_IN unsigned char *pbuff, 
								MRPARAM_IN int size, 
								MRPARAM_IN int nTimeOutms
								);

/* libavms_stream_sendavframe
 * һ֡
   hstream		: 
   pAvFrame		: ָ֡
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_sendavframe(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN MRAVFrame *pAvFrame
								);

/* libavms_stream_sendavframe_timeout
 * ʱһ֡
   hstream		: 
   pAvFrame		: ָ֡
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_sendavframe_timeout(
								MRPARAM_IN HAVMStream hstream, 
								MRPARAM_IN MRAVFrame *pAvFrame,
								MRPARAM_IN int nTimeOutms
								);

/* libavms_uploadsendmsg
 * ϴϢ
	nMaskValue	: , 
					0x01 - ź
					0x02 - /ػϢ
					0x04 - GPS
   szMsg		: ϴϢ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_uploadsendmsg(
								MRPARAM_IN int nMaskValue,
								MRPARAM_IN const char *szMsg,
								MRPARAM_IN int nTimeOutms
								);

/* libavms_sendmsg
 * Ϣͻ
   hmsg			: Ϣmsg_handleصеϢ
   szMsg		: Ϣ
   szFileName	: ļ, NULLΪЧ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_sendmsg(
								MRPARAM_IN HAVMSG hmsg, 
								MRPARAM_IN const char *szMsg, 
								MRPARAM_IN const char *szFileName,
								MRPARAM_IN int nTimeOutms
								);

/* libavms_msg_senddata
 * 
   hmsg			: Ϣmsg_handleصеϢ
   szMsg		: Ϣ
   pData		: ָ
   nSize		: ݳ
   nExtData		: չ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_msg_senddata(
								MRPARAM_IN HAVMSG hmsg, 
								MRPARAM_IN const char *szMsg, 
								MRPARAM_IN unsigned char *pData, 
								MRPARAM_IN int nSize, 
								MRPARAM_IN int nExtData,
								MRPARAM_IN int nTimeOutms
								);

/* libavms_msg_close
 * رϢ
   hmsg			: Ϣmsg_handleصеϢ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_msg_close(
								MRPARAM_IN HAVMSG hmsg
								);

/* libavms_regclosehandle
 * עϢرջص
   hmsg			: Ϣmsg_handleصеϢ
   fdCloseHandle: رջص
		hmsg		: Ϣ
		userdata	: û
   userdata		: û
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_regclosehandle(
								MRPARAM_IN HAVMSG hmsg, 
								MRPARAM_IN void(*fdCloseHandle)(
									MRPARAM_IN HAVMSG hmsg, 
									MRPARAM_IN void *userdata
									),
								MRPARAM_IN void *userdata
								);


/* libavms_stream_push_start
 * ʼ
   phHandle			: ؾ
   pPushParam		: Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_push_start(
								MRPARAM_OUT HSrcPushStream *phHandle, 
								MRPARAM_IN LIBAVMS_PUSHSTRM_PARAM_T *pPushParam
								);

/* libavms_stream_push_stop
 * ʼ
   phHandle			: ;libavms_stream_push_start ֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_stream_push_stop(
								MRPARAM_IN HSrcPushStream hHandle
								);

/* libavms_trandataport_senddata
 * ͸ͨ
   pTranPort		: ͸ͨ, صtrandataport_notifyе͸ͨ
   pkt				: ֡
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_trandataport_senddata(
								MRPARAM_IN HSTranDataPort pDataPort,
								MRPARAM_IN MRAVFrame *pkt
								);

/* libavms_trandataport_close
 * ر͸ͨ
   pTranPort		: ͸ͨ, صtrandataport_notifyе͸ͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_trandataport_close(
								MRPARAM_IN HSTranDataPort pDataPort
								);

/* libavms_tranmsgport_sendmsg
 * ͸ϢͨϢ
   pMsgPort			: ͸ͨ, صtranmsgport_notifyе͸ͨ
   szSendMsg		: Ϣ
   szSendFileName	: ͵ļ
   nTimeoutMs		: ͳʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_tranmsgport_sendmsg(
								MRPARAM_IN HSTranMsgPort pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* libavms_tranmsgport_sendrecvmsg
 * ͺͽ͸ϢͨϢ
   pMsgPort			: ͸ͨ, صtranmsgport_notifyе͸ͨ
   szSendMsg		: Ϣ
   szSendFileName	: ͵ļ
   pRecvMsg			: Ϣַָ
   pRecvFileName	: ļַָ
   nTimeoutMs		: ͽճʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_tranmsgport_sendrecvmsg(
								MRPARAM_IN HSTranMsgPort pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_OUT char **pRecvMsg,
								MRPARAM_OUT char **pRecvFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* libavms_tranmsgport_close
 * ر͸Ϣͨ
   pTranPort		: ͸ͨ, صtranmsgport_notifyе͸ͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_tranmsgport_close(
								MRPARAM_IN HSTranMsgPort pMsgPort
								);

/* libavms_trandataport_bind
 * /͸ͨ
   bBind		: TRUE - 󶨣FALSE - 
   pDataPortSrc	: Դ͸ͨ ֻHSTranMsgPortHCTranMsgPort
   pDataPortDst	: Ŀ͸ͨ ֻHSTranMsgPortHCTranMsgPort
 * ɹ0 Ϊ
 * 󶨳ɹûղݻصúҪ͸ݵת(Խڵת)
 * 󶨺ûҲܷ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_trandataport_bind(
								MRPARAM_IN int bBind,			
								MRPARAM_IN void *pDataPortSrc,
								MRPARAM_IN void *pDataPortDst
								);

/* libavms_tranmsgport_bind
 * /͸Ϣͨ
   bBind		: TRUE - 󶨣FALSE - 
   pMsgPortSrc	: ԴϢͨ, ֻHSTranMsgPortHCTranMsgPort
   pMsgPortDst	: ĿϢͨ, ֻHSTranMsgPortHCTranMsgPort
 * ɹ0 Ϊ
 * 󶨳ɹûղϢصúҪϢת
 * 󶨺ûҲܷϢ
*/
LIBMRMS_API int LIBMRMS_CALL libavms_tranmsgport_bind(
								MRPARAM_IN int bBind,
								MRPARAM_IN void *pMsgPortSrc,
								MRPARAM_IN void *pMsgPortDst
								);
/******************************************************** û˽ӿ *******************************************/
typedef struct{
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_IN unsigned short wPort;		// ˿
	MRPARAM_IN const char *szStreamName;	// ƻļ
	MRPARAM_IN const char *szUserName;		// û
	MRPARAM_IN const char *szPassword;		// 
	MRPARAM_IN const char *szDeviceID;		// 豸ID(תʱʹ)
	MRPARAM_IN int   ntimeout;				// ʱʱ䣬
	MRPARAM_IN int (*relink_handle)(		// ص
		HAVCStream hstream,						// 
		int nState,								// ״̬, LIBMS_CHNSTATE_TYPE 1ϵͳԶϿ
		void *userdata							// û
		);
	MRPARAM_IN int (*data_handle)(			// ݻص
		MRPARAM_IN HAVCStream hstream,			// 
		MRPARAM_IN void *userdata,				// û
		MRPARAM_IN MRAVFrame *pkt				// ָ֡
		);
	MRPARAM_IN void *userdata;				// û
}LIBMC_REMOINFO_T;

// Ϣ
typedef struct LIBMC_DOWNLOAD_T{
	MRPARAM_IN char szIP[128];				// IPַ
	MRPARAM_IN unsigned short wPort;		// ˿
	MRPARAM_IN int nTimeoutMs;				// ʱʱ()
	MRPARAM_IN BOOL bUserStopFlag;			// ûֹͣ־
	MRPARAM_IN int  nErrNo;					// մ
	MRPARAM_IN int  nProcess;				// ɰٷֱ
	MRPARAM_IN int  bDownExit;				// ˳־
	MRPARAM_IN void *context;				// û
	MRPARAM_IN uint64_t u64TolSize;			// ܴС
	MRPARAM_IN int (*getdata_handle)(		// ݻص
			MRPARAM_IN struct LIBMC_DOWNLOAD_T *pDonwload,	// ؾ
			MRPARAM_IN int bSeekSet,						// ת
			MRPARAM_IN unsigned char *pData,				// ָ
			MRPARAM_IN int nSize							// ݴС
			);
	MRPARAM_IN void *userdata;				// û
}LIBMC_DOWNLOAD_T;

// ͸ͨϢ
typedef struct{
	MRPARAM_IN const char *szIP;		// IPַ
	MRPARAM_IN unsigned short wPort;	// ˿ں
	MRPARAM_IN const char *szUserName;	// û
	MRPARAM_IN const char *szPassword;	// 
	MRPARAM_IN const char *szDeviceID;	// 豸ID
	MRPARAM_IN int nTimeout;			// ʱʱ()
	MRPARAM_IN void *userdata;			// û
	MRPARAM_IN int nFiFoNums;			// ͵FiFo
	MRPARAM_IN int (*fdCloseHandle)(	// ر֪ͨص
			MRPARAM_IN HCTranDataPort pDataPort, // ͨ
			MRPARAM_IN void *userdata			// û
			);
	// ݻص, pTranPort - ͸ͨ, nState - ״̬(0 - Ͽ1 - ), pkt - ֡, userdata - û
	MRPARAM_IN int (*fdGetDataHandle)(		// ݻص
			MRPARAM_IN HCTranDataPort pDataPort,	// ͨ
			MRPARAM_IN MRAVFrame *pkt,				// ֡
			MRPARAM_IN void *userdata				// û
			);

	MRPARAM_IN const char *szUserCmd;	// ͵ûϢ
	MRPARAM_OUT char *szAckMsg;			// ͵Ϣ
}LIBMC_TRANDATA_PORT_T;

// ͸ϢͨϢ
typedef struct{
	MRPARAM_IN const char *szIP;		// IPַ
	MRPARAM_IN unsigned short wPort;	// ˿ں
	MRPARAM_IN const char *szUserName;	// û
	MRPARAM_IN const char *szPassword;	// 
	MRPARAM_IN const char *szDeviceID;	// 豸ID
	MRPARAM_IN int nTimeout;			// ʱʱ()
	MRPARAM_IN void *userdata;			// û
	MRPARAM_IN int (*fdCloseHandle)(	// Ϣͨر֪ͨص
			MRPARAM_IN HCTranMsgPort pMsgPort,	// Ϣ
			MRPARAM_IN void *userdata			// û
			);
	// Ϣص, pTranPort - ͸ͨ, nState - ״̬(0 - Ͽ1 - ), pkt - ֡, userdata - û
	MRPARAM_IN int (*fdGetMsgHandle)(			// Ϣص
			MRPARAM_IN HCTranMsgPort pMsgPort,		// Ϣ
			MRPARAM_IN const char *szMsg,			// Ϣ
			MRPARAM_IN const char *szFileName,		// ļ
			MRPARAM_IN void *userdata				// û
			);
	
	MRPARAM_IN const char *szUserCmd;	// ͵ûϢ
	MRPARAM_OUT char *szAckMsg;			// ͵Ϣ
}LIBMC_TRANMSG_PORT_T;


/* libavmc_setdowndir
 * ļʱĿ¼
   szDir		: Ŀ¼
 * ɹ0 Ϊ
 * Ѿ÷ˣҪٵøú
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_setdowndir(
								MRPARAM_IN const char *szDir
								);

/* libavmc_stream_live_single
 * ʼ
   phstream		: صͨ
   emProtocol	: Э, MR_NETSTMPRO_TYPE
   pRemoInfo	: Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_live_single(
								MRPARAM_IN HAVCStream *phstream, 
								MRPARAM_IN int emProtocol, 
								MRPARAM_IN LIBMC_REMOINFO_T *pRemoInfo
								);

/* libavmc_stream_live_multicast
 * ʼ鲥(ʹ鲥)
   phstream		: صͨ
   emProtocol	: Э, MR_NETSTMPRO_TYPE
   pRemoInfo	: Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_live_multicast(
								MRPARAM_IN HAVCStream *phstream, 
								MRPARAM_IN int emProtocol, 
								MRPARAM_IN LIBMC_REMOINFO_T *pRemoInfo
								);

/* libavmc_stream_vod
 * ʼ㲥
   hstream		: ͨ
   emProtocol	: Э, MR_NETSTMPRO_TYPE
   pRemoInfo	: Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_vod(
								MRPARAM_IN HAVCStream *phstream, 
								MRPARAM_IN int emProtocol, 
								MRPARAM_IN LIBMC_REMOINFO_T *pRemoInfo
								);

/* libavmc_stream_settimeout
 * ճʱʱ
   hstream		: ͨ
   nTimeoutSecs	: ʱʱ()
 * ɹ0 Ϊ
 * 񳬹ʱղݺϿ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_settimeout(
								MRPARAM_IN HAVCStream hstream, 
								MRPARAM_IN int nTimeoutSecs
								);

/* libavmc_stream_stream_nb
 * 
   hstream		: ͨ
 * С0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_stream_nb(
								MRPARAM_IN HAVCStream hstream
								);

/* libavmc_stream_getstrminfo
 * Ϣ
   hstream		: ͨ
   nIndex		: , 0 - stream_nb - 1
   pStream		: صϢָ
 * С0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_getstrminfo(
								MRPARAM_IN HAVCStream hstream, 
								MRPARAM_IN int nIndex, 
								MRPARAM_OUT MRAVSTREAM_T *pStream
								);

/* libavmc_stream_vod_getindex
 * õ㲥
   hstream		: ͨ
   pbuffer		: ַָ
 * СС0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_vod_getindex(
								MRPARAM_IN HAVCStream hstream, 
								MRPARAM_IN unsigned char **pbuffer
								);

/* libavmc_stream_stop
 * ֹͣ
   hstream		: ͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_stop(
								MRPARAM_IN HAVCStream hstream
								);

/* libavmc_stream_start
 * ʼ
   hstream		: ͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_start(
								MRPARAM_IN HAVCStream hstream
								);

/* libavmc_stream_pause
 * ͣ/طŲ
   hstream		: ͨ
   bPause		: TRUE - ͣ FALSE - ָ
 * ɹ0 Ϊ
 * ָ֪ͨͣգͣͣݷͣԽԼԴ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_pause(
								MRPARAM_IN HAVCStream hstream, 
								MRPARAM_IN int bPause
								);

/* libavmc_stream_vod_seektime
 * 㲥ת
   hstream		: ͨ
   ntime		: תʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_stream_vod_seektime(
								MRPARAM_IN HAVCStream hstream, 
								MRPARAM_IN int ntime
								);

/* libavmc_multicastdatarecv_start
 * 鲥ͨ
   pRecvPort		: վ
   szMultiCast		: 鲥ַ
   wPort			: 鲥˿
   fdRecvHandle		: ݻص
		pRecvPort		: 
		pkt				: ָ֡
		userdata		: û
   userdata			: û
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_multicastdatarecv_start(
								MRPARAM_OUT void **pRecvPort,
								MRPARAM_IN const char *szMultiCast, 
								MRPARAM_IN unsigned short wPort, 
								MRPARAM_IN void(*fdRecvHandle)(
									MRPARAM_IN void *pRecvPort,
									MRPARAM_IN MRAVFrame *pkt,
									MRPARAM_IN void *userdata
									), 
								MRPARAM_IN void *userdata
								);

/* libavmc_multicastdatarecv_stop
 * ֹͣ鲥ݽ
   pRecvPort		: 鲥վ, libavmc_multicastdatarecv_startֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_multicastdatarecv_stop(
								MRPARAM_IN void *pRecvPort
								);

/* libavmc_multicastdatasend_start
 * 鲥ͨ
   pSendPort		: ؾ
   bStart			: /ֹͣ־
   szMultiCast		: 鲥ַ
   wPort			: 鲥˿
   nFifoNum			: 
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_multicastdatasend_start(
								MRPARAM_OUT void **pSendPort,
								MRPARAM_IN const char *szMultiCast, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN int nFifoNum
								);

/* libavmc_multicastdatasend_sendframe
 * 
   pSendPort		: 鲥;, libavmc_multicastdatasend_start ֵ
   pkt				: ֡
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_multicastdatasend_sendframe(
								MRPARAM_IN void *pSendPort,
								MRPARAM_IN MRAVFrame *pkt
								);

/* libavmc_multicastdatasend_stop
 * ֹͣ鲥ͨ
   pSendPort		: 鲥;, libavmc_multicastdatasend_start ֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_multicastdatasend_stop(
								MRPARAM_IN void *pSendPort
								);

/* libavmc_uploadmsgchn_open
 * ϴϢͨ
   pMsg			: Ϣ
   szIP			: IPַ
   wPort		: ˿
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   nMaskValue	: , 
					0x01 - ź
					0x02 - /ػϢ
					0x04 - GPS
					-1 - ϴϢ
   nTimeOutMs	: ӳʱʱ()
   fdEventHandle: ״̬֪ͨص
		pMsg	: Ϣlibavmc_uploadmsgchn_openֵ
		nState  : ״̬, 1 - ߣ0 - , ʱ1ֵϿ
		userdata: û
   fdRecvMsgHandle	: Ϣص
		pMsg	: Ϣlibavmc_uploadmsgchn_openֵ
		szMsg   : յϢ
		userdata: û
   userdata		: û
 * ɹ0 Ϊ
 * ʹϴϢͨ豸ź
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_uploadmsgchn_open(
								MRPARAM_OUT HCUploadMsgChnPort *pMsg, 
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nMaskValue,
								MRPARAM_IN int nTimeOutMs,
								MRPARAM_IN int(*fdEventHandle)(
											MRPARAM_IN HCUploadMsgChnPort pMsg, 
											MRPARAM_IN int nState,
											MRPARAM_IN void *userdata
											),
								MRPARAM_IN void(*fdRecvMsgHandle)(
											MRPARAM_IN  HCUploadMsgChnPort pMsg, 
											MRPARAM_IN const char *szMsg, 
											MRPARAM_IN void *userdata
											),
								MRPARAM_IN void *userdata
								);

/* libavmc_uploadmsgchn_close
 * رϴϢͨ
   pMsg		: Ϣ, libavmc_uploadmsgchn_open ֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_uploadmsgchn_close(
								MRPARAM_IN HCUploadMsgChnPort pMsg
								);

/* libavmc_msgchn_open
 * Ϣͨ
   pMsg			: Ϣ
   szIP			: IPַ
   wPort		: ˿
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   nTimeOutMs	: ӳʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_msgchn_open(
								MRPARAM_OUT HCMsgChnPort *pMsg, 
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeOutMs
								);

/* libavmc_msgchn_sendmsg
 * ͽϢ
   pMsg				: Ϣ, libavmc_msgchn_open ֵ
   szIP				: IPַ
   szSendMsg		: ͵Ϣ
   szSendFileName	: ͵ļ
   szRecvMsg		: Ϣַָ
   szRecvFileName	: ļַָ
   nTimeOutMs		: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_msgchn_sendmsg(
								MRPARAM_IN HCMsgChnPort hMsg, 
								MRPARAM_IN const char *szSendMsg, 
								MRPARAM_IN const char *szSendFileName, 
								MRPARAM_IN char **szRecvMsg, 
								MRPARAM_IN char **szRecvFileName,
								MRPARAM_IN int nTimeOutMs
								);

/* libavmc_msgchn_close
 * رϢͨ
   pMsg				: Ϣ, libavmc_msgchn_openֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_msgchn_close(
								MRPARAM_IN HCMsgChnPort hMsg
								);

/* libavmc_trandataport_open
 * ͸ͨ
   pDataPort	: Ϣ
   pInfo		: ͸ͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_trandataport_open(
								MRPARAM_IN HCTranDataPort *pDataPort, 
								MRPARAM_IN LIBMC_TRANDATA_PORT_T * pInfo
								);

/* libavmc_trandataport_sendframe
 * ͸ͨһ֡
   pDataPort : Ϣ, libavmc_trandataport_open ֵ
   pkt		 : ָ֡
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_trandataport_sendframe(
								MRPARAM_IN HCTranDataPort pDataPort, 
								MRPARAM_IN MRAVFrame *pkt
								);

/* libavmc_trandataport_close
 * ر͸ͨ
   pDataPort		: Ϣ, libavmc_trandataport_open ֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_trandataport_close(
								MRPARAM_IN HCTranDataPort pDataPort
								);

/* libavmc_tranmsgport_open
 * ͸Ϣͨ
   pMsgPort	: Ϣ
   pInfo	: ͸Ϣͨ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_tranmsgport_open(
								MRPARAM_IN HCTranMsgPort *pMsgPort, 
								MRPARAM_IN LIBMC_TRANMSG_PORT_T * pInfo
								);

/* libavmc_tranmsgport_open
 * Ϣ
   pMsgPort			: Ϣ libavmc_tranmsgport_open ֵ
   szSendMsg		: ͵Ϣָ
   szSendFileName	: ͵ļ
   nTimeoutMs		: ͳʱʱ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_tranmsgport_sendmsg(
								MRPARAM_IN HCTranMsgPort pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* libavmc_tranmsgport_sendrecvmsg
 * ͺͽϢ
   pMsgPort			: Ϣ libavmc_tranmsgport_open ֵ
   szSendMsg		: ͵Ϣָ
   szSendFileName	: ͵ļ
   pRecvMsg			: Ϣַָ
   pRecvFileName    : ļַָ
   nTimeoutMs		: ͺͽճʱʱ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_tranmsgport_sendrecvmsg(
								MRPARAM_IN HCTranMsgPort pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_OUT char **pRecvMsg,
								MRPARAM_OUT char **pRecvFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* libavmc_tranmsgport_close
 * ر͸Ϣͨ
   pMsg		: Ϣ, libavmc_tranmsgport_open ֵ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_tranmsgport_close(
								MRPARAM_IN HCTranMsgPort pMsgPort
								);

/* libavmc_download_open
 * ļ
   pDown		: Ϣ
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   szFileName	: ļ
   nStTime		: ʼʱ
   nEdTime		: ʱ䣬0 - Ϊļ
   nTimeroutMs	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_download_open(
								MRPARAM_IN LIBMC_DOWNLOAD_T *pDown, 
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szFileName,
								MRPARAM_IN int nStTime, 
								MRPARAM_IN int nEdTime,
								MRPARAM_IN int nTimeroutMs
								);

/* libavmc_downloadcut_open
 * ļ
   pDown		: Ϣ
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   szFileName	: ļ
   szCutInx		: 
   nTimeroutMs	: ʱʱ()
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_downloadcut_open(
								MRPARAM_IN LIBMC_DOWNLOAD_T *pDown, 
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szFileName,
								MRPARAM_IN const char *szCutInx,
								MRPARAM_IN int nTimeroutMs
								);

/* libavmc_download_close
 * ֹͣ
   pDown		: Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_download_close(
								MRPARAM_IN LIBMC_DOWNLOAD_T *pDown
								);

/********************************************************  *******************************************/
/* libavmc_netsearch_start
 * ʼ
   szIPAddr		 : IPַ(ʱʹ)
   nTimeoutMs	 : ʱʱ(ms)
   fdNetSearchCB : ջص
        szDeviceID	: 豸ID
		szInfo		: 豸Ϣ(JSONʽ)
		userdata	: û
   userdata		 : û
 * ɹ豸С0Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_start(
								MRPARAM_IN const char *szIPAddr,
								MRPARAM_IN int nTimeoutMs, 
								MRPARAM_IN void(*fdNetSearchCB)(
								    MRPARAM_IN const char *szDeviceID,
									MRPARAM_IN const char *szInfo, 
									MRPARAM_IN void *userdata
									), 
								MRPARAM_IN void *userdata
								);

/* libavmc_netsearch_setparam
 * ʼ
   szDeviceID	 : 豸ID
   szParam		 : (JSONʽ)
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_setparam(
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szParam
								);

/* libavmc_netsearch_control
 * 豸(֧Ĭϲ)
   szDeviceID	 : 豸ID
   szCmd		 : Ŀǰ֧SapReboot()SapDefault(Ĭ)
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_control(
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szCmd
								);

/* libavmc_netsearch_sendcmd
 * 豸(֧Ĭϲ)
   pCmd		     : 
   nCmdLen		 : pCmd
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_sendcmd(
													   MRPARAM_IN unsigned char *pCmd,
													   MRPARAM_IN int nCmdLen
													   );

/* libavmc_netsearch_fptupdate
 * FTP豸
   szFtpIP		: FTPIP
   wFtpPort		: FTP˿
   szFtpDir		: FTPĿ¼
   szFtpName	: FTPû
   szFtpPsw		: FTP
   szFileName	: ļ
 * ɹ0 Ϊ
 * 豸յϢͨFTPļ豸ƥ䣬Զ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_fptupdate(
								MRPARAM_IN const char *szFtpIP, 
								MRPARAM_IN unsigned short wFtpPort, 
								MRPARAM_IN const char *szFtpDir, 
								MRPARAM_IN const char*szFtpName, 
								MRPARAM_IN const char *szFtpPsw, 
								MRPARAM_IN const char *szFileName
								);

LIBMRMS_API int LIBMRMS_CALL libavmc_netsearch_fptupdatedevice(
								MRPARAM_IN const int fd, 
								MRPARAM_OUT char *szMac);

LIBMRMS_API void LIBMRMS_CALL libavmc_netsearch_fptupdatedevicestop(MRPARAM_IN const int fd);

/************************************************************************/
/* PTZЭ(pelco_p, pelco_d, visca)                                 */
/************************************************************************/
/* libavmc_netptzcmdserver_start
 * ʼPTZЭ
   szIP				: IPַ,NULLΪ
   wPort			: 󶨵Ķ˿(TCPUDP)
   fdRecvHandleCB	: ݻص
		context	: 
		pAddr   : ߵַ
		pCmd    : ָ
		nCmdLen : ݳ
		userdata: û
   userdata			: û
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netptzcmdserver_start(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN void(*fdRecvHandleCB)(
											MRPARAM_IN void *context, 
											MRPARAM_IN struct sockaddr_in *pAddr, 
											MRPARAM_IN unsigned char *pCmd, 
											MRPARAM_IN int nCmdLen, 
											MRPARAM_IN void *userdata), 
								MRPARAM_IN void *userdata
								);

/* libavmc_netptzcmdserver_send
 * Ϣ
   context		: ָ, fdRecvHandleCBĵһ
   pAddr        : ֵַ fdRecvHandleCBĵڶ
   pCmd         : ͵Ϣָ
   nCmdLen      : Ϣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netptzcmdserver_send(
								MRPARAM_IN void *context, 
								MRPARAM_IN struct sockaddr_in *pAddr, 
								MRPARAM_IN unsigned char *pCmd, 
								MRPARAM_IN int nCmdLen
								);

/* libavmc_netptzcmdserver_stop
 * ֹͣ
 * ɹ0 Ϊ
*/
LIBMRMS_API int LIBMRMS_CALL libavmc_netptzcmdserver_stop(void);

#ifdef __cplusplus
}
#endif
#endif//__LIBMEDSERVER_H__
