//libavparam.h
#ifndef __LIB_AVPARAM_H__
#define __LIB_AVPARAM_H__

#ifdef __cplusplus
extern "C" {
#endif

#if defined(WIN32)
#define LIBMRAVP_API	extern __declspec(dllexport)
#define LIBMRAVP_CALL	__stdcall
#else
#define LIBMRAVP_API
#define LIBMRAVP_CALL
#include <netinet/in.h>
#endif//WIN32

#include "MRComm.h"
#include "MRSdkCmd.h"

LIBMRAVP_API int LIBMRAVP_CALL libmravparam_init(void);
LIBMRAVP_API int LIBMRAVP_CALL libmravparam_cleanup(void);

LIBMRAVP_API int LIBMRAVP_CALL libmravparam_set_timeout(
								MRPARAM_IN int nTimeOutMS
								);

LIBMRAVP_API int LIBMRAVP_CALL librmconfc_env_get(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN const char *szEnvCmd, 
								MRPARAM_IN int nEnvParamSize,
								MRPARAM_OUT void* pEnvParam
								);

LIBMRAVP_API int LIBMRAVP_CALL librmconfc_env_set(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN const char *szEnvCmd, 
								MRPARAM_IN int nEnvParamSize,
								MRPARAM_IN void* pEnvParam
								);
				
LIBMRAVP_API int LIBMRAVP_CALL librmconfc_state_query(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN const char *szQueryCmd, 
								MRPARAM_IN int nParamSize,
								MRPARAM_OUT void *pParam
								);

LIBMRAVP_API int LIBMRAVP_CALL librmconfc_syscontrol(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN const char *szCtrlCmd, 
								MRPARAM_IN int nParamSize,
								MRPARAM_OUT void *pParam
								);
#ifdef __cplusplus
}
#endif
#endif//__LIB_AVPARAM_H__
