//libavformat.h
#ifndef __LIBAVFORMAT_H__
#define __LIBAVFORMAT_H__
#ifdef __cplusplus
extern "C" {
#endif
	
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
	
#ifdef LINUX
#include <unistd.h>
#include <inttypes.h>
#include <sys/types.h>
#endif//LINUX

#include "MRComm.h"

typedef void *MRAVHANDLE;

/***************************************************** ʽ ********************************************************/
/* libav_format_type
 * øʽ
	phandle : 
 * ش(MR_PACKTYPE_TYPE), Ϊ
*/
int libav_format_type(MRAVHANDLE phandle);

/* libav_format_extname
 * øʽ
	phandle : 
 * ظʽ
*/
const char* libav_format_extname(MRAVHANDLE phandle);

/* libav_format_stream_curpts
 * õǰʱ
	phandle : 
	index   : , (0 - -1)
 * ʱ
*/
unsigned int libav_format_stream_curpts(MRAVHANDLE phandle, int index);

/* libav_format_streams
 * 
	phandle : 
 * 
*/
int libav_format_streams(MRAVHANDLE phandle);

/* libav_format_videochs
 * Ƶͨ
	phandle : 
 * Ƶͨ
*/
int libav_format_videochs(MRAVHANDLE phandle);

/* libav_format_stream
 * ԻϢ
	phandle : 
	index   : , (0 - -1)
	pStream : Ϣָ
 * 0ɹΪֵ
*/
int libav_format_stream(MRAVHANDLE phandle, int nIndex, MRAVSTREAM_T *pStream);

/* libav_format_stream_byid
 * idϢ
	phandle : 
	id      : id
	pStream : Ϣָ
 * 0ɹΪֵ
*/
int libav_format_stream_byid(MRAVHANDLE phandle, int id, MRAVSTREAM_T *pStream);

/* libav_format_setidx_dir
 * Ŀ¼
	phandle  : 
	szInxDir : Ŀ¼
 * 0ɹΪֵ
*/
int libav_format_setidx_dir(MRAVHANDLE phandle, const char *szInxDir);

/* libav_output_typevalid
 * жϴǷЧ(֧)
	avtype   : (MR_PACKTYPE_TYPE)
 * 1֧֣0 ֧
*/
int libav_output_typevalid(int avtype);

/* libav_output_open
 * ļ
	ppOutput : ָ
	avtype   : (MR_PACKTYPE_TYPE)
	bStream  : TRUE - ʽFALSE - ļʽ
 * 0ɹΪֵ
*/
int libav_output_open(MRAVHANDLE *ppOutput, int avtype, int bStream);

/* libav_output_close
 * رմ
	ppOutput : 
 * 0ɹΪֵ
*/
int libav_output_close(MRAVHANDLE pOutput);

/* libav_output_reset
 * λ
	pOutput : 
 * 0ɹΪֵ
 * ڿʼµһδʱҪøúλ
*/
int libav_output_reset(MRAVHANDLE pOutput);

/* libav_output_newstream
 * 
	pOutput : 
	pStream : Ϣ
 * 0ɹΪֵ
*/
int libav_output_newstream(MRAVHANDLE pOutput, MRAVSTREAM_T *pStream);

/* libav_output_write_head
 * 
	pOutput : 
	pOut    : ͷϢָ
	szPassword : ĿǰûʹãʹʱóNULL
 * 0ɹΪֵ
*/
int libav_output_write_head(MRAVHANDLE pOutput, MRAVEncFrame *pOut, const char *szPassword);

/* libav_output_write_config
 * ĿǰҪʹ
	pOutput : 
 * 0ɹΪֵ
*/
int libav_output_write_config(MRAVHANDLE pOutput, MRAVFrame *pkt, MRAVEncFrame *pOut);

/* libav_output_flv_config
 * FLVרô
	pOutput : 
 * 0ɹΪֵ
*/
int libav_output_flv_config(MRAVHANDLE pOutput, int codec_type, MRAVFrame *pkt, MRAVEncFrame *pOut);

/* libav_output_write_frame
 * һ֡
	pOutput : 
	pkt     : ֡
	pOut    : ֡
 * 0ɹΪֵ
*/
int libav_output_write_frame(MRAVHANDLE pOutput, MRAVFrame *pkt, MRAVEncFrame *pOut);

/* libav_output_write_frame_nobuff
 * δʹ
	pOutput : 
	pkt     : ֡
	pOutBuff: ָ
 * شȣС0Ϊ
*/
int libav_output_write_frame_nobuff(MRAVHANDLE pOutput, MRAVFrame *pkt, unsigned char **pOutBuff);

/* libav_output_write_trailer
 * ֹͣ
	pOutput : 
	pOut    : ֡
 * 1Ҫµlibav_output_write_headдͷ0 - ѲҪС0Ϊ
*/
int libav_output_write_trailer(MRAVHANDLE pOutput, MRAVEncFrame *pOut);

/* libav_output_write_pause
 * ͣ/ָ
	pOutput : 
	bPause  : TRUE - ͣFALSE - ָ
 * 0ɹΪֵ
*/
int libav_output_write_pause(MRAVHANDLE pOutput, int bPause);

/* libav_output_write_endhead
 * жֹͣǷҪдļͷ
	pOutput : 
 * 1Ҫµlibav_output_write_headдͷ0 - ѲҪС0Ϊ
*/
int libav_output_write_endhead(MRAVHANDLE pOutput);


/***************************************************** ļ ********************************************************/

/* libav_input_open
 * ļ
	ppInput     : ָ
	szFileName  : ļ 
	extern_data : TRUE - չ
 * 0ɹΪֵ
*/
int libav_input_open(MRAVHANDLE *ppInput, const char *szFileName, int extern_data);

/* libav_input_openpos
 * ļ
	ppInput     : ָ
	szFileName  : ļ 
	extern_data : TRUE - չ
	stPos       : ļʼλ
	edPos       : ļλ
 * 0ɹΪֵ
*/
int libav_input_openpos(MRAVHANDLE *ppInput, const char *szFileName, int extern_data, int64_t stPos, int64_t edPos);

/* libav_input_openpos
 * ļ
	ppInput     : ָ
	szFileName  : ļ 
	extern_data : TRUE - չ
	stPos       : ļʼλ
	edPos       : ļλ
	bBuildIndex : TRUE - ļʱ
 * 0ɹΪֵ
*/
int libav_input_openpos_index(MRAVHANDLE *ppInput, const char *szFileName, int extern_data, int64_t stPos, int64_t edPos, int bBuildIndex);

/* libav_input_password
 * ļ
	pInput      : ָ
 * ļ룬󷵻NULL
*/
char *libav_input_password(MRAVHANDLE pInput);

/* libav_input_checkpassword
 * Уļ
	pInput      : ָ
	szPassword  : 
 * 0ɹΪֵ
*/
int libav_input_checkpassword(MRAVHANDLE pInput, const char *szPassword);

/* libav_input_close
 * رս
	pInput      : ָ
 * 0ɹΪֵ
*/
int libav_input_close(MRAVHANDLE pInput);

/* libav_input_curpts
 * õǰʱ
	pInput      : ָ
	stream_index: stream_indexΪ-1صһ·Ƶĵǰʱ
 * ʱ
*/
int libav_input_curpts(MRAVHANDLE pInput, int stream_index);

/* libav_input_duration
 * ļĳʱ
	pInput      : ָ
 * سʱ
*/
int64_t libav_input_duration(MRAVHANDLE pInput);

/* libav_input_tolalframes
 * ֡
	pInput      : ָ
	stream_index: stream_indexΪ-1صһ·Ƶ֡
 * ʱ
*/
unsigned int libav_input_tolalframes(MRAVHANDLE pInput, int stream_index);

/* libav_input_filesize
 * ļĴС
	pInput      : ָ
 * ļС
*/
int64_t libav_input_filesize(MRAVHANDLE pInput);

/* libav_input_curpos
 * õǰλ
	pInput      : ָ
 * صǰλ
*/
int64_t libav_input_curpos(MRAVHANDLE pInput);

/* libav_input_getframe
 * һ֡
	pInput      : ָ
	pkt         : ֡
 * ֡СС0Ϊ
*/
int libav_input_getframe(MRAVHANDLE pInput, MRAVFrame *pkt);

/* libav_input_getprekeyframe
 * һؼ֡
	pInput      : ָ
	pkt         : ֡
 * ֡СС0Ϊ
*/
int libav_input_getprekeyframe(MRAVHANDLE pInput, MRAVFrame *pkt);

/* libav_input_getdata
 * 
	pInput      : ָ
	pkt         : ֡
 * ݣС0Ϊ
*/
int libav_input_getdata(MRAVHANDLE pInput, MRAVFrame *pkt);

/* libav_input_seektime
 * ļת(ʱ)
	pInput      : ָ
	stream_index: (Ŀǰδʹ)
	nSeconds    : ת
 * ݣС0Ϊ
*/
int libav_input_seektime(MRAVHANDLE pInput, int stream_index, int nSeconds);

/* libav_input_seekframeinx
 * ļת(֡)
	pInput      : ָ
	stream_index: (Чʱʹõһ·Ƶ)
	nframeinx   : ֡( 0 - total frames - 1)
 * ݣС0Ϊ
*/
int libav_input_seekframeinx(MRAVHANDLE pInput, int stream_index, unsigned int nframeinx);

/* libav_input_seekpos
 * ļת(λ)
	pInput      : ָ
	i64Pos      : ļλ
 * ݣС0Ϊ
 * ʹøúȷi64PosЧ(֡λ)
*/
int libav_input_seekpos(MRAVHANDLE pInput, int64_t i64Pos);

/* libav_input_raw_getfilehead
 * ļԭʼļͷ
	pInput      : ָ
	pkt         : ͷ
 * ݳȣС0Ϊ
*/
int libav_input_raw_getfilehead(MRAVHANDLE pInput, MRAVFrame *pkt);

/* libav_input_raw_getframe
 * һ֡ݣļ֡ͷ
	pInput      : ָ
	pkt         : ͷ
 * ݳȣС0Ϊ
*/
int libav_input_raw_getframe(MRAVHANDLE pInput, MRAVFrame *pkt);

/* libav_input_parserawframe
 * ԭʼ֡
	pInput      : ָ
	pRawData	: ԭʼ֡
	nRawSize	: ֡ݳ
	pkt         : ֡ݣdataΪָ֡
 * ݳȣС0Ϊ
*/
int libav_input_parserawframe(MRAVHANDLE pInput, unsigned char *pRawData, int nRawSize, MRAVFrame *pkt);

/* libav_aac_adtstoasc_filter
 * AACͷ
*/
int libav_aac_adtstoasc_filter(int bFirstFrame, MRSTREAM_EXTDATA_T *pExtData, 
							  unsigned char **poutbuf, int *poutbuf_size,
                              unsigned char *buf, int  buf_size);

/* libav_aac_adtsenc
 * AACͷ
*/
int libav_aac_adtsenc(unsigned char *pBuf, int framesize, int objecttype, int sample_rate_index, int channel_conf);

#ifdef __cplusplus
}
#endif
#endif//__LIBAVFORMAT_H__
