//MRPlaySdkApi.h
#ifndef __MRPLAYSDK_API_H__
#define __MRPLAYSDK_API_H__

#include "MRNetSdkApi.h"

#ifdef __cplusplus
extern "C" {
#endif

// ŽʹϢ֪ͨ
// ļҪ֡
// ļʽ֧

#define MRPLAYSDK_API		extern "C"__declspec(dllexport)
#define MRPLAYSDK_CALL		__stdcall


/* fdMRPSdkSizeChangeCallBack
 * ͼߴıص
   lChn			: ž
   stream_index	: Ƶͨ
   nOldWidth	: ıǰ
   nOldHeight	: ıǰ߶
   nNewWidth	: ı
   nNewHeight	: ı߶
   context      : û
*/
typedef void (*fdMRPSdkSizeChangeCallBack)(
							MRPARAM_IN LONG lChn, 
							MRPARAM_IN int stream_index,
							MRPARAM_IN int nOldWidth,
							MRPARAM_IN int nOldHeight,
							MRPARAM_IN int nNewWidth, 
							MRPARAM_IN int nNewHeight, 
							MRPARAM_IN void *context
							);

typedef enum{
	MRPSDK_MODE_BACKKEYFRAME = 12,	// ؼ֡˲
	MRPSDK_MODE_16X   = 11,			// 16
	MRPSDK_MODE_8X    = 10,			// 8
	MRPSDK_MODE_4X    = 9,			// 4
	MRPSDK_MODE_2X    = 8,			// 2
	MRPSDK_MODE_PLAY  = 7,			// 
	MRPSDK_MODE_1X16  = 6,			// 1/16
	MRPSDK_MODE_1X8   = 5,			// 1/8
	MRPSDK_MODE_1X4   = 4,			// 1/4
	MRPSDK_MODE_1X2   = 3,			// 1/2
	MRPSDK_MODE_STEP  = 2,			// 
	MRPSDK_MODE_PAUSE = 1			// ͣ
}MRPSDK_MODE_TYPE;

/* MRPSDK_Init
 * ʼſ
 * ɹ0 Ϊֵ
 * ʹøģʱȵиúʼģ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Init(void);

/* MRPSDK_Cleanup
 * жزſ
 * ɹ0 Ϊֵ
 * ֹͣʹòſʱøúԴ
*/
MRPLAYSDK_API void MRPLAYSDK_CALL MRPSDK_Cleanup(void);

/* MRPSDK_GetVersion
 * òſ汾
 * زſ汾
*/
MRPLAYSDK_API DWORD  MRPLAYSDK_CALL MRPSDK_GetVersion(void);
// ݻƵϢ

/* MRPSDK_GetAudioInfo
 * ƵݣƵϢ(AACMP3)
   codec_id		: Ƶѹ㷨, MR_AUDIOCODEC_TYPE
   pAudioBits   : ѹƵBuffer
   nSize		: pAudioBitsС
   pSampleRate	: زƵ
   pSampleSize	: ز
   pChannel		: ͨ
   pBitRate		: ѹ
 * ɹ0 Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_GetAudioInfo(
										MRPARAM_IN int codec_id, 
										MRPARAM_IN BYTE *pAudioBits, 
										MRPARAM_IN int nSize, 
										MRPARAM_OUT int *pSampleRate, 
										MRPARAM_OUT int *pSampleSize, 
										MRPARAM_OUT int *pChannel, 
										MRPARAM_OUT int *pBitRate
										);

/* MRPSDK_Chn_LiveOpen
 * ͨ
   pStChn		: ͨ
   nFifoNums    : ڲС, ԽԽռڴ
   bLive		: ʵʱ־TRUE - ʵʱFALSE - Զ̲
 * ɹ0 Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_LiveOpen(
										MRPARAM_OUT LONG *pStChn, 
										MRPARAM_IN int nFifoNums,
										MRPARAM_IN BOOL bLive
										);

/* MRPSDK_Chn_SetStream
 * ͨϢ
   lStChn		: MRPSDK_Chn_LiveOpenֵ
   nb_streams   : 
   stream		: Ϣָ
 * ɹ0 Ϊֵ
 * ҪMRPSDK_Chn_Start
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetStream(
										MRPARAM_IN LONG lStChn, 
										MRPARAM_IN int nb_streams,
										MRPARAM_IN MRAVSTREAM_T *stream
										);

/* MRPSDK_Chn_GetStream
 * ͨϢ
   lStChn		: MRPSDK_Chn_LiveOpenMRPSDK_Chn_FileOpenֵ
   stream_index : 
   stream		: Ϣָ
 * ɹ0 Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetStream(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int stream_index, 
										MRPARAM_OUT MRAVSTREAM_T *stream
										);

/* MRPSDK_Chn_FileOpen
 * 򿪱ļͨ
   pFlChn		: ž
   szFileName   : ļ
   i64StPos		: ļſʼλ
   i64EdPos		: ļŽλ
 * ɹ0 Ϊֵ
 * ļi64EdPosó0
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_FileOpen(
										MRPARAM_OUT LONG *pFlChn, 
										MRPARAM_IN const char *szFileName, 
										MRPARAM_IN INT64 i64StPos, 
										MRPARAM_IN INT64 i64EdPos
										);

/* MRPSDK_Chn_RegPlayEndMsg
 * עᲥŽϢ
   lFlChn		: MRPSDK_Chn_FileOpenֵ
   hMsgWnd		: Ϣ
   wMsgID		: ϢID
 * ɹ0 Ϊֵ
 * ҪMRPSDK_Chn_Start
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_RegPlayEndMsg(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN HWND hMsgWnd, 
										MRPARAM_IN UINT uMsgID
										);
/* MRPSDK_Chn_FileIsPassword
 * жļǷ
   lFlChn		: MRPSDK_Chn_FileOpenֵ
 * 뷵ش00Ϊ, С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_FileIsPassword(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_FileCheckPassword
 * У
   lFlChn		: MRPSDK_Chn_FileOpenֵ
   szPassword	: 
 * Уɹ1С0Ϊ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_FileCheckPassword(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN const char *szPassword
										);

/* MRPSDK_Chn_Close
 * رղͨ
   lChn		: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   szPassword	: 
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Close(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_Stop
 * ֹͣ
   lChn		: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Stop(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_Start
 * ʼ
   lChn		: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Start(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_PutData
 * ŷ
   lChn				: MRPSDK_Chn_LiveOpenֵbLiveΪFALSE
   bMallocBuffer	: ڴ־, TRUE - SDKڲڴ棬FALSE -ڴ棬ֱʹpFrameеָ
   bBlock			: ־TRUE - ڲ֪пյĻãFALSE - ûпû壬ֱӷش
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_PutData(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN BOOL bMallocBuffer, 
										MRPARAM_IN MRAVFrame *pFrame,
										MRPARAM_IN BOOL bBlock
										);

/* MRPSDK_Chn_RegDrawDC
 * עOSD
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   fdCallBack	: OSDص
   userdata		: û
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_RegDrawDC(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN fdMRNCb_ChnDrawDC fdCallBack, 
										MRPARAM_IN void *userdata
										);

/* MRPSDK_Chn_RegGetDecFrame
 * עƵݻص
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   fdCallBack	: Ƶݻص
   userdata		: û
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_RegGetDecFrame(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN fdMRNCb_ChnGetDecFrame fdCallBack, 
										MRPARAM_IN void *userdata
										);

/* MRPSDK_Chn_RegGetDecAudioFrame
 * עƵݻص
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   fdCallBack	: Ƶݻص
   userdata		: û
 * ɹ0Ϊֵ
*/
int  MRPLAYSDK_CALL MRPSDK_Chn_RegGetDecAudioFrame(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN fdMRNCb_ChnGetDecAudioFrame fdCallBack, 
										MRPARAM_IN void *userdata
										);

/* MRPSDK_Chn_RegSizeChange
 * עƵͼСıص
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   fdCallBack	: ƵͼСıص
   userdata		: û
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_RegSizeChange(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN fdMRPSdkSizeChangeCallBack fdCallBack, 
										MRPARAM_IN void *userdata
										);

/* MRPSDK_Chn_GetFifoState
 * ڲ״̬
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   pFillNums	: Ѿ
   userdata		: ʣ໺
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetFifoState(
										MRPARAM_IN LONG lChn, 
										MRPARAM_OUT int *pFillNums, 
										MRPARAM_OUT int *pFreeNums
										);

/* MRPSDK_Chn_GetStreams
 * òͨ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetStreams(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_GetVideoStreams
 * òͨƵ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ƵС0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetVideoStreams(
										MRPARAM_IN LONG lChn
										);
/* MRPSDK_Chn_SetVideoWnd
 * Ƶʾ
   lChn			: MRPSDK_Chn_LiveOpen ֵ
   stream_index	: Ƶ
   hWnd			: ƵʾڣΪգҪʾƵԽʡCPUԴʹMRPSDK_Chn_ShowVideoʵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetVideoWnd(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int stream_index, 
										MRPARAM_IN HWND hWnd
										);

/* MRPSDK_Chn_SetAllVideoWnd
 * òͨƵʾ
   lChn			: MRPSDK_Chn_LiveOpen ֵ
   nb_Wnds		: Ƶ
   hWnd			: Ƶб
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetAllVideoWnd(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int nb_Wnds, 
										MRPARAM_IN HWND *pWnd
										);

/* MRPSDK_Chn_SetDelay
 * ʱʱ
   lChn			: MRPSDK_Chn_LiveOpen ֵ
   delayms		: ʱʱ()
 * ɹ0Ϊֵ
 * ʱԽռڴԽ󣬷֮Ȼ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetDelay(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int delayms
										);

/* MRPSDK_Chn_CleanFifo
 * ڲ
   lChn			: MRPSDK_Chn_LiveOpen ֵ
 * ɹ0Ϊֵ
 * ʱʱҪղŻ壬ļת
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_CleanFifo(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_GetInxData
 * ļ
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
   pInxBuffer	: ָ	
 * ݳȣС0Ϊֵ
 * 
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetInxData(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_OUT BYTE **pInxBuffer
										);

/* MRPSDK_Chn_Play
 * 
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Play(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_Pause
 * ͣ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
 * ʵʱŲָ֧ò
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Pause(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_Step
 * 
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
 * ʵʱŲָ֧ò
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Step(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_SeekTime
 * ת
   lChn			: MRPSDK_Chn_FileOpen ֵ
   nSecond		: תʱ()
 * ɹ0Ϊֵ
 * ֻ֧ļ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SeekTime(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN int nSecond
										);

/* MRPSDK_Chn_Fast
 * 
   lChn			: MRPSDK_Chn_FileOpen ֵ
   nFastValue	: ֵ2, 4, 8, 16ã0 - ڲԶлģʽʹMRPSDK_Chn_GetCurPlayModeõǰģʽ
 * ɹ0Ϊֵ
 * ֻ֧ļ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Fast(
										MRPARAM_IN LONG lFlChn,
										MRPARAM_IN int nFastValue
										);

/* MRPSDK_Chn_Slow
 * 
   lChn			: MRPSDK_Chn_FileOpen ֵ
   nSlowValue	: ֵ2, 4, 8, 16Ӧ1/2, 1/4, 1/8, 1/160 - ڲԶлģʽʹMRPSDK_Chn_GetCurPlayModeõǰģʽ
 * ɹ0Ϊֵ
 * ֻ֧ļ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_Slow(
										MRPARAM_IN LONG lFlChn,
										MRPARAM_IN int nSlowValue
										);

/* MRPSDK_Chn_BackKeyFrame
 * ˹ؼ֡
   lChn			: MRPSDK_Chn_FileOpen ֵ
 * ɹ0Ϊֵ
 * ֻ֧ļ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_BackKeyFrame(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_GetCurPlayMode
 * õǰ״̬
   lFlChn		: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ɹMRPSDK_MODE_TYPE壬С0Ϊֵ
 * ֧ļţ֧ʵʱ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetCurPlayMode(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_GetFileTime
 * ļʱ
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
 * ɹļʱ()С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetFileTime(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_GetCurFrameNo
 * õǰ֡
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
   stream_index : 
 * ɹ֡ţС0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetCurFrameNo(
										MRPARAM_IN LONG lFlChn,
										MRPARAM_IN int stream_index
										);


/* MRPSDK_Chn_GetCurTime
 * õǰʱ
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
 * ɹصǰʱ䣬С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetCurTime(
										MRPARAM_IN LONG lFlChn
										);

/* MRPSDK_Chn_SetCurTime
 * õǰʱ
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
 * ɹ0С0Ϊֵ
 * 
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetCurTime(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN int nCurSecs
										);

/* MRPSDK_Chn_RegGetData
 * עļŻݻص
   lFlChn		 : MRPSDK_Chn_FileOpen ֵ
   fdCallBack    : ȡݻصָ
   userdata      : صû
 * 0ɹΪֵ
*/
MRPLAYSDK_API int MRPLAYSDK_CALL MRPSDK_Chn_RegGetData(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN fdMRNCb_ChnGetData fdCallBack, 
										MRPARAM_IN void *userdata
										);

/* MRPSDK_Chn_GetVideosByTime
 * ȥƵͨб
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
 * Ƶͨ
 * 
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetVideosByTime(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_IN int nCurSecs, 
										MRPARAM_IN int nRangMs, 
										MRPARAM_OUT int *pVChnList
										);

/* MRPSDK_Chn_GetVideosByFrames
 * ȥƵͨб
   lFlChn		: MRPSDK_Chn_FileOpen ֵ
 * Ƶͨ
 * 
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetVideosByFrames(
										MRPARAM_IN LONG lFlChn, 
										MRPARAM_OUT int *pVChnList
										);

/* MRPSDK_Chn_ShowVideo
 * ʾ/ط
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   bShow		: TRUE - ʾƵFALSE - ʾƵҲ
 * ɹ0С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_ShowVideo(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN BOOL bShow
										);

/* MRPSDK_Chn_RefrenshWnd
 * ˢƵʾ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   stream_index	: -1ΪƵ
 * ɹ0С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_RefrenshWnd(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int stream_index
										);

/* MRPSDK_Chn_ZoomPicture
 * ֲŴƵ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   hWnd			: ʾֲŴƵڣNULLرվֲŴ
   stream_index : Ƶ
   nXPen		: Xλ(ٷֱ)
   nYPen		: Yλ(ٷֱ)
   nWPen		: (ٷֱ), 0رվֲŴ
   nHPen		: ߶(ٷֱ), 0رվֲŴ
 * ɹ0С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_ZoomPicture(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN HWND hWnd, 
										MRPARAM_IN int stream_index, 
										MRPARAM_IN int nXPen, 
										MRPARAM_IN int nYPen, 
										MRPARAM_IN int nWPen, 
										MRPARAM_IN int nHPen
										);

/* MRPSDK_Chn_CaptureJpeg
 * ץJPEG
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   hWnd			: ʾֲŴƵڣNULLرվֲŴ
   stream_index : Ƶ
   nQuality		: ץ(0 - 100), 100 
   lpFileName	: ļ
 * ɹ0С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_CaptureJpeg(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int stream_index,
										MRPARAM_IN int nQuality, 
										MRPARAM_IN const char *lpFileName
										);

/* MRPSDK_Chn_SoundPlay
 * Ƶ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   bStart		: TRUE - ʼƵFALSE - رƵ
 * ɹ0С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SoundPlay(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN BOOL bStart
										);

/* MRPSDK_Chn_SoundIsOpen
 * жǷڲƵ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * ڲƵ1
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SoundIsOpen(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_GetVolume
 * 
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * (0 - 100)С0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_GetVolume(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_Chn_SetVolume
 * 
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
   nVolume		: ֵ(0 - 100)
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SetVolume(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN int nVolume
										);

/* MRPSDK_Chn_SoundIsExist
 * жϲͨ˽аƵ
   lChn			: MRPSDK_Chn_LiveOpen  MRPSDK_Chn_FileOpen ֵ
 * Ƶ1޷0
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_Chn_SoundIsExist(
										MRPARAM_IN LONG lChn
										);


/* MRPSDK_AudioPlay_Start
 * Ƶͨ
   pApChn		: Ƶͨ
   audio_codec	: Ƶѹʽ, MR_AUDIOCODEC_TYPE
   nSampleRate	: Ƶ
   nSampleBits	: 
   nChannel		: ͨ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_AudioPlay_Start(
										MRPARAM_OUT LONG *pApChn,
										MRPARAM_IN int audio_codec, 
										MRPARAM_IN int nSampleRate, 
										MRPARAM_IN int nSampleBits,
										MRPARAM_IN int nChannel
										);

/* MRPSDK_AudioPlay_PutData
 * Ƶ
   lChn			: ƵͨMRPSDK_AudioPlay_Startֵ
   pData		: Ƶ
   pts			: ʱ()
   nSize		: ݴС
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_AudioPlay_PutData(
										MRPARAM_IN LONG lChn,
										MRPARAM_IN unsigned char *pData,
										MRPARAM_IN int pts,
										MRPARAM_IN int nSize
										);

/* MRPSDK_AudioPlay_Stop
 * رƵͨ
   lChn			: ƵͨMRPSDK_AudioPlay_Startֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_AudioPlay_Stop(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_VideoView_OpenChn
 * Ƶʾͨ
   lChn			: ʾͨ
   hWnd			: ʾ
   nWidth		: 
   nHeight		: ߶
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_VideoView_OpenChn(
										MRPARAM_OUT LONG *lChn, 
										MRPARAM_IN HWND hWnd, 
										MRPARAM_IN int nWidth, 
										MRPARAM_IN int nHeight
										);

/* MRPSDK_VideoView_CloseChn
 * رƵʾͨ
   lChn		: ʾMRPSDK_VideoView_OpenChnֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_VideoView_CloseChn(
										MRPARAM_IN LONG lChn
										);

/* MRPSDK_VideoView_ChnShow
 * ʾƵ
   lChn		: ʾMRPSDK_VideoView_OpenChnֵ
   pY		: Y
   pU		: U
   pV		: V
   nW		: 
   nH		: ߶
   nYStride	: Y
   nUVStride: UV
 * ɹ0Ϊֵ
 * ͼʽΪYUV420ƽ̹ģʽ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_VideoView_ChnShow(
										MRPARAM_IN LONG lChn, 
										MRPARAM_IN unsigned char *pY, 
										MRPARAM_IN unsigned char *pU, 
										MRPARAM_IN unsigned char *pV,
										MRPARAM_IN int nW, 
										MRPARAM_IN int nH, 
										MRPARAM_IN int nYStride, 
										MRPARAM_IN int nUVStride
										);

/* MRPSDK_CutFileByFrame
 * ֡ļ
   pCutHandle		: о
   szSrcFileName	: Դļ
   u64StPos			: Դļʼλ
   u64EdPos			: Դļλã0 - ļ
   nStFrameNo		: ʼ֡
   nEdFrameNo		: ֡
   szDstFileName	: бļ
   nSaveFileType	: бļ, MR_PACKTYPE_TYPE
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_CutFileByFrame(
										MRPARAM_OUT LONG *pCutHandle,
										MRPARAM_IN const char *szSrcFileName,
										MRPARAM_IN UINT64 u64StPos,
										MRPARAM_IN UINT64 u64EdPos,
										MRPARAM_IN int nStFrameNo,
										MRPARAM_IN int nEdFrameNo,
										MRPARAM_IN const char *szDstFileName,
										MRPARAM_IN int nSaveFileType
										);

/* MRPSDK_CutFileByTime
 * ʱļ
   pCutHandle		: о
   szSrcFileName	: Դļ
   u64StPos			: Դļʼλ
   u64EdPos			: Դļλã0 - ļ
   nStTime			: ʼʱ()
   nEdTime			: ʱ()
   szDstFileName	: бļ
   nSaveFileType	: бļ, MR_PACKTYPE_TYPE
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_CutFileByTime(
										MRPARAM_OUT LONG *pCutHandle,
										MRPARAM_IN const char *szSrcFileName,
										MRPARAM_IN UINT64 u64StPos,
										MRPARAM_IN UINT64 u64EdPos,
										MRPARAM_IN int nStTime,
										MRPARAM_IN int nEdTime,
										MRPARAM_IN const char *szDstFileName,
										MRPARAM_IN int nSaveFileType
										);

/* MRPSDK_CutGetState
 * ü״̬
   lCutHandle		: оMRPSDK_CutFileByFrame  MRPSDK_CutFileByTime ֵ
 * ɹ 0 - 100Ϊɰٷֱȣ101ΪнС0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_CutGetState(
										MRPARAM_IN LONG lCutHandle
										);

/* MRPSDK_CutFileClose
 * رռо
   lCutHandle		: оMRPSDK_CutFileByFrame  MRPSDK_CutFileByTime ֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_CutFileClose(
										MRPARAM_IN LONG lCutHandle
										);

/* MRPSDK_MargeFile
 * ļϲ
   pMargeHandle		: ϲ
   szSrcFileName1	: Դļ1
   u64StPos1		: Դļʼλ1
   u64EdPos1		: Դļλ10 - ļ
   szSrcFileName1	: Դļ2
   u64StPos2		: Դļʼλ2
   u64EdPos2		: Դļλ20 - ļ
   szDstFileName	: ϲļ
   nSaveFileType	: ϲļ, MR_PACKTYPE_TYPE
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_MargeFile(
										MRPARAM_OUT LONG *pMargeHandle,
										MRPARAM_IN const char *szSrcFileName1,
										MRPARAM_IN UINT64 u64StPos1,
										MRPARAM_IN UINT64 u64EdPos1,
										MRPARAM_IN const char *szSrcFileName2,
										MRPARAM_IN UINT64 u64StPos2,
										MRPARAM_IN UINT64 u64EdPos2,
										MRPARAM_IN const char *szDstFileName,
										MRPARAM_IN int nSaveFileType
										);

/* MRPSDK_MargeGetState
 * úϲ״̬
   lMargeHandle		: ϲMRPSDK_MargeFile ֵ
 * ɹ 0 - 100Ϊϲɰٷֱȣ101ΪϲС0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_MargeGetState(
										MRPARAM_IN LONG lMargeHandle
										);

/* MRPSDK_MargeClose
 * رպϲ
   lMargeHandle		: ϲMRPSDK_MargeFile ֵ
 * ɹ0Ϊֵ
*/
MRPLAYSDK_API int  MRPLAYSDK_CALL MRPSDK_MargeClose(
										MRPARAM_IN LONG lMargeHandle
										);

#ifdef __cplusplus
}
#endif
#endif//__MRPLAYSDK_API_H__
