// MRNetServerApi.h
#ifndef __MRNETSERVER_API_H__
#define __MRNETSERVER_API_H__
#ifdef __cplusplus
extern "C" {
#endif

#include "MRNetSdkApi.h"

/* HMRNSDK_Stream
 * ͨMRNSDK_AVS_AddLiveStream ķֵ
*/
typedef void* HMRNSDK_Stream;

// ϴ֪ͨϢ
typedef struct{
	MRPARAM_IN void *hstream;				// 
	MRPARAM_IN const char *szStreamName;	// 
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_IN int nChannel;				// ͨ
	MRPARAM_IN int nStreamType;				// 
	MRPARAM_IN const char *szUserName;		// û
	MRPARAM_IN const char *szPassword;		// 
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_OUT int(*fdEventHanle)(
			MRPARAM_IN void* hstream,		// 
			MRPARAM_IN int nState,			// ״̬, LIBMS_CHNSTATE_TYPE
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT int(*fdRecvHandle)(			// ջص
			MRPARAM_IN void* hstream,		// 
			MRPARAM_IN void *userdata,		// û
			MRPARAM_IN MRAVFrame *pkt		// ֡
			);
	MRPARAM_IO void *userdata;				// û, ûøֵ״̬Ϊֵ
}MRNSDK_PUSHSTREAM_NOTIFY_T;

// ͸֪ͨͨϢṹ
typedef struct{
	MRPARAM_IN void *pDataPort;				// ͸ͨ
	MRPARAM_IN const char *szUserName;		// Զû
	MRPARAM_IN const char *szPassword;		// Զ
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_IN const char *szUserCmd;		// ԶûԶϢ(jsonʽ)
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_OUT char *szRetMsg;				// شϢ(jsonʽ)
	MRPARAM_OUT int  nFifoNums;				// FIFOС
	MRPARAM_OUT int(*fdclosehandle)(		// ͨر֪ͨص
			MRPARAM_IN void *pTranPort,		// ͨ
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT int(*fddatahandle)(			// ݻص
			MRPARAM_IN void *pTranPort,		// ͨ
			MRPARAM_IN MRAVFrame *pkt,		// ֡
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT void *pUserData;			// û
}MRNSDK_TRAN_DATAPORT_NOTIFY_T;

// ͸Ϣ֪ͨͨϢṹ
typedef struct{
	MRPARAM_IN void *pMsgPort;				// ͸Ϣͨ
	MRPARAM_IN const char *szUserName;		// Զû
	MRPARAM_IN const char *szPassword;		// Զ
	MRPARAM_IN const char *szDeviceID;		// 豸ID
	MRPARAM_IN const char *szUserCmd;		// ԶûԶϢ(jsonʽ)
	MRPARAM_IN const char *szIP;			// IPַ
	MRPARAM_OUT char *szRetMsg;				// ûشϢ
	MRPARAM_OUT int(*fdclosehandle)(		// ر֪ͨص
			MRPARAM_IN void *pTranPort,		// ͨ
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT int(*fdmsghandle)(			// Ϣص
			MRPARAM_IN void *pMsgPort,		// Ϣ
			MRPARAM_IN const char *szMsg,	// Ϣ
			MRPARAM_IN const char *szFileName,	// ļ
			MRPARAM_IN void *userdata		// û
			);
	MRPARAM_OUT void *pUserData;			// û
}MRNSDK_TRAN_MSGPORT_NOTIFY_T;

// 
typedef struct{
	void *hstream;				// ͨ
	int emProtocol;				// Э飬 MR_NETSTMPRO_TYPE
	int nChannel;				// ͨ
	int nStreamType;			// , 0 - , 1 -  2 - ¼
	const char *szPublishName;	// 
	const char *szServerIP;		// IP
	unsigned short wServerPort;	// ˿
	const char *szUserName;		// û
	const char *szPassword;		// 
	const char *szDeviceID;		// 豸ID		
	
	/* event_handle
	 * ֪ͨص
	   hPushHandle	: , libavms_stream_push_startֵ
	   hstream		: ͨ
	   userdata		: û
	   nState		: ״̬, -1 : ʧܣ0 - ӶϿ1 - ӳɹ
	 * 0ΪɹΪ
    */
	int (*event_handle)(
		MRPARAM_IN void *hPushHandle, 
		MRPARAM_IN HMRNSDK_Stream hstream, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int nState
	);
}MRNSDK_PUSHSTRM_PARAM_T;

typedef struct{
	int rtspport;				// rtsp ˿ , 0 -   Ĭ554
	int rtmpport;				// rtmp ˿ , 0 - , Ĭ1935
	int lvmsport;				// lvms ˿ , 0 - , Ĭ3000
	int brtsp_single;			// ̷߳ͱ־
	int brtmp_single;			// ̷߳ͱ־
	int blvms_single;			// ̷߳ͱ־
	int nTotalStreamUsers;		// û0 - Ϊ
	char szDownLoadPath[256];	// ϴļĿ¼
	
	/* stream_request
	 * ûУص
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * Уɹ0Ϊ
    */
	int(*user_sharke)(
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);
	/* stream_request
	 * ûص(ڲûҵ)
	   szStreamName : 
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*stream_request)(
		MRPARAM_IN const char *szStreamName,
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* stream_rights
	 * ȨУص
	   userdata		: û, libavms_addlivestreamвuserdata
	   szStreamName : 
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*stream_rights)(
		MRPARAM_IN void *userdata, 
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* vodfile_rights
	 * 㲥ȨУص
	   szFileName	: ļ
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*vodfile_rights)(
		MRPARAM_IN const char *szFileName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac, 
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);

	/* stream_codec
	 * Ϣص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   stream_inx	: 
	   pcodec		: Ϣָ
	 * 0ΪɹΪ
    */
	int(*stream_codec)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int stream_inx, 
		MRPARAM_IN MRAVSTREAM_T *pcodec
	);

	/* stream_start
	 * /ֹͣص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   bStart	    : TRUE - FALSE - ֹͣ
	 * 0ΪɹΪ
    */
	int(*stream_start)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int bStart
	);

	/* stream_start
	 * ͣ/ָص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   bPause	    : TRUE - ͣFALSE - ָ
	 * 0ΪɹΪ
    */
	int(*stream_pause)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata, 
		MRPARAM_IN int bPause
	);

	/* stream_start
	 * Ϣ֪ͨص
	   hmsg			: Ϣ
	   szMsg		: Ϣı
	   szFileName	: ļNULLΪЧ
	   szIP			: ûIPַ
	   szMac		: ûMACַ
	   username		: û
	   password		: 
	   szDeviceID   : 豸ID
	 * 0ΪɹΪ
    */
	int(*msg_handle)(
		MRPARAM_IN void *hmsg, 
		MRPARAM_IN const char *szMsg, 
		MRPARAM_IN const char *szFileName, 
		MRPARAM_IN const char *szIP, 
		MRPARAM_IN const char *szMac,
		MRPARAM_IN const char *username, 
		MRPARAM_IN const char *password,
		MRPARAM_IN const char *szDeviceID
	);
	
	/* pushstream_eventhandle
	 * ֪ͨص
	   hstream		: ͻ
	   pNotify		: Ϣṹ
	 * 0ΪɹΪ
    */
	int(*pushstream_eventhandle)(
		MRPARAM_IO MRNSDK_PUSHSTREAM_NOTIFY_T *pNotify
	);
	
	/* trandataport_notify
	 * ͸ͨ()ص
	   hstream		: ͻ
	   userdata		: û
	   pkt			: ָ֡
	 * 0ΪɹΪ
    */
	int(*tran_dataport_notify)(
		MRPARAM_IO MRNSDK_TRAN_DATAPORT_NOTIFY_T *pNotify
	);

	/* tranmsgport_notify
	 * ͸Ϣͨ()ص
	   hstream		: ͻ
	   userdata		: û
	   pkt			: ָ֡
	 * 0ΪɹΪ
    */
	int(*tran_msgport_notify)(
		MRPARAM_IO MRNSDK_TRAN_MSGPORT_NOTIFY_T *pNotify
	);

	/* stream_useroutline
	 * û֪ͨص
	   szStreamName : 
	   userdata		: û, libavms_addlivestreamвuserdata
	   nCurUsers	: ǰû
    */
	void(*stream_useroutline)(
		MRPARAM_IN const char *szStreamName, 
		MRPARAM_IN void *userdata,
		MRPARAM_IN int nCurUsers
	);
}MRNETSDK_AVSERVER_CONFIG;

/* MRNSDK_AVS_Start
 * ģ
   pConfig	: ģòNULL
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_AVS_Start(
								MRPARAM_IN MRNETSDK_AVSERVER_CONFIG *pConfig
								);

/* MRNSDK_AVS_Stop
 * ֹͣģ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_AVS_Stop(void);

/* MRNSDK_AVS_AddLiveStream
 * ģм
   szStreamName : , ûڷʱʹø
   userdata		: û
   nb_streams	: 
   fifonums		: FIFOһΪnb_streams * 50
   nMaxUser		: û0 - 
 * ɹ NULLΪ
*/
MRNSDK_API HMRNSDK_Stream MRNSDK_CALL MRNSDK_AVS_AddLiveStream(
								MRPARAM_IN const char *szStreamName, 
								MRPARAM_IN void *userdata, 
								MRPARAM_IN int nb_streams, 
								MRPARAM_IN int fifonums,
								MRPARAM_IN int nMaxUser
								);
/* MRNSDK_AVS_Stream_Users
 * ͨû
   hStream		: 
   bAllUsers	: TRUE - û, FALSE - ͣû
 * ûС0Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_Users(
								MRPARAM_IN HMRNSDK_Stream hStream, 
								MRPARAM_IN int bAllUsers
								);
/* MRNSDK_AVS_GetStream_byName
 * AVMSģл
   szStreamName	: 
 * ɹ NULLΪ
*/
MRNSDK_API HMRNSDK_Stream MRNSDK_CALL MRNSDK_AVS_GetStream_byName(
								MRPARAM_IN const char *szStreamName
								);

/* MRNSDK_AVS_Stream_Pause
 * ͣ/ֱָ
   hstream		: 
   bPause		: TRUE - ͣ, FALSE - ָ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_Pause(
								MRPARAM_IN HMRNSDK_Stream hstream, 
								MRPARAM_IN int bPause
								);

/* MRNSDK_AVS_Stream_Del
 * AVMSģƳ
   hstream		: 
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_Del(
								MRPARAM_IN HMRNSDK_Stream hstream
								);

/* MRNSDK_AVS_Stream_SendFrame
 * һ֡
   hstream		: 
   stream_index : , 0 -  - 1
   media_type   : ͣAVMediaType
   frametype    : ֡, MR_FRAME_TYPE
   pts			: ʱ
   pbuff		: ָ֡
   size			: ֡С
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_SendFrame(
								MRPARAM_IN HMRNSDK_Stream hstream, 
								MRPARAM_IN int stream_index, 
								MRPARAM_IN int media_type, 
								MRPARAM_IN int frametype, 
								MRPARAM_IN int pts, 
								MRPARAM_IN unsigned char *pbuff, 
								MRPARAM_IN int size
								);

/* MRNSDK_AVS_Stream_SendFrame_Timeout
 * ʱһ֡
   hstream		: 
   stream_index : , 0 -  - 1
   media_type   : ͣAVMediaType
   frametype    : ֡, MR_FRAME_TYPE
   pts			: ʱ
   pbuff		: ָ֡
   size			: ֡С
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_SendFrame_Timeout(
								MRPARAM_IN HMRNSDK_Stream hstream, 
								MRPARAM_IN int stream_index, 
								MRPARAM_IN int media_type, 
								MRPARAM_IN int frametype, 
								MRPARAM_IN int pts, 
								MRPARAM_IN unsigned char *pbuff, 
								MRPARAM_IN int size, 
								MRPARAM_IN int nTimeOutms
								);

/* MRNSDK_AVS_Stream_SendAVFrame
 * һ֡
   hstream		: 
   pAvFrame		: ָ֡
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_SendAVFrame(
								MRPARAM_IN HMRNSDK_Stream hstream, 
								MRPARAM_IN MRAVFrame *pAvFrame
								);

/* MRNSDK_AVS_Stream_SendAVFrame_Timeout
 * ʱһ֡
   hstream		: 
   pAvFrame		: ָ֡
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_SendAVFrame_Timeout(
								MRPARAM_IN HMRNSDK_Stream hstream, 
								MRPARAM_IN MRAVFrame *pAvFrame,
								MRPARAM_IN int nTimeOutms
								);

/* MRNSDK_AVS_UploadSendMsg
 * ϴϢ
	nMaskValue	: , 
					0x01 - ź
					0x02 - /ػϢ
					0x04 - GPS
   szMsg		: ϴϢ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_UploadSendMsg(
								MRPARAM_IN int nMaskValue,
								MRPARAM_IN const char *szMsg,
								MRPARAM_IN int nTimeOutms
								);

/* MRNSDK_AVS_SendMsg
 * Ϣͻ
   hmsg			: Ϣmsg_handleصеϢ
   szMsg		: Ϣ
   szFileName	: ļ, NULLΪЧ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_SendMsg(
								MRPARAM_IN void *hmsg, 
								MRPARAM_IN const char *szMsg, 
								MRPARAM_IN const char *szFileName,
								MRPARAM_IN int nTimeOutms
								);

/* MRNSDK_AVS_Msg_SendData
 * 
   hmsg			: Ϣmsg_handleصеϢ
   szMsg		: Ϣ
   pData		: ָ
   nSize		: ݳ
   nExtData		: չ
   nTimeOutms	: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Msg_SendData(
								MRPARAM_IN void *hmsg, 
								MRPARAM_IN const char *szMsg, 
								MRPARAM_IN unsigned char *pData, 
								MRPARAM_IN int nSize, 
								MRPARAM_IN int nExtData,
								MRPARAM_IN int nTimeOutms
								);

/* MRNSDK_AVS_Msg_Close
 * رϢ
   hmsg			: Ϣmsg_handleصеϢ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Msg_Close(
								MRPARAM_IN void* hmsg
								);

/* MRNSDK_AVS_RegCloseHandle
 * עϢرջص
   hmsg			: Ϣmsg_handleصеϢ
   fdCloseHandle: رջص
		hmsg		: Ϣ
		userdata	: û
   userdata		: û
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_RegCloseHandle(
								MRPARAM_IN void* hmsg, 
								MRPARAM_IN void(*fdCloseHandle)(
									MRPARAM_IN void* hmsg, 
									MRPARAM_IN void *userdata
									),
								MRPARAM_IN void *userdata
								);

/* MRNSDK_AVS_Stream_Push_Start
 * ʼ
   phHandle			: ؾ
   pPushParam		: Ϣ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_Push_Start(
								MRPARAM_OUT void **phHandle, 
								MRPARAM_IN MRNSDK_PUSHSTRM_PARAM_T *pPushParam
								);

/* MRNSDK_AVS_Stream_Push_stop
 * ʼ
   phHandle			: ;libavms_stream_push_start ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_Stream_Push_Stop(
								MRPARAM_IN void *hHandle
								);

/* MRNSDK_AVS_TranDataPort_SendFrame
 * ͸ͨ
   pTranPort		: ͸ͨ, ص trandataport_notify е͸ͨ
   pkt				: ֡
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_TranDataPort_SendFrame(
								MRPARAM_IN void *pDataPort,
								MRPARAM_IN MRAVFrame *pkt
								);

/* MRNSDK_AVS_TranDataPort_Close
 * ر͸ͨ
   pTranPort		: ͸ͨ, صtrandataport_notifyе͸ͨ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_TranDataPort_Close(
								MRPARAM_IN void *pDataPort
								);

/* MRNSDK_AVS_TranMsgPort_SendMsg
 * ͸ϢͨϢ
   pMsgPort			: ͸ͨ, صtranmsgport_notifyе͸ͨ
   szSendMsg		: Ϣ
   szSendFileName	: ͵ļ
   nTimeoutMs		: ͳʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_TranMsgPort_SendMsg(
								MRPARAM_IN void *pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_AVS_TranMsgPort_SendRecvMsg
 * ͺͽ͸ϢͨϢ
   pMsgPort			: ͸ͨ, صtranmsgport_notifyе͸ͨ
   szSendMsg		: Ϣ
   szSendFileName	: ͵ļ
   pRecvMsg			: Ϣַָ
   pRecvFileName	: ļַָ
   nTimeoutMs		: ͽճʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_TranMsgPort_SendRecvMsg(
								MRPARAM_IN void *pMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_OUT char **pRecvMsg,
								MRPARAM_OUT char **pRecvFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_AVS_TranMsgPort_Close
 * ر͸Ϣͨ
   pTranPort		: ͸ͨ, صtranmsgport_notifyе͸ͨ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AVS_TranMsgPort_Close(
								MRPARAM_IN void *pMsgPort
								);

#ifdef __cplusplus
}
#endif
#endif//__MRNETSERVER_API_H__
