//MRNetSdkApi.h
#ifndef __MRNETSDK_API_H__
#define __MRNETSDK_API_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "MRComm.h"

#define MRNSDK_API		extern "C"__declspec(dllexport)
#define MRNSDK_CALL		__stdcall

// ͸ͨϢ
typedef struct{
	MRPARAM_IN const char *szIP;		// IPַ
	MRPARAM_IN unsigned short wPort;	// ˿ں
	MRPARAM_IN const char *szUserName;	// û
	MRPARAM_IN const char *szPassword;	// 
	MRPARAM_IN const char *szDeviceID;	// 豸ID
	MRPARAM_IN int nTimeout;			// ʱʱ()
	MRPARAM_IN void *userdata;			// û
	MRPARAM_IN int nFiFoNums;			// ͵FiFo
	MRPARAM_IN int (*fdCloseHandle)(	// ر֪ͨص
		MRPARAM_IN LONG lDataPort,			// ͨ
		MRPARAM_IN void *userdata			// û
		);
	// ݻص, pTranPort - ͸ͨ, nState - ״̬(0 - Ͽ1 - ), pkt - ֡, userdata - û
	MRPARAM_IN int (*fdGetDataHandle)(		// ݻص
		MRPARAM_IN LONG lDataPort,				// ͨ
		MRPARAM_IN MRAVFrame *pkt,			// ֡
		MRPARAM_IN void *userdata				// û
		);
	
	MRPARAM_IN const char *szUserCmd;	// ͵ûϢ
	MRPARAM_OUT const char *szAckMsg;	// ͵Ϣ
}MRSDK_TRANDATA_PORT_T;

// ͸ϢͨϢ
typedef struct{
	MRPARAM_IN const char *szIP;		// IPַ
	MRPARAM_IN unsigned short wPort;	// ˿ں
	MRPARAM_IN const char *szUserName;	// û
	MRPARAM_IN const char *szPassword;	// 
	MRPARAM_IN const char *szDeviceID;	// 豸ID
	MRPARAM_IN int nTimeout;			// ʱʱ()
	MRPARAM_IN void *userdata;			// û
	MRPARAM_IN int (*fdCloseHandle)(	// Ϣͨر֪ͨص
		MRPARAM_IN LONG lMsgPort,				// Ϣ
		MRPARAM_IN void *userdata			// û
		);
	// Ϣص, pTranPort - ͸ͨ, nState - ״̬(0 - Ͽ1 - ), pkt - ֡, userdata - û
	MRPARAM_IN int (*fdGetMsgHandle)(			// Ϣص
		MRPARAM_IN LONG lMsgPort,				// Ϣ
		MRPARAM_IN const char *szMsg,			// Ϣ
		MRPARAM_IN const char *szFileName,		// ļ
		MRPARAM_IN void *userdata				// û
		);
	
	MRPARAM_IN const char *szUserCmd;	// ͵ûϢ
	MRPARAM_OUT const char *szAckMsg;	// ͵Ϣ
}MRSDK_TRANMSG_PORT_T;

/* fdMRNCb_ChnReLink
 * ͨص
	lStreamHandle : 
	nState        : ״̬, 1 - Ӷ˿(1 0 - )2 - ӶϿ10 - ɹ 
	userdata       : û
 * nStateΪ1ʱ1ϵͳԶ0Ͽ, ״ֵ̬Էֵ
*/
typedef int  (*fdMRNCb_ChnReLink)(
					MRPARAM_IN LONG lStreamHandle, 
					MRPARAM_IN int   nState, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_ChnGetData
 * ͨȡݻص
	lStreamHandle : 
	pAvFrame      : ָ֡
	userdata       : û
*/
typedef void (*fdMRNCb_ChnGetData)(
					MRPARAM_IN LONG lStreamHandle, 
					MRPARAM_IN MRAVFrame *pAvFrame, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_ChnGetDecFrame
 * ȡͨݻص
	lStreamHandle : 
	stream_index  : 
	nTimeTick     : ʱ()
	pYBuff        : Yָ
	pUBuff        : Uָ
	pVBuff        : Vָ
	nWidth        : ͼ
	nHeight       : ͼ߶
	nYStride      : Y
	nUVStride     : UV
	userdata      : û
 * û޸YUVݣĽ
*/
typedef void (*fdMRNCb_ChnGetDecFrame)(
					MRPARAM_IN LONG lStreamHandle, 
					MRPARAM_IN int stream_index,
					MRPARAM_IN DWORD nTimeTick,
					MRPARAM_IN BYTE *pYBuff, 
					MRPARAM_IN BYTE *pUBuff, 
					MRPARAM_IN BYTE *pVBuff,
					MRPARAM_IN int nWidth,
					MRPARAM_IN int nHeight,
					MRPARAM_IN int nYStride, 
					MRPARAM_IN int nUVStride, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_ChnGetDecAudioFrame
 * ȡͨݻص
	lStreamHandle : 
	pBuff  		  : Ƶ, pcmʽ
	nSize		  : Ƶݳ
	nTimeTick     : ʱ()
	nSampleRate   : Ƶ
	nSampleBits   : Ƶ
	nChannel      : Ƶ
	userdata      : û
 * û޸pcmݣĽ
*/
typedef void (*fdMRNCb_ChnGetDecAudioFrame)(
					MRPARAM_IN LONG lStreamHandle, 
					MRPARAM_IN BYTE *pBuff,
					MRPARAM_IN int nSize,
					MRPARAM_IN DWORD nTimeTick,
					MRPARAM_IN int nSampleRate,
					MRPARAM_IN int nSampleBits,
					MRPARAM_IN int nChannel, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_ChnDrawDC
 * ͼOSDص
	lStreamHandle : 
	stream_index  : 
	hDC           : HDCָ
	userdata      : û
*/
typedef void (*fdMRNCb_ChnDrawDC)(
					MRPARAM_IN LONG lStreamHandle, 
					MRPARAM_IN int stream_index, 
					MRPARAM_IN HDC hDC, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_VodGetPassword
 * Զļطص
	szFileName    : ļ
	szPassword    : 
	userdata      : û
 * 0ɹΪ
 * ֻеļʱŻʹ
*/
typedef int  (*fdMRNCb_VodGetPassword)(
					MRPARAM_IN const char *szFileName, 
					MRPARAM_OUT char *szPassword, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_TalkDataCallBack
 * ƵԽݻص
	lTalkHandle   : Խ
	pDataBuf      : Ƶ
	dwBufSize     : ݳ
	pts           : ʱ()
	userdata      : û
*/
typedef void (*fdMRNCb_AudioGetData)(
					MRPARAM_IN LONG lTalkHandle, 
					MRPARAM_IN BYTE *pDataBuf, 
					MRPARAM_IN DWORD dwBufSize, 
					MRPARAM_IN int pts, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_AudioStopCallBack
 * ƵԽֹ֪ͣͨص
	lTalkHandle   : Խ
	userdata      : û
*/
typedef void (*fdMRNCb_AudioStop)(
					MRPARAM_IN LONG lTalkHandle, 
					MRPARAM_IN void *userdata
					);

/* fdMRNCb_MulticastRecvData
 * 鲥ݻص
	pHandle		  : 鲥ͨ
	pkt			  : ֡
	userdata      : û
*/
typedef void (*fdMRNCb_MulticastRecvData)(
					MRPARAM_IN void *pHandle, 
					MRPARAM_IN MRAVFrame *pkt,
					MRPARAM_IN void *userdata
					);

/* MRNSDK_Init
 * SDKʼ
	bUseThreadPoll : ʹ̳߳ر־
 * 0ɹΪ
 * ʹøSDKǰȵøúʼ
*/
MRNSDK_API int MRNSDK_CALL   MRNSDK_Init(
								MRPARAM_IN int bUseThreadPoll
								);

/* MRNSDK_SetDownLoadDir
 * رʱĿ¼
	szDir : ʱĿ¼
 * 0ɹΪ
*/
MRNSDK_API int MRNSDK_CALL   MRNSDK_SetDownLoadDir(
								MRPARAM_IN const char *szDir
								);

/* MRNSDK_Cleanup
 * жSDKԴ
 * ڽʹøSDK󣬵øúԴ
*/
MRNSDK_API void MRNSDK_CALL  MRNSDK_Cleanup();

/* MRNSDK_GetVersion
 * SDK汾
 * SDK汾
*/
MRNSDK_API DWORD MRNSDK_CALL MRNSDK_GetVersion();

/* MRNSDK_GetLastError
 * ô
 * ش, MRErrorNo.hļ˴ֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_GetLastError();

/* MRNSDK_LiveSingle
 * ʼԤ
   pHandle		: ؾָ
   szIP			: IPַ
   wPort		: ˿
   protocol     : Э, 0 - MRMS˽Э飬1 - RTSPЭ
   szUserName   : û
   szPassword   : 
   szDeviceID	: 豸ID(תʱʹ)
   szStreamName : 
   nTimeoutMs   : ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_LiveSingle(
								MRPARAM_OUT LONG *pHandle,
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN WORD wPort, 
								MRPARAM_IN int protocol,
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN const char *szStreamName,
								MRPARAM_IN int nTimeoutMs
								);

MRNSDK_API int MRNSDK_CALL MRNSDK_LiveMultiCast(
								MRPARAM_OUT LONG *pHandle,
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN WORD wPort,
								MRPARAM_IN int emProtocol,
								MRPARAM_IN const char *szStreamName,
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_NetVod
 * ʼԶļط
   pHandle		: ؾָ
   szIP			: IPַ
   wPort		: ˿
   protocol     : Э, 0 - MRMS˽Э飬1 - RTSPЭ
   szFileName   : ļ
   fdCallBack   : Уص
   userdata     : صû
   szUserName   : û
   szPassword   : 
   szDeviceID	: 豸ID(תʱʹ)
   nTimeoutMs   : ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_NetVod(
								MRPARAM_OUT LONG *pHandle,
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN WORD wPort, 
								MRPARAM_IN int protocol, 
								MRPARAM_IN const char *szFileName,
								MRPARAM_IN fdMRNCb_VodGetPassword fdCallBack, 
								MRPARAM_IN void *userdata,
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_Stream_GetNums
 * 
   lStreamHandle : 
 * 0ΪΪ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_GetNums(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_Stream_GetVideoNums
 * Ƶ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * 0ΪΪ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_GetVideoNums(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_Stream_SetStream
 * Ϣ(鲥ʱЧ)
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nb_streams    : 
   stream        : Ϣָ
 * 0ɹΪֵ
 * 鲥ʱЧ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_SetStream(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nb_streams, 
								MRPARAM_IN MRAVSTREAM_T *stream
								);

/* MRNSDK_Stream_GetStream
 * Ϣ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nIndex        : 
   stream        : Ϣָ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_GetStream(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nIndex, 
								MRPARAM_OUT MRAVSTREAM_T *stream
								);

/* MRNSDK_Stream_GetImageSize
 * ƵС
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nIndex        : 
   pWidth        : ؿָ
   pHeight       : ظ߶ָ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_GetImageSize(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nIndex, 
								MRPARAM_OUT int *pWidth,
								MRPARAM_OUT int *pHeight
								);

/* MRNSDK_Stream_SetVideoWnd
 * Ƶʾ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nIndex        : 
   hWnd          : ͼ񴰿
 * 0ɹΪֵ
 * NULLʱֹͣͼ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_SetVideoWnd(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nIndex, 
								MRPARAM_IN HWND hWnd
								);

/* MRNSDK_Stream_SetAllVideoWnd
 * ͼʾ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nb_Videos     : 
   pWnd          : ָ
 * 0ɹΪֵ
 * NULLʱֹͣͼ
*/
MRNSDK_API int MRNSDK_CALL  MRNSDK_Stream_SetAllVideoWnd(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nb_Videos, 
								MRPARAM_IN HWND *pWnd
								);

/* MRNSDK_Stream_Start
 * š
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_Start(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_Stream_Stop
 * ֹͣ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_Stop(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_ZoomInPicture
 * ֲŴ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   hWnd          : ʾֲͼ񴰿(NULLʱȡͼŴ)
   nIndex        : Ƶ
   nXPen         : Xλ, ٷֱȼ
   nYPen         : Yλ, ٷֱȼ
   nWPen         : , ٷֱȼ
   nHPen         : ߶, ٷֱȼ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_ZoomInPicture(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN HWND hWnd, 
								MRPARAM_IN int nIndex, 
								MRPARAM_IN int nXPen, 
								MRPARAM_IN int nYPen, 
								MRPARAM_IN int nWPen, 
								MRPARAM_IN int nHPen
								);

/* MRNSDK_Stream_CapJpeg
 * JPEGץ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   hWnd          : ʾֲͼ񴰿(NULLʱȡͼŴ)
   nIndex        : Ƶ
   nQuality      : JPEGѹ,(0 - 100), 100Ϊã 0Ϊ 
   szFileName    : ļ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_CapJpeg(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nIndex, 
								MRPARAM_IN int nQuality, 
								MRPARAM_IN const char *szFileName
								);

/* MRNSDK_Stream_RefrenshWnd
 * ˢʾ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   nIndex        : Ƶ(-1ΪƵ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_RefrenshWnd(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN int nIndex
								);

/* MRNSDK_Stream_RegGetData
 * עͨݻص
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   fdCallBack    : ȡݻصָ
   userdata      : صû
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_RegGetData(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN fdMRNCb_ChnGetData fdCallBack, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_Stream_RegGetDecFrame
 * עͨݻص
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   fdCallBack    : ȡݻصָ
   userdata      : صû
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_RegGetDecFrame(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN fdMRNCb_ChnGetDecFrame fdCallBack, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_Stream_RegGetDecAudioFrame
 * עͨݻص
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   fdCallBack    : ȡݻصָ
   userdata      : صû
 * 0ɹΪֵ
*/
int MRNSDK_CALL MRNSDK_Stream_RegGetDecAudioFrame(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN fdMRNCb_ChnGetDecAudioFrame fdCallBack, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_Stream_RegDrawDC
 * עȡOSD HDCص
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   fdCallBack    : ȡOSD HDCصָ
   userdata      : صû
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_RegDrawDC(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN fdMRNCb_ChnDrawDC fdCallBack, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_Stream_GetPlayHandle
 * òž
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * ز0 - Ч
*/
MRNSDK_API LONG MRNSDK_CALL MRNSDK_Stream_GetPlayHandle(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_Stream_SetPlayHandle
 * òž
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   lPlayHandle   : ž
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_SetPlayHandle(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN LONG lPlayHandle
								);

/* MRNSDK_Stream_ShowVideo
 * ʾʾͼ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   bShow         : ʾ־
 * 0ɹΪֵ
 * ʾͼSDKҲͼ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_ShowVideo(
								MRPARAM_IN LONG lStreamHandle, 
								MRPARAM_IN BOOL bShow
								);

/* MRNSDK_Stream_SoundExist
 * жǷ֧Ƶ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * 1֧Ƶ0 - ֧֣Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_SoundExist(
								MRPARAM_IN LONG lStreamHandle
								);

/* MRNSDK_Stream_SoundIsOpen
 * жƵǷ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
 * 1ڲƵ0 δţΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_SoundIsOpen(
								MRPARAM_IN LONG lStreamHandle
								);


/* MRNSDK_Stream_SoundPlay
 * Ƶ
   lStreamHandle : (MRNSDK_LiveSingleMRNSDK_NetVodķֵ)
   bStart        : Ƶ־
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Stream_SoundPlay(
								MRPARAM_IN LONG lStreamHandle,  
								MRPARAM_IN int bStart
								);

/********************************** Liveר *************************************/
/* MRNSDK_Live_RegRelinkCallback
 * ͨϿ/ص
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   fdCallback    : صָ
   userdata      : صû
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_RegRelinkCallback(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN fdMRNCb_ChnReLink fdCallback, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_Live_Pause
 * ͣ/ָ
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   bPause        : TRUE - ͣ䣬FALSE - ָ
 * 0ɹΪֵ
 * 鲥ʱЧͣ󲻽ʡ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_Pause(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN BOOL bPause
								);


/* MRNSDK_Live_SaveToFile
 * ļ
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   nFilePackType : ļ(MR_PACKTYPE_TYPE)
   szFileName    : ļ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_SaveToFile(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN int nFilePackType, 
								MRPARAM_IN const char *szFileName
								);

/* MRNSDK_Live_SaveFileSwitch
 * лļ
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   szFileName    : ļ
 * 0ɹΪֵ
 * ڱļУҪһʱļʹøúҪֹͣ¼
   ʹøúСʵֹͣ¼Ͳᶪʧ
 * ڲؼ֡ʱԶرյǰļļ¼
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_SaveFileSwitch(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN const char *szFileName
								);

/* MRNSDK_Live_SaveFileState
 * ļ״̬
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   pFileSize     : ļ¼С
   pFileTime     : ļ¼ʱ()
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_SaveFileState(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_OUT UINT64 *pFileSize, 
								MRPARAM_OUT DWORD *pFileTime
								);

/* MRNSDK_Live_StopSaveFile
 * ֹͣ¼
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_StopSaveFile(
								MRPARAM_IN LONG lLiveHandle
								);

/* MRNSDK_Live_SetDelayMs
 * ͼ񲥷ʱʱ(ʱ)
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   nDelayMs      : (ֵԽͼԽʱԽ󣬷֮Ȼ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_SetDelayMs(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN int nDelayMs
								);

/* MRNSDK_Live_SetRecvTimeout
 * ճʱʱ
   lLiveHandle   : (MRNSDK_LiveSingleķֵ)
   nTimeout		 : λ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Live_SetRecvTimeout(
								MRPARAM_IN LONG lLiveHandle, 
								MRPARAM_IN int nTimeout
								);

/********************************** VODר *************************************/
/* MRNSDK_Vod_GetInxData
 * (û)
   lVodHandle   : ( MRNSDK_NetVod ķֵ)
   pInxBuffer   : ָ
 * 0ΪȣС0Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_GetInxData(
								MRPARAM_IN LONG lVodHandle, 
								MRPARAM_OUT BYTE **pInxBuffer
								);

/* MRNSDK_Vod_Pause
 * ͣ/ָ
   lVodHandle   : (MRNSDK_NetVod ķֵ)
   bPause        : TRUE - ͣFALSE - ָ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_Pause(
								MRPARAM_IN LONG lVodHandle, 
								MRPARAM_IN int bPause
								);

/* MRNSDK_Vod_Step
 * 
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_Step(
								MRPARAM_IN LONG lVodHandle
								);

/* MRNSDK_Vod_SeekToTime
 * ʱת
   lVodHandle   : (MRNSDK_NetVod ķֵ)
   nSecond       : ʱ()
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_SeekToTime(
								MRPARAM_IN LONG lVodHandle, 
								MRPARAM_IN int nSecond
								);

/* MRNSDK_Vod_Fast
 * 
   lVodHandle   : (MRNSDK_NetVod ķֵ)
   nFastValue	: ֵ2, 4, 8, 16ã0 - ڲԶлģʽʹ MRNSDK_Vod_GetPlayMode õǰģʽ
 * 0ɹΪֵ
 * εøúʵֲͬʲ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_Fast(
								MRPARAM_IN LONG lVodHandle,
								MRPARAM_IN int nFastValue
								);

/* MRNSDK_Vod_Slow
 * 
   lVodHandle   : (MRNSDK_NetVod ķֵ)
   nSlowValue	: ֵ2, 4, 8, 16Ӧ1/2, 1/4, 1/8, 1/160 - ڲԶлģʽʹ MRNSDK_Vod_GetPlayMode õǰģʽ
 * 0ɹΪֵ
 * εøúʵֲͬʲ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_Slow(
								MRPARAM_IN LONG lVodHandle,
								MRPARAM_IN int nSlowValue
								);

/* MRNSDK_Vod_GetPlayMode
 * õǰģʽ
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * MRPSDK_MODE_TYPEΪ״̬С0Ϊֵ
 * MRPSDK_MODE_TYPEMRPlaySdkApi.hж
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_GetPlayMode(
								MRPARAM_IN LONG lVodHandle
								);

/* MRNSDK_Vod_BackKeyFrame
 * ˹ؼ֡
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * ɹ0Ϊֵ
 * ֻ֧ļ
*/
MRNSDK_API int  MRNSDK_CALL MRNSDK_Vod_BackKeyFrame(
								MRPARAM_IN LONG lVodHandle
								);

/* MRNSDK_Vod_GetTolTime
 * ļʱ䳤
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * 0Ϊʱ䳤()С0Ϊֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_GetTolTime(
								MRPARAM_IN LONG lVodHandle
								);

/* MRNSDK_Vod_GetCurTime
 * õǰʱ
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * 0Ϊʱ()С0Ϊֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_GetCurTime(
								MRPARAM_IN LONG lVodHandle
								);

/* MRNSDK_Vod_GetVideosByFrames
 * Ŀǰδʹ
   lVodHandle   : (MRNSDK_NetVod ķֵ)
 * 0Ϊʱ()С0Ϊֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_Vod_GetVideosByFrames(
								MRPARAM_IN LONG lVodHandle, 
								MRPARAM_OUT int *pVChnList
								);

/* MRNSDK_DownLoad_Start
 * ļ
   szIP				: IPַ
   wPort			: ˿
   szUserName		: û
   szPassword		: 
   szDeviceID		: 豸ID(תʹ)
   nTimeoutMs		: ʱʱ
   szRemoteFileName	: Զļ
   nStTime			: ʼʱ
   nEdTime			: ʱ
   szLocalFileName  : 汾ļ
 * ؾ0 - ʧ
 * nStTimenEdTimeΪ0ʱԴļмУnEdTimeΪ0ʱļ
*/
MRNSDK_API LONG MRNSDK_CALL MRNSDK_DownLoad_Start(
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN WORD wPort, 
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeoutMs,
								MRPARAM_IN const char *szRemoteFileName, 
								MRPARAM_IN int nStTime, 
								MRPARAM_IN int nEdTime,
								MRPARAM_IN const char *szLocalFileName
								);

/* MRNSDK_DownLoadCut_Start
 * ļ
   szIP				: IPַ
   wPort			: ˿
   szUserName		: û
   szPassword		: 
   szDeviceID		: 豸ID(תʹ)
   nTimeoutMs		: ʱʱ
   szRemoteFileName	: Զļ
   szCutInx			: , JSONʽ
   szLocalFileName  : 汾ļ
 * ؾ0 - ʧ
*/
MRNSDK_API LONG MRNSDK_CALL MRNSDK_DownLoadCut_Start(
								MRPARAM_IN const char *szIP,
								MRPARAM_IN WORD wPort, 
								MRPARAM_IN const char *szUserName, 
								MRPARAM_IN const char *szPassword, 
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeoutMs,
								MRPARAM_IN const char *szRemoteFileName, 
								MRPARAM_IN const char *szCutInx,
								MRPARAM_IN const char *szLocalFileName
								);

/* MRNSDK_DownLoad_GetState
 * ء״̬
   lDownHandle	    : ؾ(MRNSDK_DownLoad_StartMRNSDK_DownLoadCut_Startķֵ)
 * 0 - 100Ϊȣ101 - ؽС0Ϊֵ
*/
MRNSDK_API int  MRNSDK_CALL MRNSDK_DownLoad_GetState(
								MRPARAM_IN LONG lDownHandle
								);

/* MRNSDK_DownLoad_Stop
 * ֹͣء
   lDownHandle	    : ؾ(MRNSDK_DownLoad_StartMRNSDK_DownLoadCut_Startķֵ)
 * 0ɹΪֵ
*/
MRNSDK_API int  MRNSDK_CALL MRNSDK_DownLoad_Stop(
								MRPARAM_IN LONG lDownHandle
								);

/* MRNSDK_SearchDevice
 * ʼ豸
   szIPAddr		 : IPַ(ʱʹ)NULLΪ
   nTimeoutMs	 : ʱʱ(ms)
   fdNetSearchCB : ջص
        szDeviceID	: 豸ID
		szInfo		: 豸Ϣ(JSONʽ)
		userdata	: û
   userdata		 : û
 * ɹ豸С0Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_SearchDevice(
								MRPARAM_IN const char *szIPAddr,
								MRPARAM_IN int nTimeoutMs, 
								MRPARAM_IN void(*fdMRSearchCB)(
										MRPARAM_IN const char *szDeviceID,
										const char *szInfo, 
										void *userdata
										), 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_SearchSetParam
 * 豸
   szDeviceID	: 豸ID
   szParam      : ı(JSONʽ)
 * 0ɹΪֵ
 * ο豸ʾ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_SearchSetParam(
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szParam
								);

/* MRNSDK_SearchFtpUpdate
 * FTP豸
   szFtpIP		: FTPIP
   wFtpPort		: FTP˿
   szFtpDir		: FTPĿ¼
   szFtpName	: FTPû
   szFtpPsw		: FTP
   szFileName	: ļ
 * ɹ0 Ϊ
 * 豸յϢͨFTPļ豸ƥ䣬Զ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_SearchFtpUpdate(
								MRPARAM_IN const char *szFtpIP, 
								MRPARAM_IN unsigned short wFtpPort, 
								MRPARAM_IN const char *szFtpDir, 
								MRPARAM_IN const char*szFtpName, 
								MRPARAM_IN const char *szFtpPsw, 
								MRPARAM_IN const char *szFileName
								);

MRNSDK_API int MRNSDK_CALL MRNSDK_SearchFtpUpdateDevice(
								MRPARAM_IN const int fd, 
								MRPARAM_OUT char *szMac
								);
MRNSDK_API void MRNSDK_CALL MRNSDK_SearchFtpUpdateDeviceStop(MRPARAM_IN const int fd);

/* MRNSDK_SearchControl
 * 豸(֧Ĭϲ)
   szDeviceID	 : 豸ID
   szCmd		 : Ŀǰ֧SapReboot()SapDefault(Ĭ)
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_SearchControl(
								MRPARAM_IN const char *szDeviceID, 
								MRPARAM_IN const char *szCmd
								);


/**************************** ¼ ****************************/
/* MRNSDK_AudioCaptureRecord
 * ¼
   pAudioInfo	: ƵϢ
   fGetData		: ݻص
   userdata		: û
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AudioCaptureRecord(
								MRPARAM_IN MR_AUDIOPARAM_T *pAudioInfo, 
								MRPARAM_IN fdMRNCb_AudioGetData fGetData, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_AudioCaptureStop
 * ֹͣ¼
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_AudioCaptureStop(void);

/* MRNSDK_TalkStart
 * Խ
	pTalkHandle		: Խ
	szIP			: IPַ
	wPort			: ˿
	szUserName		: û
	szPassword		: 
	szDeviceID		: 豸ID(תʹ)
	nTimeroutMs		: ʱʱ()
	pAudioInfo		: Ƶ
	bTwoWayData		: ˫Խ־
	fGetDevData		: ȡնԽݻص
	fStopHandle	    : Խֹ֪ͣͨص
	userdata		: û
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkStart(
								MRPARAM_OUT LONG *pTalkHandle,
								MRPARAM_IN const char *szIP,
								MRPARAM_IN WORD wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeroutMs,
								MRPARAM_IN MR_AUDIOPARAM_T *pAudioInfo,
								MRPARAM_IN BOOL bTwoWayData,
								MRPARAM_IN fdMRNCb_AudioGetData fGetDevData,
								MRPARAM_IN fdMRNCb_AudioStop fStopHandle,
								MRPARAM_IN void *userdata
								);

/* MRNSDK_TalkSendData
 * ͶԽ
	lTalkHandle		: Խ, MRNSDK_TalkStartֵ
	pBuffer			: Ƶ
	pts				: ʱ
	nSize			: ݴС
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkSendData(
								MRPARAM_IN LONG lTalkHandle, 
								MRPARAM_IN BYTE *pBuffer, 
								MRPARAM_IN int pts, 
								MRPARAM_IN int nSize
								);

/* MRNSDK_TalkStop
 * ֹͣԽ
	lTalkHandle		: Խ, MRNSDK_TalkStart ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkStop(
								MRPARAM_IN LONG lTalkHandle
								);

/* MRNSDK_TalkBroadcastStart
 * Ƶ㲥ͨ
	pMultiTalkHandle	: Ƶ㲥
	szMultiCastIP		: 鲥IPַ
	wMultiCastPort		: 鲥˿
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkBroadcastStart(
								MRPARAM_OUT LONG *pTalkBroadHandle,
								MRPARAM_IN const char *szMultiCastIP, 
								MRPARAM_IN WORD wMultiCastPort
								);

/* MRNSDK_TalkMulticastSendData
 * ͹㲥Ƶ
	lTalkBroadHandle	: 鲥ԽMRNSDK_TalkBroadcastStart ֵ
	pBuffer				: Ƶ
	pts					: ʱ
	nSize				: ݴС
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkBroadcastSendData(
								MRPARAM_IN LONG lTalkBroadHandle,
								MRPARAM_IN BYTE *pBuffer, 
								MRPARAM_IN int pts, 
								MRPARAM_IN int nSize
								);

/* MRNSDK_TalkBroadcastStop
 * ֹͣƵ㲥
	lTalkBroadHandle	: 鲥ԽMRNSDK_TalkBroadcastStart ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TalkBroadcastStop(
								MRPARAM_IN LONG lTalkBroadHandle
								);

/* MRNSDK_MulticastDataRecv_Start
 * 鲥ͨ
   pRecvPort		: վ
   szMultiCast		: 鲥ַ
   wPort			: 鲥˿
   fdRecvHandle		: ݻص
   userdata			: û
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MulticastDataRecv_Start(
								MRPARAM_OUT LONG *pRecvPort,
								MRPARAM_IN const char *szMultiCast, 
								MRPARAM_IN int wPort, 
								MRPARAM_IN fdMRNCb_MulticastRecvData fdRecvHandle, 
								MRPARAM_IN void *userdata
								);

/* MRNSDK_MulticastDataRecv_Stop
 * ֹͣ鲥ݽ
   lRecvPort		: 鲥վ, MRNSDK_MulticastDataRecv_Start ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MulticastDataRecv_Stop(
								MRPARAM_IN LONG lRecvPort
								);

/* MRNSDK_MulticastDataSend_Start
 * 鲥ͨ
   pSendPort		: ؾ
   bStart			: /ֹͣ־
   szMultiCast		: 鲥ַ
   wPort			: 鲥˿
   nFifoNum			: FIFO
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MulticastDataSend_Start(
								MRPARAM_OUT LONG *pSendPort,
								MRPARAM_IN const char *szMultiCast, 
								MRPARAM_IN int wPort,
								MRPARAM_IN int nFifoNum
								);

/* MRNSDK_MulticastDataSend_SendFrame
 * 
   lSendPort		: 鲥;, MRNSDK_MulticastDataSend_Start ֵ
   pkt				: ֡
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MulticastDataSend_SendFrame(
								MRPARAM_IN LONG lSendPort,
								MRPARAM_IN MRAVFrame *pkt
								);

/* MRNSDK_MulticastDataSend_Stop
 * ֹͣ鲥ͨ
   lSendPort		: 鲥;, MRNSDK_MulticastDataSend_Start ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MulticastDataSend_Stop(
								MRPARAM_IN LONG lSendPort
								);

/* MRNSDK_UploadMsgPort_Open
 * ϴϢͨ
   pMsg			: Ϣ
   szIP			: IPַ
   wPort		: ˿
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   nMaskValue	: , 
					0x01 - ź
					0x02 - /ػϢ
					0x04 - GPS
					-1 - ϴϢ
   nTimeOutMs	: ӳʱʱ()
   fdEventHandle: ״̬֪ͨص
		lMsg	: ϢMRNSDK_UploadMsgPort_Openֵ
		nState  : ״̬, 1 - ߣ0 - , ʱ1ֵϿ
		userdata: û
   fdRecvMsgHandle	: Ϣص
		lMsg	: Ϣ, MRNSDK_UploadMsgPort_Open ֵ
		szMsg   : յϢ
		userdata: û
   userdata		: û
 * ɹ0 Ϊ
 * ʹϴϢͨ豸ź
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_UploadMsgPort_Open(
								MRPARAM_OUT LONG *pMsg, 
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nMaskValue,
								MRPARAM_IN int nTimeOutMs,
								MRPARAM_IN int(*fdEventHandle)(
											MRPARAM_IN LONG lMsg, 
											MRPARAM_IN int nState,
											MRPARAM_IN void *userdata
											),
								MRPARAM_IN void(*fdRecvMsgHandle)(
											MRPARAM_IN  LONG lMsg,
											MRPARAM_IN const char *szMsg, 
											MRPARAM_IN void *userdata
											),
								MRPARAM_IN void *userdata
								);

/* MRNSDK_UploadMsgPort_Close
 * رϴϢͨ
   lMsg		: Ϣ, MRNSDK_UploadMsgPort_Open ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_UploadMsgPort_Close(
								MRPARAM_IN LONG lMsg
								);

/* MRNSDK_MsgPort_Open
 * Ϣͨ
   pMsg			: Ϣ
   szIP			: IPַ
   wPort		: ˿
   szUserName	: û
   szPassword	: 
   szDeviceID	: 豸ID
   nTimeOutMs	: ӳʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MsgPort_Open(
								MRPARAM_OUT LONG *pMsg, 
								MRPARAM_IN const char *szIP, 
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeOutMs
								);

/* MRNSDK_MsgPort_SendMsg
 * ͽϢ
   lMsg				: Ϣ, MRNSDK_MsgPort_Open ֵ
   szIP				: IPַ
   szSendMsg		: ͵Ϣ
   szSendFileName	: ͵ļ
   szRecvMsg		: Ϣַָ
   szRecvFileName	: ļַָ
   nTimeoutMs		: ʱʱ()
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MsgPort_SendMsg(
								MRPARAM_IN LONG lMsg, 
								MRPARAM_IN const char *szSendMsg, 
								MRPARAM_IN const char *szSendFileName, 
								MRPARAM_IN char **szRecvMsg, 
								MRPARAM_IN char **szRecvFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_MsgPort_Close
 * رϢͨ
   lMsg				: Ϣ, MRNSDK_MsgPort_Open ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_MsgPort_Close(
								MRPARAM_IN LONG lMsg
								);

/* MRNSDK_TranDataPort_Open
 * ͸ͨ
   pDataPort	: Ϣ
   pInfo		: ͸ͨ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranDataPort_Open(
								MRPARAM_IN LONG *pDataPort, 
								MRPARAM_IN MRSDK_TRANDATA_PORT_T * pInfo
								);

/* MRNSDK_TranDataPort_SendFrame
 * ͸ͨһ֡
   lDataPort : Ϣ, MRNSDK_TranDataPort_Open ֵ
   pkt		 : ָ֡
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranDataPort_SendFrame(
								MRPARAM_IN LONG lDataPort, 
								MRPARAM_IN MRAVFrame *pkt
								);

/* MRNSDK_TranDataPort_Close
 * ر͸ͨ
   lDataPort : Ϣ, MRNSDK_TranDataPort_Open ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranDataPort_Close(
								MRPARAM_IN LONG lDataPort
								);

/* MRNSDK_TranDataPort_Bind
 * /͸ͨ
   bBind		: TRUE - 󶨣FALSE - 
   lDataPortSrc	: Դ͸ͨ
   lDataPortDst	: Ŀ͸ͨ
 * ɹ0 Ϊ
 * 󶨳ɹûղݻصúҪ͸ݵת(Խڵת)
 * 󶨺ûҲܷ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranDataPort_Bind(
								MRPARAM_IN int bBind,			
								MRPARAM_IN LONG lDataPortSrc,
								MRPARAM_IN LONG lDataPortDst
								);

/* MRNSDK_TranMsgPort_Open
 * ͸Ϣͨ
   pMsgPort	: Ϣ
   pInfo	: ͸Ϣͨ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranMsgPort_Open(
								MRPARAM_IN LONG *pMsgPort, 
								MRPARAM_IN MRSDK_TRANMSG_PORT_T * pInfo
								);

/* MRNSDK_TranMsgPort_SendMsg
 * Ϣ
   lMsgPort			: Ϣ MRNSDK_TranMsgPort_Open ֵ
   szSendMsg		: ͵Ϣָ
   szSendFileName	: ͵ļ
   nTimeoutMs		: ͳʱʱ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranMsgPort_SendMsg(
								MRPARAM_IN LONG lMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_TranMsgPort_SendRecvMsg
 * ͺͽϢ
   lMsgPort			: Ϣ MRNSDK_TranMsgPort_Open ֵ
   szSendMsg		: ͵Ϣָ
   szSendFileName	: ͵ļ
   pRecvMsg			: Ϣַָ
   pRecvFileName    : ļַָ
   nTimeoutMs		: ͺͽճʱʱ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranMsgPort_SendRecvMsg(
								MRPARAM_IN LONG lMsgPort, 
								MRPARAM_IN const char *szSendMsg,
								MRPARAM_IN const char *szSendFileName,
								MRPARAM_OUT char **pRecvMsg,
								MRPARAM_OUT char **pRecvFileName,
								MRPARAM_IN int nTimeoutMs
								);

/* MRNSDK_TranMsgPort_Close
 * ر͸Ϣͨ
   lMsgPort			: Ϣ MRNSDK_TranMsgPort_Open ֵ
 * ɹ0 Ϊ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranMsgPort_Close(
								MRPARAM_IN LONG lMsgPort
								);

/* MRNSDK_TranMsgPort_Bind
 * /͸Ϣͨ
   bBind		: TRUE - 󶨣FALSE - 
   lMsgPortSrc	: ԴϢͨ
   lMsgPortDst	: ĿϢͨ
 * ɹ0 Ϊ
 * 󶨳ɹûղϢصúҪϢת
 * 󶨺ûҲܷϢ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_TranMsgPort_Bind(
								MRPARAM_IN int bBind,
								MRPARAM_IN LONG lMsgPortSrc,
								MRPARAM_IN LONG lMsgPortDst
								);

/* MRNSDK_PtzControl
 * ̨
   szIP			: IPַ
   wPort		: ˿
   szDeviceID	: 豸ID(תʱҪ)
   szUserName	: û
   szPassword	: 
   nTimeOutMs	: ʱʱ()
   nChanel		: ͨ
   szPtzCmd		: ̨,MRComm.hMR_PTZCMD_LEFT_START
   byValue      : ڲͬ岻ͬ
				  MR_PTZCMD_LEFT_START - MR_PTZCMD_ZOOM_DEC_STOP : byValue: ΪٶֵpExtParam: Ч
				  MR_PTZCMD_PRESET_SET - MR_PTZCMD_PRESET_CLEAN  : byValue: Ԥõ㣬pExtParam: Ч
				  MR_PTZCMD_3DLOCATE							 : byValue: ЧpExtParam: MR_PTZ3DLOCAL_T
   pExtParam    : չͲͬ
 * 0ɹΪֵ
*/
MRNSDK_API int MRNSDK_CALL MRNSDK_PtzControl(
								MRPARAM_IN const char *szIP,
								MRPARAM_IN unsigned short wPort,
								MRPARAM_IN const char *szUserName,
								MRPARAM_IN const char *szPassword,
								MRPARAM_IN const char *szDeviceID,
								MRPARAM_IN int nTimeOutMs,
								MRPARAM_IN int nChanel,
								MRPARAM_IN const char *szPtzCmd,
								MRPARAM_IN unsigned char byValue,
								MRPARAM_IO void *pExtParam
								);

MRNSDK_API int MRNSDK_CALL MRNSDK_SearchSendCmd(
								MRPARAM_IN unsigned char *pCmd, 
								MRPARAM_IN int nCmdLen
								);
#ifdef __cplusplus
}
#endif
#endif//__MRNETSDK_API_H__
