// MRConfCamEnv.h
#ifndef __MR_CONFCAM_ENV_H__
#define __MR_CONFCAM_ENV_H__

#include "MRComm.h"
//
/******************  ********************************/
// ϵͳϢ
#define MRCONFC_ENVCMD_SYSATTR		"SysAttr"		// 
// ϵͳʱ
#define MRCONFC_ENVCMD_SYSTIME		"SysTime"		// 
// û
#define MRCONFC_ENVCMD_SYSUSER		"SysUser"		// 
// ϵͳ
#define MRCONFC_ENVCMD_SYSCTRL		"SysCtrl"		// 
// Ƶ
#define MRCONFC_ENVCMD_AUDIO		"Audio"			// 
// Ƶ
#define MRCONFC_ENVCMD_VIDEOOUT		"VideoOut"		//
// Ƶ
#define MRCONFC_ENVCMD_VIDEOOSD		"VideoOsd"		// 
// USB OSD
#define MRCONFC_ENVCMD_USBOSD		"USBOsd"		// 
// Ƶ
#define MRCONFC_ENVCMD_VIDEOENCODE	"VideoEncode"	// 
// Ƶ
#define MRCONFC_ENVCMD_VIDEOPARAM	"VideoParam"	// 
// 
#define MRCONFC_ENVCMD_NETWORK		"NetWork"		// 
// 洢
#define MRCONFC_ENVCMD_RECSTORE		"RecStore"		// 
// ARM System
#define MRCONFC_ENVCMD_ARMSYSTEM	"ArmSystem"		// 
// ARM PTZ
#define MRCONFC_ENVCMD_ARMPTZ		"ArmPtz"		// 
// Font Size
#define MRCONFC_ENVCMD_FONTSIZE		"FontSize"		//
#define MRCONFC_ENVCMD_TTFFONTSIZE	"TTFFontSize"		// 
// ƽ̨
#define MRCONFC_ENVCMD_PLATFORMCONNECT	"PlatformConnect"	// 
// ʦ
#define MRCONFC_ENVCMD_TEACHERTRACK	"TeacherTrack"	//
// 
#define MRCONFC_ENVCMD_PUBLISH		"StreamPublish"		// 
// RTP
#define MRCONFC_ENVCMD_RTPMULTICAST	"StreamRTPMulticast"	// 

// ̨
#define MRCONFC_ENVCMD_PTZATTR		"PTZAttr"
//Ŵ
#define MRCONFC_ENVCMD_PTZZOOMIN		"PTZZoomIn"

// IPַ֪ͨ
#define MRCONFC_ENVCMD_IPADDRNOTIFY	"IPAddrNotify"		// MR_IPADDR_NOTIFY_CFG

// Vo OSD
#define MRCONFC_ENVCMD_VO_OSD		"VoOsd"				// MRCONFC_VO_OSD_CFG
// Vo 
#define MRCONFC_ENVCMD_COVER		"Cover"				// MRCONFC_COVER_CFG
/****************** ϵͳ ********************************/
// Ĭ
#define MRCONFC_CTRLCMD_DEFAULT		"Default"
// 
#define MRCONFC_CTRLCMD_REBOOT		"Reboot"
// 
#define MRCONFC_CTRLCMD_ALARMOUT	"Alarmout"
// ̨
#define MRCONFC_CTRLCMD_PTZCTRL		"PtzCtrl"
// ͬNTP
#define MRCONFC_CTRLCMD_SYNCNTP		"SyncNtp"
// ñʱ
#define MRCONFC_CTRLCMD_SETTIME		"SetTime"
// ʽӲ
#define MRCONFC_CTRLCMD_FORMATDISK	"FormatDisk"
// һƽ
#define MRCONFC_CTRLCMD_TRIGGLE_ONEPUSHWB	"TriggleOnePushWb"
// WiFi
#define MRCONFC_CTRLCMD_WIFICONNECT	"WifiConnect"

#define MR_PTZCMD_BOUND				"onvif_bound"			//Ŀߣxy

// UT10
// ʼֹͣUDPͱ
#define MRCONFC_CTRLCMD_UT10_UDPENC	"UT10_UdpEncode"

// SD¼
#define MRCONFC_CTRLCMD_SDCARDRECORD	"SDCardRecord"

// ǿƱؼ֡
#define MRCONFC_CTRLCMD_ENCKEYFRAME	"EncKeyFrame"

/****************** ״̬ѯ ********************************/
// 豸
#define MRCONFC_QUYCMD_GETDEVATTR	"GetDevAttr"		// 
// ϵͳ״̬
#define MRCONFC_QUYCMD_GETSYSSTATE	"GetSysState"
// Ӳ
#define MRCONFC_QUYCMD_GETDISK		"GetDisk"			// 
// ¼
#define MRCONFC_QUYCMD_GETRECDAYS	"GetRecDays"
// ѯ¼
#define MRCONFC_QUYCMD_QUYRECORD	"QueryRecord"
// ѯ־
#define MRCONFC_QUYCMD_QUYLOG		"QueryLog"
// ѯ̨λ
#define MRCONFC_QUYCMD_SYSTIME		"QuerySysTime"
// ѯϵͳ֧
#define MRCONFC_QUYCMD_STREAMNAME	"QueryStreamName"
// ѯ汾
#define MRCONFC_QUYCMD_VERSION		"QueryVersion"	// MRCONFC_CAMVERSION_T
// ѯWifiڵ
#define MRCONFC_QUYCMD_WIFINODE		"QueryWifiNode"
// ѯ۽ģʽ
#define MRCONFC_QUYCMD_AFMODE		"QueryAFMode"
//ѯ¼״̬
#define MRCONFC_QUYCMD_SDRECORDSTATE "GetSDRecordSTATE"
/***************************Ѳ*****************************/
//ѯѲϢ
#if defined(PRESET_CRUISE)
#define MRCONFC_QUYCMD_PRESETTOUR	"QueryPresettour"		// ѯԤλѲϢ
#endif
/***************************Ѳ*******************************/

/****************** 뵼ѯ ********************************/
// 
#define MRCONFC_IMPCMD_IMPUPDATE	"ImportUpdate"
// ϵͳ
#define MRCONFC_IMPCMD_IMPCONFIG	"ImportConfig"
// ϵͳ
#define MRCONFC_IMPCMD_EXPCONFIG	"ExportConfig"
// ̨Э
#define MRCONFC_IMPCMD_IMPPTZFILE	"ImportPtzFile"
// ץJPEG
#define MRCONFC_IMPCMD_CAPJPEG		"ExpCaptureJpeg"
// ͼ
#define MRCONFC_IMPCMD_IMPIMAGECFG	"ImportImageCfg"
// ͼ
#define MRCONFC_IMPCMD_EXPIMAGECFG	"ExportImageCfg"
/******************  ********************************/
// 
#define MRCONFC_SAPCMD_SEARCH		"SapSearch"
// Ftp
#define MRCONFC_SAPCMD_FTPUPDATE	"FtpUpdate"
// ò
#define MRCONFC_SAPCMD_SETPARAM		"SetParam"
// 
#define MRCONFC_SAPCMD_REBOOT		"SapReboot"
// Ĭ
#define MRCONFC_SAPCMD_DEFAULT		"SapDefault"

/****************** ϴϢ ********************************/
// ϵͳ
#define MRCONFC_PUSHMSG_SYSREBOOT	"SysReboot"

#define MRCONFC_NMAX_FONTSIZE           8		// osd֧С
#define MRCONFC_NMAX_USERS				3		// û
#define MRCONFC_NMAX_ACODEC				3		// ƵCodec
#define MRCONFC_NMAX_VOFMT				16		// ֧ʽ
#define MRCONFC_NMAX_EXPMODE			8		// عģʽ
#define MRCONFC_NMAX_IRIS				16		// IRIS
#define MRCONFC_NMAX_SHUTTER			17		// 

#define MRCONFC_NMAX_CCM				9		//CCMɫ

#if defined (CONFIG_OLD_WBMODE)
#define MRCONFC_NMAX_WBMODE		    	20		// ƽģʽ
#else
#define MRCONFC_NMAX_WBMODE		    	60		// ƽģʽ
#endif
// Ƶ
typedef enum{
	MRCONFC_VSTREAM_MASTER = 0,		// 
	MRCONFC_VSTREAM_SLAVE,			// 
	MRCONFC_VSTREAM_MOBILE,			// ֻ
	MRCONFC_VSTREAM_NUMS,
}MRCONFC_VSTREAM_TYPE;

typedef enum{
	MRCONFC_PANVSTREAM_MASTER = 0,		// 
	MRCONFC_PANVSTREAM_SLAVE,			// 
	MRCONFC_PANVSTREAM_PAN_MASTER,		// ȫ
	MRCONFC_PANVSTREAM_PAN_SLAVE,		// ȫ
	MRCONFC_PANVSTREAM_NUMS,
}MRCONFC_PANVSTREAM_TYPE;

// Զ۽ģʽ
typedef enum{
	MRCONFC_AFMODE_AUTO		= 0X02,		// Զ
	MRCONFC_AFMODE_MANUAL	= 0x03,		// ֶ
	MRCONFC_AFMODE_ONEPUSH	= 0x04,		// OnePush
}MRCONFC_AFMODE_TYPE;

// Զ۽Ȩ
typedef enum{
	MRCONFC_AFZONE_TOP = 0,				// 
	MRCONFC_AFZONE_CENTER,				// 
	MRCONFC_AFZONE_BOTTOM,				// 
	MRCONFC_AFZONE_ALL,					// ȫ
}MRCONFC_AFZONE_TYPE;

// عģʽӦֵб
typedef enum{
	MRCONFC_EXPMODE_AUTO		= 0x00,
	MRCONFC_EXPMODE_MANUAL		= 0x03,
	MRCONFC_EXPMODE_SHUTTER		= 0x0A,
	MRCONFC_EXPMODE_IRIS		= 0x0B,
	MRCONFC_EXPMODE_BRIGHT		= 0x0D,
}MRCONFC_EXPMODE_TYPE;

// ˸
typedef enum{
	MRCONFC_FLICKER_OFF = 0,
	MRCONFC_FLICKER_50HZ,
	MRCONFC_FLICKER_60HZ,
}MRCONFC_FLICKER_TYPE;

// ɫ
typedef enum{
	MRCONFC_COLSTYLE_DEFAULT = 0,	// ĬϷ
	MRCONFC_COLSTYLE_NORMAL,		// ׼
	MRCONFC_COLSTYLE_CLARITY,		// 
	MRCONFC_COLSTYLE_BRIGHT,		// 
	MRCONFC_COLSTYLE_SOFT,			// 
	MRCONFC_COLSTYLE_FACE,			// 
	MRCONFC_COLSTYLE_NUMS,
}MRCONFC_COLSTYLE_TYPE;

typedef enum{
	MRCONFC_FLIP_OFF = 0,
	MRCONFC_FLIP_H,
	MRCONFC_FLIP_V,
	MRCONFC_FLIP_HV,
}MRCONFC_FLIP_TYPE;

//ƽģʽӦֵб
typedef enum {
	
	MRCONFC_WBMODE_AUTO			= 0x00,
	MRCONFC_WBMODE_3000K		= 0x01,
	MRCONFC_WBMODE_4000K		= 0x02,
	MRCONFC_WBMODE_ONEPUSH		= 0x03,
	MRCONFC_WBMODE_5000K		= 0x04,		// 5000K
	MRCONFC_WBMODE_MANUAL		= 0x05,
	MRCONFC_WBMODE_6500K		= 0x06,		// 6500K
	MRCONFC_WBMODE_3500K		= 0x07,
	MRCONFC_WBMODE_4500K		= 0x08,
	MRCONFC_WBMODE_5500K		= 0x09,
	MRCONFC_WBMODE_6000K		= 0x0A,
	MRCONFC_WBMODE_7000K		= 0x0B,
	
	MRCONFC_WBMODE_USR3000K		= 0X20,		
	MRCONFC_WBMODE_USR7000K		= 0X48,
#if !defined (CONFIG_OLD_WBMODE)
	MRCONFC_WBMODE_2400K		= 0x0C,
	MRCONFC_WBMODE_2500K		= 0x0D,
	MRCONFC_WBMODE_2600K		= 0x0E,		
	MRCONFC_WBMODE_2700K	    = 0x0F,		
	MRCONFC_WBMODE_2800K	    = 0x10,
	MRCONFC_WBMODE_2900K	    = 0x11,		// 2900K
	
	MRCONFC_WBMODE_3100K	    = 0x12,
	MRCONFC_WBMODE_3200K	    = 0x13,
	MRCONFC_WBMODE_3300K	    = 0x14,
	MRCONFC_WBMODE_3400K    	= 0x15,
	
	MRCONFC_WBMODE_3600K	    = 0x16,
	MRCONFC_WBMODE_3700K	    = 0x17,
	MRCONFC_WBMODE_3800K	    = 0x18,
	MRCONFC_WBMODE_3900K	    = 0x19,		

	MRCONFC_WBMODE_4100K        = 0x1A,		
	MRCONFC_WBMODE_4200K	    = 0x1B,
	MRCONFC_WBMODE_4300K	    = 0x1C,
	MRCONFC_WBMODE_4400K	    = 0x1D,

	MRCONFC_WBMODE_4600K	    = 0x1E,
	MRCONFC_WBMODE_4700K	    = 0x1F,
	MRCONFC_WBMODE_4800K	    = 0x21,
	MRCONFC_WBMODE_4900K	    = 0x22,
	
	MRCONFC_WBMODE_5100K	    = 0x23,
	MRCONFC_WBMODE_5200K	    = 0x24,		
	MRCONFC_WBMODE_5300K	    = 0x25,
	MRCONFC_WBMODE_5400K	    = 0x26,		// 5400K

	MRCONFC_WBMODE_5600K	    = 0x27,
	MRCONFC_WBMODE_5700K	    = 0x28,
	MRCONFC_WBMODE_5800K	    = 0x29,
	MRCONFC_WBMODE_5900K	    = 0x2A,

	MRCONFC_WBMODE_6100K	    = 0x2B,		
	MRCONFC_WBMODE_6200K	    = 0x2C,
	MRCONFC_WBMODE_6300K	    = 0x2D,		
	MRCONFC_WBMODE_6400K	    = 0x2E,

	MRCONFC_WBMODE_6600K	    = 0x2F,
	MRCONFC_WBMODE_6700K	    = 0x30,
	MRCONFC_WBMODE_6800K	    = 0x31,
	MRCONFC_WBMODE_6900K        = 0X32,		

	MRCONFC_WBMODE_7100k	    = 0x33,
#endif
}MRCONFC_WBMODE_TYPE;

// ƽ
typedef enum{
	MRCONFC_WBSENS_LOW = 0,
	MRCONFC_WBSENS_MID,
	MRCONFC_WBSENS_HIGH,
}MRCONFC_WBSENS_TYPE;

typedef enum{
	MRCONFC_IRISMODE_MANUAL = 0,
	MRCONFC_IRISMODE_AUTO,
}MRCONFC_IRISMODE_TYPE;

typedef struct{
	DWORD				dwKernelVersion;					// ں˰汾
	DWORD				dwKernelBuildDate;					// ں˱ʱ : 16λΪ꣬м8λ£8λΪ
	DWORD				dwWebVersion;						// Web汾
	DWORD				dwWebDate;							// Webʱ
}MRCONFC_VERSION_T;

typedef struct{
	BYTE				bCamVersion;
	BYTE				bAFVersion;
	BYTE				bArmVersion;

	DWORD				dwCamVersion;						// 汾
	DWORD				dwCamDate;							// ʱ : 16λΪ꣬м8λ£8λΪ
	DWORD				dwAFVersion;						// ۽汾
	DWORD				dwAFDate;							// ۽ʱ
	DWORD				dwArmVersion;						// ARM汾
	DWORD				dwArmDate;							// ARMʱ
}MRCONFC_CAMVERSION_T;

typedef struct{
	MRCONFC_VERSION_T	stVersion;							// 汾
	char				szProductName[MR_SLEN_DEVNAME];		// Ʒ
	char				szDevName[MR_SLEN_DEVNAME];			// 豸
	char				szDeviceID[MR_SLEN_DEVICEID];		// 豸ID
	char				szDevSerialNo[MR_SLEN_SERIALNO];	// к
	int					nDevType;							// 豸, MR_DEVICE_TYPE
	WORD				wDataPort;							// ݶ˿
	WORD				wSoapPort;							// Soap˿
	WORD				wRtspPort;							// RTSP˿
	WORD				wRtmpPort;							// RTMP˿
}MRCONFC_DEVATTR_T;

typedef struct{
	char			szName[32];
	int				nValue;
}MRCONFC_PARAMLIST_T;

// 豸
typedef struct{
	char	szDevName[MR_SLEN_DEVNAME];		// 豸
	char    szDeviceID[MR_SLEN_DEVICEID];	// 豸ID
	int		emVideoStandard;				// Ƶʽ
	int		nLanguage;						// ϵͳ
}MRCONFC_SYSATTR_CFG;

typedef struct{
	int						nDateFormat;				// ڸʽ, 0:YYYY-MM-DD, 1:MM-DD-YYYY, 2: DD-MM-YYYY
	int						nDateSprtr;					// ڷָ(0"."1"-"2"/")
	int						nZone;						// ʱ
	int						nHourType;					// ʱ 0 - 24Сʱ, 1 - 12Сʱ
	int						nSetType;					//ʱʵ
	MR_NTP_T				stNtp;						// NTP
}MRCONFC_SYSTIME_CFG;

// ϵͳû
typedef struct{
	int	nUserType;						// ֻ, 0 - Ա 1 - ͨû
	char szUserName[MR_SLEN_USERNAME];	// û
	char szPassword[MR_SLEN_PASSWORD];	// 
}MRCONFC_USER_T;
typedef struct{
	int				nMaxCount;						// 
	int				nCount;							// û
	MRCONFC_USER_T	stUsers[MRCONFC_NMAX_USERS];	// ûб
}MRCONFC_SYSUSER_CFG;

// Ƶ
typedef struct{
	// ֻ
	int						nAudioCodecNums;					// byAudioCodecList
	BYTE					byAudioCodecList[MRCONFC_NMAX_ACODEC];	// Ƶѹʽб MR_AUDIOCODEC_TYPE
	int						nAudioSmstMask[MRCONFC_NMAX_ACODEC];	// Ƶ MR_AUDIO_SMST_MASK
	// 
	int						bEnable;		// Ƶ/
	int						nInpVolume;		// (1С - 10)
	int						nAEncType;		// Ƶѹʽ, MR_AUDIOCODEC_TYPE
	int						nSampleRate;	// Ƶ(16000, 32000, 44100, 48000)
	int						nSampleBits;	// ȣ̶16λ
	int						nBitRate;		// ѹ(32K, 48K, 64K, 96K, 128K),PCMʱЧ
	int						nChannel;		// ͨ, 1 or 2
}MRCONFC_AUDIO_CFG;

// Ƶ
typedef struct{
	// 
	int						nIndex;						// ţֻ
	BOOL					bEnable;					// ʾ־
	int						nXPos;						// Xλãλãֱ0-10000
	int						nYPos;						// Yλãλãֱ0-10000
	MR_RGBA					stFtColor;					// ǰɫ
	MR_RGBA					stBkColor;					// ɫ
	char					szText[MR_SLEN_OSDSTRING];	// OSDַ, ʱЧ
}MRCONFC_OSDCHN_T;
typedef struct{
	// 
	int						nIndex;						// ţֻ
	BOOL					bEnable;					// ʾ־
	int						nFontSize;					// С(8 - 240)
	int						nXPos;						// Xλãλãֱ0-10000
	int						nYPos;						// Yλãλãֱ0-10000
	MR_RGBA					stFtColor;					// ǰɫ
	MR_RGBA					stBkColor;					// ɫ
	char					szText[MR_SLEN_OSDSTRING];	// OSDַ, ʱЧ
}MRCONFC_OSDCHNEXT_T;
typedef struct{
	int					nChannel;						// ͨ(ֻ)
	MRCONFC_OSDCHN_T	stTime;							// ʱ
	MRCONFC_OSDCHN_T	stTitle;						// 
	MRCONFC_OSDCHN_T	stUser[MR_NMAX_OSDUSERS];		// Զ
}MRCONFC_VIDEOOSD_CFG;

// Ƶ
typedef struct{
	// 
	int						nIndex;						// ţֻ
	BOOL					bEnable;					// ʾ־
	int						nXPos;						// Xλãλãֱ0-10000
	int						nYPos;						// Yλãλãֱ0-10000
	MR_RGBA					stFtColor;					// ǰɫ
	MR_RGBA					stBkColor;					// ɫ
	char					szText[1024];				// OSDַ, ʱЧ
}MRCONFC_USBOSDCHN_T;

typedef struct{
	int  nFontCount;									// szFontList(ֻ)
	char szFontList[MRCONFC_NMAX_FONTSIZE][32];			// б(ֻ)
	int	 nFontSize[MRCONFC_VSTREAM_NUMS];				// С(szFontListС)
}MRCONFC_OSDFONTSIZE_CFG;

typedef struct{
	BOOL bAutoSize;										// ݲֱͬʣԶŴС
	int  nFontCount;
	int  nFontSize[MRCONFC_VSTREAM_NUMS];				// С
}MRCONFC_OSDFONTSIZE_TTF_CFG;

// ѹ
typedef struct{
	DWORD					dwVideoCodecMask;			// , 1 << MR_VIDEOCODEC_TYPE
	DWORD					dwMaxBitRate;				// 
	int						nMaxFrameRate;				// ֡
	int						nImageSizeNums;				// ֵ֧ķֱ
	BYTE					byImageSizeList[MR_NAMX_VFORMATS];	// ֵ֧ķֱ, MR_VIDEOSIZE_TYPE
	
	// 
	MRCONFC_VSTREAM_TYPE	emStreamType;				// 
	MR_VIDEOCODEC_TYPE		emVideoCodec;				// Ƶѹʽ, 1-Mjpeg, 5-H.264, 7-H.265
	MR_VIDEOSIZE_TYPE		emImageSize;				// Ƶߴ
	MR_BITRATE_TYPE			emBitRateCtrl;				// ģʽ
	BYTE					byImageQuality;				// ͼ(0-5), 0 - , 5 - , emBitRateCtrlΪ MR_BITRATE_VBR ʱЧ
	int						nBitRate;					// CBRʱƽVBRʱΪ
	int						nQfactor;					// (1-99)
	int						nFrameRate;					// Ƶ֡, 1-nΪÿ֡
	int						nIFrameInterval;			// ؼ֡֡(1-200)
	BYTE					byIFrameMinQP;				// ؼ֡СQPڿƹؼ֡С(10, 51)
	char					szStreamName[MR_SLEN_STREAMNAME];	// (ֻ)
	BYTE					byProfile;
}MRCONFC_VIDEOFORMAT_T;

typedef struct{
	BYTE					abMaster;					// ֧
	BYTE					abSlave;					// ֧
	BYTE					abMobile;					// ֻ֧
	int						nChannel;					// ͨ(ֻ)

	MRCONFC_VIDEOFORMAT_T	stMaster;					// 
	MRCONFC_VIDEOFORMAT_T	stSlave;					// 
	MRCONFC_VIDEOFORMAT_T	stMobile;					// ֻ
}MRCONFC_VIDEOENCODE_CFG;

// 
typedef struct{
	int			nAbProtolMask;							// ֵ֧Э(ֻ), 0x01 - RTMP, 0x02 - RTSP		
	
	BOOL		bEnable;								// ʹ
	int			nProtolType;							// 0 - RTMP, 1 - RTSP
	WORD		wHostPort;								// Host˿
	char		szHostUrl[MR_SLEN_STREAMNAME];			// Hostַ
	char		szStreamName[MR_SLEN_STREAMNAME];		// ƣlive/av1_0
	char		szUserName[MR_SLEN_USERNAME];			// û
	char		szPassword[MR_SLEN_USERNAME];			// 
}MRCONFC_STREAM_PUBLISH_T;
typedef struct{
	BYTE						abMaster;				// ֧(ֻ)
	BYTE						abSlave;				// ֧(ֻ)
	BYTE						abMobile;				// ֻ֧(ֻ)
	int							nChannel;				// ͨ(ֻ)
	MRCONFC_STREAM_PUBLISH_T	stMaster;				// 
	MRCONFC_STREAM_PUBLISH_T	stSlave;				// 
	MRCONFC_STREAM_PUBLISH_T	stMobile;				// ֻ
}MRCONFC_PUBLISH_T;

typedef struct{
	BOOL		bEnable;								// ʹܱ־
	int			nProtolType;							// 0 - RTP, 1 - TS
	WORD		wMultiCastPort;							// ˿
	char		szMultiCastUrl[MR_SLEN_IPADDR];			// ַ
}MRCONFC_STREAM_RTPMULTICAST_T;
typedef struct{
	BYTE							abMaster;			// ֧(ֻ)
	BYTE							abSlave;			// ֧(ֻ)
	BYTE							abMobile;			// ֻ֧(ֻ)
	int								nChannel;			// ͨ(ֻ)
	MRCONFC_STREAM_RTPMULTICAST_T	stMaster;			// 
	MRCONFC_STREAM_RTPMULTICAST_T	stSlave;			// 
	MRCONFC_STREAM_RTPMULTICAST_T	stMobile;			// ֻ
}MRCONFC_RTPMULTICAST_T;

/* EPTZ Video Param */
typedef struct{
	BYTE					abMaster;					// ֧
	BYTE					abSlave;					// ֧
	BYTE					abPanMaster;				// ֧ȫ
	BYTE					abPanSlave;					// ֧ȫ
	int						nChannel;					// ͨ(ֻ)
	
	MRCONFC_VIDEOFORMAT_T	stMaster;					// 
	MRCONFC_VIDEOFORMAT_T	stSlave;					// 
	MRCONFC_VIDEOFORMAT_T	stPanMaster;				// ȫ
	MRCONFC_VIDEOFORMAT_T	stPanSlave;					// ȫ
}MRCONFC_EPTZ_VIDEOENCODE_CFG;

typedef struct{
	BYTE						abMaster;				// ֧
	BYTE						abSlave;				// ֧
	BYTE						abPanMaster;			// ֧ȫ
	BYTE						abPanSlave;				// ֧ȫ
	int							nChannel;				// ͨ(ֻ)

	MRCONFC_STREAM_PUBLISH_T	stMaster;				// 
	MRCONFC_STREAM_PUBLISH_T	stSlave;				// 
	MRCONFC_STREAM_PUBLISH_T	stPanMaster;			// ȫ
	MRCONFC_STREAM_PUBLISH_T	stPanSlave;				// ȫ
}MRCONFC_EPTZ_PUBLISH_T;

typedef struct{
	BYTE							abMaster;			// ֧
	BYTE							abSlave;			// ֧
	BYTE							abPanMaster;		// ֧ȫ
	BYTE							abPanSlave;			// ֧ȫ
	int								nChannel;			// ͨ(ֻ)

	MRCONFC_STREAM_RTPMULTICAST_T	stMaster;			// 
	MRCONFC_STREAM_RTPMULTICAST_T	stSlave;			// 
	MRCONFC_STREAM_RTPMULTICAST_T	stPanMaster;		// ȫ
	MRCONFC_STREAM_RTPMULTICAST_T	stPanSlave;			// ȫ
}MRCONFC_EPTZ_RTPMULTICAST_T;

// ̫
typedef struct{
	WORD				wPortWeb;							// Web˿, Ĭ80
	WORD				wPortRtsp;							// RTSP˿, Ĭ554
	WORD				wPortRtmp;							// RTMP˿, Ĭ1935
	WORD				wPortSoap;							// Soap˿, Ĭ1936
	WORD				wPortOnvif;							// Onvif˿, Ĭ2000
	WORD				wPortData;							// ݶ˿ڣĬ3000
	WORD				wPortVisca;							// Visca˿, Ĭ3001
	WORD				wPortSrt;							// SRT˿ڣĬ9000
}MRCONFC_NET_PORT_T;

typedef struct{
	// 
	BYTE				byValid;							// λʾ MR_ETHVALID_MASK
	BYTE				bDefault;							// ǷΪĬϵ 1Ĭ 0Ĭ
	char				szIPAddr[MR_SLEN_IPADDR];			// IP ַ
	char				szSubMask[MR_SLEN_IPADDR];			// IP ַ
	char				szGateway[MR_SLEN_IPADDR];			// صַ
	char				szMacAddr[MR_SLEN_MACADDR];			// MACַ
}MRCONFC_NET_ETH_T;

// 
typedef struct{
	BYTE				byValid;							// λʾ MR_ETHVALID_MASK
	char				szIPAddr[MR_SLEN_IPADDR];			// IP ַ
	char				szSubMask[MR_SLEN_IPADDR];			// IP ַ
	char				szGateway[MR_SLEN_IPADDR];			// صַ
	char				szMacAddr[MR_SLEN_MACADDR];			// MACַ(ֻ)
	char				szSSID[MR_SLEN_USERNAME];			// SSID
	char				szPsw[MR_SLEN_PASSWORD];			// 
	BYTE				bEncryption;						// 0 - δܣ1 - 
}MRCONFC_NET_WLAN_T;

// SoftAP
typedef struct{
	BYTE				byValid;							// 0-Disable, 1-Enable
	char				szSSID[MR_SLEN_USERNAME];			// SSID
	char				szPsw[MR_SLEN_PASSWORD];			// 
	BYTE				bFreqBand;						    // 0 - 2.4G1 - 5G
}MRCONFC_NET_SOFTAP_T;


typedef struct{
	char	address[128];		// ַ
	char	protocol[100];		// Э
	char	essid[128];			// essid
	char	mode[64];			// ģʽ
	double	frequency;			// Ƶ
	int		quality;			// źǿ, 0100
	BYTE	encryption_state;	// 0:OFF  1:ON
	double	bitrate;			// 
}MRCONFC_NET_WLAN_NOTE_T;

// DNS
typedef struct{
	char				szDns1[MR_SLEN_IPADDR];				// ѡDNS
	char				szDns2[MR_SLEN_IPADDR];				// ѡDNS
}MRCONFC_NET_DNS_T;

// 洢
typedef struct{
	int					nStoreStream;	// 洢( MRCONFC_VSTREAM_TYPE )
	int					nPackType;		// ļʽ, MR_PACKTYPE_TYPE
	int					nPacketTime;	// ʱ()
}MRCONFC_RECSTORE_CFG;

typedef struct{
	// ֻ֧֣
	BYTE				abNetPort;
	BYTE				abEth;
	BYTE				abWlan;
    BYTE				abSoftAP;
	BYTE				abDns;
	// 
	MRCONFC_NET_PORT_T	 stNetPort;
	MRCONFC_NET_ETH_T	 stEth[1];
	MRCONFC_NET_WLAN_T	 stWlan;
	MRCONFC_NET_SOFTAP_T stSoftAP;
	MRCONFC_NET_DNS_T	 stDns;
}MRCONFC_NET_CFG;

// ̨
typedef struct{
	BYTE		emLanguage;			// ˵, 0 - , 1 - Ӣ
	BYTE		emProtol;			// Э, 1 - Զ2 - PLC-D3 - PLC-P 4 - Visca
	BYTE		nViscaAddr;			// viscaַ(1 - 7)
	BYTE		nPlcDAddr;			// PLC-D ַ(0 - 255)
	BYTE		nPlcPAddr;			// PLC-P ַ(0 - 255)
	BYTE		nIRAddr;			// IRַ1 - 4;
	BYTE		emUartNetMode;		// ģʽ, 0 - , 1 - 
	BYTE		bLockAddr;			// ַ
	BYTE		bEnRS485;			// ʹRS485
	BYTE		nBaudRate;			// , 0 - 2400, 1- 4800, 2 - 9600, 3 - 115200
	BYTE		nUserCode;			// û, Ԥ޸
}MRCONFC_ARM_SYSTEM_T;

typedef struct{
	BYTE		emPwrUpMode;		// ϵģʽ, 0 - رգ1 - 1Ԥõ㣬2 - Ԥõ
	BYTE		bSpeedByZoom;		// , 1 , 0
	BYTE		nIRSpeed;			// ңٶ(5 - 16)
	BYTE		nZoomSpeed;			// 䱶ٶ(1 - 8)
	BYTE		nUartMinSpeed;		// Сٶ(1 - 24)
	BYTE		nTourSpeed;			// Ѳٶ(1 - 16)
	BYTE		bImageFreezing;		// ͼ񶳽
	BYTE		nPTZAccTable;		// 0 -  1 - 
}MRCONFC_ARM_PTZ_T;

// Զ۽
typedef struct{
	BYTE			emAFMode;		// Զ۽ģʽ(Auto : 0x02, Manual : 0x03, onepush : 0x04)
	BYTE			emAFZone;		// ۽(top : 0, center : 1, bottom : 2, ALL : 3)
	BYTE			nSensitivity;	// ۽(1 - 3, 1 - ߣ2 - 3 - )
}MRCONFC_CAM_AF_T;

// ع
typedef struct{
	int				nExpModeList;
	BYTE			byExpModeList[MRCONFC_NMAX_EXPMODE];
	BYTE			emExpMode;
}MRCONFC_CAM_EXPMODE_T;

// Ȧֵ(0 - 12, ֶȦʱЧ){"ر", "F11.0", "F9.6", "F8.0", "F6.8", "F5.6", "F4.8", "F4.0", "F3.4", "F2.8", "F2.4", "F2.0", "F1.8"}
typedef struct{
	int					nIrisList;
	MRCONFC_PARAMLIST_T stIrisList[MRCONFC_NMAX_IRIS];	
	int					nIris;
}MRCONFC_CAM_IRIS_T;

// (1 - 17, ֶʱЧ) { "1/30", "1/60", "1/90", "1/100", "1/125", "1/180", "1/250", "1/350", 
//	"1/500", "1/725", "1/1000", "1/1500", "1/2000", "1/3000", "1/4000", "1/6000", "1/10000"}
typedef struct{
	int					nShutterList;
	MRCONFC_PARAMLIST_T stShutterList[MRCONFC_NMAX_SHUTTER];
	int					nShutter;
}MRCONFC_CAM_SHUTTER_T;
typedef struct{
	//BYTE			emExpMode;		// عģʽ(MRCONFC_EXPMODE_TYPE)
	BYTE			bright;			// (0 - 23, ʱЧ)
	BYTE			expcomp_mode;	// عⲹ(0x02 -  0x03 -  ԶʱЧ)
	BYTE			expcomp;		// عⲹֵ(0 - 14, ԶʱЧ)
	BYTE			backlight;		// ⲹ(0x02 - 0x03 - , ԶʱЧ)
	BYTE			antiflicker;	// ˸(0 - رգ1 - 50Hz, 2 - 60Hz, ԶȦ, ʱЧ)
	BYTE			gainLimit;		// (0(С) - 15(), ԶȦ, )
	BYTE			drc;			// ̬Χ(0(ر) - 8())
	BYTE			aemode;			// Զعģʽ(0x02 - ţ0x03 - ̶֡ģʽ)
	MRCONFC_CAM_EXPMODE_T	stExpMode;		// عģʽ
	MRCONFC_CAM_IRIS_T		stIris;			// Ȧ
	MRCONFC_CAM_SHUTTER_T	stShutter;		// 
}MRCONFC_CAM_EXP_T;

typedef struct {
	int				nWbModeList;
	BYTE			byWbModeList[MRCONFC_NMAX_WBMODE];
	BYTE			emWbMode;
}MRCONFC_CAM_WBMODE_T;

typedef struct{
//	BYTE			emWbMode;		// ƽģʽ
	MRCONFC_CAM_WBMODE_T stWbMode;  // ƽģʽ
	BYTE			rg;				// (0 - 255, ֶЧ)
	BYTE			bg;				// (0 - 255, ֶЧ)
	BYTE			rgaintuning;	// ΢(0 - 20, ʾ-10 - 10, ԶЧ)
	BYTE			bgaintuning;	// ΢(0 - 20, ʾ-10 - 10, ԶЧ)

	BYTE			saturation;		// Ͷ(0 - 14){"60%", "70%", "80%", "90%", "100%", "110%", "120%", "130%", "140%", "150%", "160%", "170%", "180%", "190%", "200%"}
	BYTE			hue;			// ɫ(0 - 14)
	BYTE			irfilter;		// (1 - 3)
	BYTE			awbsens;		// Զƽ(0 - ߣ1 - У2 - )
	BYTE			nStyleInx;		// ɫ(0 - 2)
	BYTE			colortemp;		// ɫ, 0 - ɫ£1 - ɫ, 2 - ɫ
}MRCONFC_CAM_COLOR_T;

// Ƶ
typedef struct{
	int				nNetMode;								// 0 - ģʽ1 - +磬2 - +
	int				nFormatLists;							// byFormatList
	BYTE			byFormatList[MRCONFC_NMAX_VOFMT];		// ָ֧ʽб
	int             emVoutFormat;							// ʽ
	int				nVoutCamNo;								// ƵԴѡ(0-д          1-ȫ)			
}MRCONFC_VIDEOOUT_CFG;

typedef struct{
	MRCONFC_OSDCHNEXT_T	stTime;							// ʱ
	MRCONFC_OSDCHNEXT_T	stUser[MR_NMAX_OSDUSERS];		// Զ
}MRCONFC_VO_OSD_CFG;
typedef struct {
	MRCONFC_OSDCHNEXT_T	stUser;		// Զ
}MRCONFC_ARM_VO_OSD_CFG;
typedef struct{
	MR_COVER_T			stBlocks[MR_NMAX_COVERS];	// 
}MRCONFC_COVER_CFG;

// ͼ
typedef struct{
	BYTE			luminance;		// (0 - 14)
	BYTE			contrast;		// Աȶ(0 - 14)
	BYTE			sharpness;		// (0 - 16, 16 - Զ)
	BYTE			nBWMode;		// ڰģʽ(color : 0x00, b&w : 0x04)
	BYTE			gamma;			// Gamma(0 - 4 : 0 - Ĭ, 1 - 0.45, 2 - 0.5, 3 - 0.56, 4 - 0.63)
	BYTE			nFlipH;			// ˮƽת(ON : 0x02, OFF : 0x03)
	BYTE			nFlipV;			// ֱת(ON : 0x02, OFF : 0x03)
	BYTE			nEZoom;			// ӱ䱶, 0x02 - ON, 0x03 - Off
	BYTE			ldc;			// ͷ(0 - 8, 0 - ر)
	BYTE			dci;			// ̬Աȶ(0 - 8, 0 - ر)
	BYTE			wdr2frmae;		// ˫̬֡, 0x02 - ON, 0x03 - Off
}MRCONFC_CAM_IMAGE_T;

// 
typedef struct{
	BYTE			noise2D;		// 2D뼶(0 - 6, 0 - ر, (1 - 5 ֶ), 6 - Զ)
	BYTE			noise3D;		// 3D(0 - 8(), 0 - ر)
	BYTE			dhotpixel;		// ̬(0 - 5, 0 - ر)
}MRCONFC_CAM_NR_T;

// ɫ
typedef struct {
	BOOL		Enable;						// ǷʹҳϵCCM(1: ʹ, 0 : ʹ)
	WORD		HighCCM[MRCONFC_NMAX_CCM];	// ɫʱCCM
}MRCONFC_CAM_CCM_TYPE;


typedef struct{
	MRCONFC_CAM_AF_T		stAF;			// Զ۽
	MRCONFC_CAM_EXP_T		stExp;			// ع
	MRCONFC_CAM_COLOR_T		stColor;		// ɫ
	MRCONFC_CAM_IMAGE_T		stImg;			// ͼ
	MRCONFC_CAM_NR_T		stNR;			// 
	MRCONFC_CAM_CCM_TYPE	stCCM;			// ɫ
}MRCONFC_VIDEOPARAM_CFG;

// GB28181
typedef struct{
	BOOL 			bEnable;			// 1:GB28181 0:ر
	BOOL 			bTimeSyn;			// 1:ʱͬʼ 0:ر
	MRCONFC_VSTREAM_TYPE emVideoType;	// ѡ 0: 1:
	unsigned int  	nRegLimitedTime;	// עЧʱ >60s
	unsigned int  	nHeartbeatTime;		// ʱ
	char 			szRegisterId[MR_SLEN_GB28181ID];		// עID
	char 		 	szRegisterName[MR_SLEN_DEVNAME];		// עû
	char 		 	szRegisterPassword[MR_SLEN_PASSWORD];	// ע
	char 		 	szMotionAlarmId[MR_SLEN_GB28181ID];		// ƶ澯ID

	char 		 	szProbeAlarmId1[MR_SLEN_GB28181ID];		// ̽ͷ澯ID1
	char 		 	szEquipmentBelong[MR_SLEN_GB28181AREA];	// 豸
	char 		 	szAdminiAreas[MR_SLEN_GB28181AREA];		// 
	char 		 	szAlarmAreas[MR_SLEN_GB28181AREA];		// 
	char 		 	szDeviceAddress[MR_SLEN_GB28181ADDR];	// 豸װַ

	WORD			wLocalPort;							// SIP˿
	char 		 	szServer1Ip[MR_SLEN_IPADDR]; 		// GB28181ַ1
	WORD 		 	wServer1Port;						// SIP˿1
	char 		 	szServer1Id[MR_SLEN_GB28181ID];		// ID
}MRCONFC_GB28181_CFG;

typedef struct{
	BOOL 			bEnable;				// 1:ONVIF 0:ر

}MRCONFC_ONVIF_CFG;


// ƽ̨
typedef struct{
	BOOL				abOnvif;	// ONVIFЭԽ 1:ʵ 0:δʵ
	BOOL				abGB28181;	// GB28181ЭԽ 1:ʵ 0:δʵ

	MRCONFC_ONVIF_CFG     	stOnvif;  	// ONVIFԽӲ
	MRCONFC_GB28181_CFG     stGB28181;  // GB28181ԽӲ
	
}MRCONFC_PLATFORM_CONNECT_CFG;

typedef struct{
	unsigned short  nCodec;
	unsigned short  wFrameRate;
	unsigned short  wWdith;
	unsigned short  wHeight;
}MRCONFC_UT10UDP_VIDEO_T;
typedef struct{
	unsigned int    nCodec : 16;
	unsigned int    nSampeBits : 10;
	unsigned int    nChannels  : 6;
	unsigned int    nSampleRate;
}MRCONFC_UT10UDP_AUDIO_T;
typedef struct{
	unsigned int	nID;				// 0XB2010000
	unsigned int	nTimeTick;			// ʱ, ms, Բ0ʼ밴
	int				nFrameSize : 28;	// ǰ֡
	int				frame_type : 4;		// MR_FRAME_TYPE
    union
    {
        MRCONFC_UT10UDP_VIDEO_T stVideo;
        MRCONFC_UT10UDP_AUDIO_T stAudio;
    };
}MRCONFC_UT10UDP_HEAD_T;

// ģʽ
typedef struct {
	BYTE			Power;		// ģʽ(On : 0x03, Off : 0x02)
	BYTE			ArmPower;	// armģʽ(On : 0x03, Off : 0x02)
}MRCONFC_CAM_POWER_T;

typedef struct{
	int nCropX;
	int nCropY;
	int nCropW;
	int nCropH;
	BOOL bZoomIn;
	BOOL bZoomState;
}MRZOOMIN_CROP_T;

#endif//__MR_CONFCAM_ENV_H__
