//MRComm.h
#ifndef __MRCOMM_H__
#define __MRCOMM_H__

#if defined(WIN32)
#include <windows.h>
#ifndef UINT64
#define UINT64	unsigned __int64
#if !defined(int64_t)
#	define int64_t	__int64
#   define uint64_t	unsigned __int64
#endif//int64_t
#endif//LONG

#define uint8_t		unsigned char
#define int8_t		char
#define uint16_t	unsigned short
#define int16_t		short
#define uint32_t	unsigned int
#define int32_t		int

#if defined(WIN64)
#ifndef LONG
#define LONG	long long
#endif//LONG
#endif

#else
#ifndef WORD
#define WORD	unsigned short
#endif//WORD

#ifndef USHORT
#define USHORT	unsigned short
#endif//USHORT

#ifndef DWORD
#define DWORD	unsigned long
#endif//DWORD

#ifndef BOOL
#define BOOL	int
#endif//BOOL

#ifndef TRUE
#define TRUE	1
#endif//TRUE

#ifndef FALSE
#define FALSE	0
#endif//FALSE

#ifndef BYTE
#define BYTE	unsigned char
#endif//BYTE

#ifndef LONG
#define LONG	long
#endif//LONG

#ifndef UINT64
#define UINT64	uint64_t//unsigned long long
#endif//LONG

#ifndef LPVOID
#define LPVOID	void*
#endif//LPVOID

#ifndef LPDWORD
#define LPDWORD	DWORD*
#endif//LPDWORD

#endif//WIN32

#define MRPARAM_IN		// 
#define MRPARAM_OUT		// 
#define MRPARAM_IO		// /

#define MR_SLEN_DEVNAME				64			// 豸ַ
#define MR_SLEN_URLADDR				64			// URLַ
#define MR_SLEN_USERNAME			64			// û󳤶
#define MR_SLEN_PASSWORD			64			// 󳤶
#define MR_SLEN_OSDSTRING			255			// OSDַ
#define MR_SLEN_MACADDR				32			// MACַ
#define MR_SLEN_IPADDR				32			// IPַַ
#define MR_SLEN_MAILTITLE			256			// ʼ
#define MR_SLEN_DIRECTORY			256			// ·󳤶
#define MR_SLEN_SERIALNO			32			// 豸кų
#define MR_SLEN_DEVICEID			32			// 豸ID
#define MR_SLEN_GB28181ID			30			// GB28181 ID
#define MR_SLEN_GB28181AREA			50			// GB28181 豸ַ
#define MR_SLEN_GB28181ADDR			100			// GB28181 豸װַ
#define MR_SLEN_STREAMNAME			2048		// Ƴ

#define MR_NMAX_OSDUSERS			4			// ԶOSD
#define MR_NMAX_COVERS				4			// ڵ
#define MR_NAMX_VFORMATS			8			// Ƶʽ֧
#define MR_NMAX_SHUTTERS			32			// 
#define MR_NMAX_DDNSPROVIDER		16			// ֵ֧DDNS
#define MR_NAMX_PTZCRUISE_POINTS	32			// ԤõѲԤõ
#define MR_NAMX_PTZCRUISE_NUM		8			// ԤõѲ
#define MR_NMAX_WEEKDAYS			7			// һܵ
#define MR_NMAX_TIMESECT			32			// ÿʱθ
#define MR_NMAX_IRIS				15			// Ȧ
#define MR_NMAX_AEMODE				12			// AEģʽ
#define MR_NMAX_WBMODE				6			// ƽģʽ
#define MR_NMAX_FOUCEMODE			5			// ۽ģʽ
#define MR_NMAX_HDDS				8			// Ӳ

//---------ONVIF ---------------------------------------------------
#define MAX_ONVIF_PROFILES_NUM		4			// ֵ֧PROFILESĸ
#define MAX_ONVIF_NAME_LEN		    64			// ֵ֧ONVIF PROFILEֳ
#define MAX_ONVIF_TOKENLEN			64			// 
#define MAX_ONVIF_ADDRESS_LEN		100			// ַ
#define MAX_ONVIF_SPACE_LEN		    100			// ռ䳤
#define MAX_ONVIF_RELAY_NUM		    3			// ֵ֧RELAYĸ
//------------------------------------------------------------------

// ̨
#define MR_PTZCMD_LEFT_START		"left_start"			// 
#define MR_PTZCMD_LEFT_STOP			"left_stop"				// ֹͣ
#define MR_PTZCMD_LEFTUP_START		"leftup_start"			// 
#define MR_PTZCMD_LEFTUP_STOP		"leftup_stop"			// ֹͣ
#define MR_PTZCMD_LEFTDOWN_START	"leftdown_start"		// 
#define MR_PTZCMD_LEFTDOWN_STOP		"leftdown_stop"			// ֹͣ
#define MR_PTZCMD_RIGHT_START		"right_start"			// 
#define MR_PTZCMD_RIGHT_STOP		"right_stop"			// ֹͣ
#define MR_PTZCMD_RIGHTUP_START		"rightup_start"			// 
#define MR_PTZCMD_RIGHTUP_STOP		"rightup_stop"			// ֹͣ
#define MR_PTZCMD_RIGHTDOWN_START	"rightdown_start"		// 
#define MR_PTZCMD_RIGHTDOWN_STOP	"rightdown_stop"		// ֹͣ
#define MR_PTZCMD_UP_START			"up_start"				// 
#define MR_PTZCMD_UP_STOP			"up_stop"				// ֹͣ
#define MR_PTZCMD_DOWN_START		"down_start"			// 
#define MR_PTZCMD_DOWN_STOP			"down_stop"				// ֹͣ
#define MR_PTZCMD_IRIS_ADD_START	"irisadd_start"			// Ȧ+
#define MR_PTZCMD_IRIS_ADD_STOP		"irisadd_stop"			// Ȧ+ֹͣ
#define MR_PTZCMD_IRIS_DEC_START	"irisdec_start"			// Ȧ-
#define MR_PTZCMD_IRIS_DEC_STOP		"irisdec_stop"			// Ȧ-ֹͣ
#define MR_PTZCMD_FOCUS_ADD_START	"focusadd_start"		// ۽+
#define MR_PTZCMD_FOCUS_ADD_STOP	"focusadd_stop"			// ۽+ֹͣ
#define MR_PTZCMD_FOCUS_DEC_START	"focusdec_start"		// ۽-
#define MR_PTZCMD_FOCUS_DEC_STOP	"focusdec_stop"			// ۽-ֹͣ
#define MR_PTZCMD_ZOOM_ADD_START	"zoomadd_start"			// 䱶+
#define MR_PTZCMD_ZOOM_ADD_STOP		"zoomadd_stop"			// 䱶+ֹͣ
#define MR_PTZCMD_ZOOM_DEC_START	"zoomdec_start"			// 䱶-
#define MR_PTZCMD_ZOOM_DEC_STOP		"zoomdec_stop"			// 䱶-ֹͣ
#define MR_PTZCMD_PRESET_SET		"preset_set"			// Ԥõ
#define MR_PTZCMD_PRESET_CALL		"preset_call"			// Ԥõ
#define MR_PTZCMD_PRESET_CLEAN		"preset_clean"			// Ԥõ
#define MR_PTZCMD_LIGHT_ON			"light_on"				// 򿪵ƹ
#define MR_PTZCMD_LIGHT_OFF			"light_off"				// رյƹ
#define MR_PTZCMD_LIGHT_AUTO		"light_auto"			// ƹԶ
#define MR_PTZCMD_RAINO_ON			"raino_on"				// 
#define MR_PTZCMD_RAINO_OFF			"raino_off"				// ر
#define MR_PTZCMD_AUX_ON			"aux_on"				// 򿪸
#define MR_PTZCMD_AUX_OFF			"aux_off"				// رո
#define MR_PTZCMD_MENU_OPEN			"menu_open"				// 򿪲˵
#define MR_PTZCMD_MENU_CLOSE		"menu_close"			// رղ˵
#define MR_PTZCMD_MENU_OK			"menu_ok"				// ˵ȷ
#define MR_PTZCMD_MENU_CANCEL		"menu_cancel"			// ˵ȡ
#define MR_PTZCMD_MENU_UP			"menu_up"				// ˵
#define MR_PTZCMD_MENU_DOWN			"menu_down"				// ˵
#define MR_PTZCMD_MENU_LEFT			"menu_left"				// ˵
#define MR_PTZCMD_MENU_RIGHT		"menu_right"			// ˵
#define MR_PTZCMD_PATERN_CFG_START	"patern_cfg_start"		// ɨÿʼ
#define MR_PTZCMD_PATERN_CFG_STOP	"patern_cfg_stop"		// ɨֹͣ
#define MR_PTZCMD_PATERN_CFG_CLEAN	"patern_cfg_clean"		// ɨ
#define MR_PTZCMD_PATERN_START		"patern_start"			// ʼɨ
#define MR_PTZCMD_PATERN_STOP		"patern_stop"			// ֹͣɨ
#define MR_PTZCMD_AUTOSCAN_START	"autoscan_start"		// Զɨ
#define MR_PTZCMD_AUTOSCAN_STOP		"autoscan_stop"			// ֹͣԶɨ
#define MR_PTZCMD_PTSCAN_START		"ptscan_start"			// ƻɨ
#define MR_PTZCMD_PTSCAN_STOP		"ptscan_stop"			// ֹͣƻɨ
#define MR_PTZCMD_SCAN_SPEED_PAN	"scan_speed_pan"		// ɨˮƽٶ
#define MR_PTZCMD_SCAN_SPEED_TILT	"scan_speed_tilt"		// ɨ费ֱٶ
#define MR_PTZCMD_3DLOCATE			"3dlocate"				// 3Dλ
#define MR_PTZCMD_PARK_SET			"park_set"				// ÿλ
#define MR_PTZCMD_PARK_EN			"park_en"				// ʹܿλ
#define MR_PTZCMD_VIRTULZERO_SET	"virtualzero_set"		// λ
#define MR_PTZCMD_VIRTULZERO_CLEAN	"virtualzero_clean"		// λ
#define MR_PTZCMD_PRESETTOUR_SET	"presettour_set"		// ԤλѲ
#define MR_PTZCMD_PRESETTOUR_CLEAN	"presettour_clean"		// ԤλѲ
#define MR_PTZCMD_PRESETTOUR_START	"presettour_start"		// ԤλѲ
#define MR_PTZCMD_PRESETTOUR_STOP	"presettour_stop"		// ֹͣԤλѲ
#define MR_PTZCMD_POSI_DETECT		"posi_dectet"			// λԼ
#define MR_PTZCMD_LEFTLIMIT_SET		"leftlimit_set"			// λ
#define MR_PTZCMD_LEFTLIMIT_CLEAN	"leftlimit_clean"		// λ
#define MR_PTZCMD_RIGHTLIMIT_SET	"rightlimit_set"		// λ
#define MR_PTZCMD_RIGHTLIMIT_CLEAN	"rightlimit_clean"		// λ
#define MR_PTZCMD_UPLIMIT_SET		"uplimit_set"			// λ
#define MR_PTZCMD_UPLIMIT_CLEAN		"uplimit_clean"			// λ
#define MR_PTZCMD_DOWNLIMIT_SET		"downlimit_set"			// λ
#define MR_PTZCMD_DOWNLIMIT_CLEAN	"downlimit_clean"		// λ
#define MR_PTZCMD_LIMITMANUAL_EN	"limitmanual_en"		// ֶλʹ
#define MR_PTZCMD_LIMITSCAN_EN		"limitscan_en"			// Զλʹ
#define MR_PTZCMD_PROPORTION_EN		"proportion_en"			// ʹ
#define MR_PTZCMD_PT_RESET			"pt_reset"				// ̨λ
#define MR_PTZCMD_PWRUP_ACTION		"pwrup_action"			// ϵ綯
#define MR_PTZCMD_PWRUP_EN			"pwrup_en"				// ϵ綯ʹ
#define MR_PTZCMD_ADDR_SET			"addr_set"				// ַ̨
#define MR_PTZCMD_AUTOFLIP_EN		"autoflip_en"			// Զתʹ
#define MR_PTZCMD_PTZPOS_DIRECT		"ptzpos_direct"			// ֱλÿ
#define MR_PTZCMD_QUERY_POS			"query_pos"				// ѯǰλ
#define MR_PTZCMD_QUERY_TYPE		"query_type"			// ѯPTZͺ
#define MR_PTZCMD_QUERY_VERSION		"query_version"			// ѯPTZ汾
#define MR_PTZCMD_CALL_POWEROFF		"call_poweroff"			// ģʽ
#define MR_PTZCMD_GO_HOME		    "go_home"			    //  Home λ
#define MR_PTZCMD_AFMODE			"af_mode"				// ۽ģʽ
#define MR_PTZCMD_ABSOLUTE_MOVE     "absolute_move"         //ƶ̨λ
#define MR_PTZCMD_MOVE_ZOOM         "move_zoom"             //Ժƶ۽
#define MR_PTZCMD_RELATIVE_MOVE     "relative_move"         //ڵǰλƶ
#if defined(PRESET_CRUISE)
#define MR_PTZCMD_CRUISE_TIME        "cruise_time"         //ԤλѲʱ
#endif


// ƵƵʡ, 16λΪƵʣ16λΪ
typedef enum{
	MRAUDIO_SMST_8K  = 0x00000001,		// 8000
	MRAUDIO_SMST_11K = 0x00000002,		// 11025
	MRAUDIO_SMST_12K = 0x00000004,		// 12000
	MRAUDIO_SMST_16K = 0x00000008,		// 16000
	MRAUDIO_SMST_22K = 0x00000010,		// 22050
	MRAUDIO_SMST_24K = 0x00000020,		// 24000
	MRAUDIO_SMST_32K = 0x00000040,		// 32000
	MRAUDIO_SMST_44K = 0x00000080,		// 44100
	MRAUDIO_SMST_48K = 0x00000100,		// 48000
	MRAUDIO_SMST_96K = 0x00000200,		// 96000
	
	MRAUDIO_BTST_8   = 0x01000000,		// 8 bits
	MRAUDIO_BTST_16  = 0x02000000,		// 16 bits
	MRAUDIO_BTST_24  = 0x04000000,		// 24 bits
	MRAUDIO_BTST_32  = 0x08000000,		// 32 bits
}MRAUDIO_SMST_MASK;

// Ƶʽ֧
typedef enum{
	MRACODEC_ST_PCM	  = 0x00000001,		// PCM
	MRACODEC_ST_G711A = 0x00000002,		// G711A
	MRACODEC_ST_G711U = 0x00000004,		// G722U
	MRACODEC_ST_G722  = 0x00000008,		// G722
	MRACODEC_ST_G726  = 0x00000010,		// G726
	MRACODEC_ST_MP3   = 0x00000020,		// MP3
	MRACODEC_ST_AAC   = 0x00000040,		// AAC
}MRACODEC_ST_MASK;

// Ч
typedef enum{
	MR_ETHVALID_ENABLE	= 0X01,		//	ʼ
	MR_ETHVALID_DHCP    = 0X02,		//	DHCP
	MR_ETHVALID_ENDHCP  = 0X04,		//	DHCP֧
}MR_ETHVALID_MASK;

// APƵ
typedef enum{
	MR_SOFTAP_2_4G	= 0X00,		//	ʼ
	MR_SOFTAP_5G    = 0X01,		//	DHCP

}MR_AP_BAND_MASK;

// ¼
typedef enum{
	MR_RECORDTYPE_MANUAL	= 0X01,		// ֶ¼
	MR_RECORDTYPE_TIMER		= 0X02,		// ʱ
	MR_RECORDTYPE_ALARM		= 0X04,		// 
	MR_RECORDTYPE_MOTION	= 0X08,		// ƶ
}MR_RECORDTYPE_MASK;

// ļ״̬־
typedef enum{
	MR_RECFILESTATUS_LOCKED = 0X01,	// ļ
	MR_RECFILESTATUS_WRITE  = 0X02,	// д
}MR_RECFILESTATUS_MASK;

// 
typedef enum{
	MR_LANGUAGE_CHINESE_SIMPLIFIED = 0,			// 
	MR_LANGUAGE_CHINESE_TRADITIONAL,			// 
	MR_LANGUAGE_ENGLISH,						// Ӣ
	MR_LANGUAGE_RUSSIAN,						// 
	MR_LANGUAGE_ARABIC,							// 
	MR_LANGUAGE_PORTUGUESE,						// 
	MR_LANGUAGE_SPANISH,						// 
	MR_LANGUAGE_TURKEY,							// 
	MR_LANGUAGE_JAPANESE,						// 
	MR_LANGUAGE_KOREAN,							// 
	MR_LANGUAGE_ITALIAN,						// 
	MR_LANGUAGE_FRENCH,							// 
	MR_LANGUAGE_GERMAN, 						// 
	MR_LANGUAGE_POLISH,							// 	
	MR_LANGUAGE_ROMANIAN,						// 	
	MR_LANGUAGE_HUNGARIAN,						// 
	MR_LANGUAGE_FINNISH,						// 	
	MR_LANGUAGE_ESTONIAN,						// ɳ	
	MR_LANGUAGE_FARSI,							// ˹ 	
	MR_LANGUAGE_DANSK,							// 
	MR_LANGUAGE_CZECHISH,						// ݿ
	MR_LANGUAGE_BULGARIA,						// 
	MR_LANGUAGE_SLOVAKIAN,						// ˹工
	MR_LANGUAGE_SLOVENIA,						// ˹
	MR_LANGUAGE_CROATIAN,						// ޵
	MR_LANGUAGE_DUTCH,							// 
	MR_LANGUAGE_GREEK,							// ϣ
	MR_LANGUAGE_UKRAINIAN,						// ڿ
	MR_LANGUAGE_SWEDISH,						// 
	MR_LANGUAGE_SERBIAN,						// ά
	MR_LANGUAGE_VIETNAMESE,						// Խ
	MR_LANGUAGE_LITHUANIAN,						// 
	MR_LANGUAGE_FILIPINO,						// ɱ
	MR_LANGUAGE_CATALAN,						// ̩
	MR_LANGUAGE_LATVIAN,						// ά
}MR_LANGUAGE_TYPE;

// ͼߴС
typedef enum{
	MR_VIDEOSIZE_QCIF = 0,					// 176*144(PAL)  176*120(NTSC)
	MR_VIDEOSIZE_CIF,						// 352*288(PAL)  352*240(NTSC)
	MR_VIDEOSIZE_2CIF,						// 704*288(PAL)  704*240(NTSC)
	MR_VIDEOSIZE_4CIF,						// 704*576(PAL)  704*480(NTSC)
	MR_VIDEOSIZE_720,						// 1280*720
	MR_VIDEOSIZE_1080,						// 1920*1080
	MR_VIDEOSIZE_QQVGA,						// 160*128
	MR_VIDEOSIZE_QVGA,						// 320*240
	MR_VIDEOSIZE_SVCD,						// 480*480
	MR_VIDEOSIZE_VGA,						// 640*480
	MR_VIDEOSIZE_SVGA,						// 800*600
	MR_VIDEOSIZE_XVGA,						// 1024*768
	MR_VIDEOSIZE_WXGA,						// 1280*800
	MR_VIDEOSIZE_SXGA,						// 1280*1024
	MR_VIDEOSIZE_WSXGA,						// 1600*1024
	MR_VIDEOSIZE_UXGA,						// 1600*1200
	MR_VIDEOSIZE_WUXGA,						// 1920*1200
	MR_VIDEOSIZE_1280_960,					// 1280*960  1.3M
	MR_VIDEOSIZE_1872_1408,					// 1872*1408 2M
	MR_VIDEOSIZE_2048_1536,					// 2048*1536 3M
	MR_VIDEOSIZE_2560_1600,					// 2560*1600 4M
	MR_VIDEOSIZE_3744_1408,					// 3744*1408 5M
	MR_VIDEOSIZE_3296_2472,					// 3296*2472 8M
	MR_VIDEOSIZE_1440_900,
	MR_VIDEOSIZE_1366_768,
	MR_VIDEOSIZE_960H,						// 960*576 960*480
	MR_VIDEOSIZE_640_360,
	MR_VIDEOSIZE_320_180,
	MR_VIDEOSIZE_960_540,
	MR_VIDEOSIZE_1920_1440,
	MR_VIDEOSIZE_2560_1440,
	MR_VIDEOSIZE_2304x1296,					// 3M: 2304 * 1296
    MR_VIDEOSIZE_2592x1520,					// 4M: 2592 * 1520
    MR_VIDEOSIZE_2592x1944,					// 5M: 2592 * 1944
	MR_VIDEOSIZE_UHD4K,						// 3840 * 2160
	MR_VIDEOSIZE_NUMS,
}MR_VIDEOSIZE_TYPE;

typedef enum{
    MR_VO_OUTPUT_PAL = 0,
	MR_VO_OUTPUT_NTSC,
		
	MR_VO_OUTPUT_1080P24,
	MR_VO_OUTPUT_1080P25,
	MR_VO_OUTPUT_1080P30,
	MR_VO_OUTPUT_720P50, 
	MR_VO_OUTPUT_720P60,   
	MR_VO_OUTPUT_1080I50,
	MR_VO_OUTPUT_1080I60,    
	MR_VO_OUTPUT_1080P50,
	MR_VO_OUTPUT_1080P60,    //10        

	MR_VO_OUTPUT_576P50,
	MR_VO_OUTPUT_480P60,

	MR_VO_OUTPUT_800x600_60,            /* VESA 800 x 600 at 60 Hz (non-interlaced) */
	MR_VO_OUTPUT_1024x768_60,           /* VESA 1024 x 768 at 60 Hz (non-interlaced) */
	MR_VO_OUTPUT_1280x1024_60,   //F       /* VESA 1280 x 1024 at 60 Hz (non-interlaced) */
	MR_VO_OUTPUT_1366x768_60,           /* VESA 1366 x 768 at 60 Hz (non-interlaced) */
	MR_VO_OUTPUT_1440x900_60,           /* VESA 1440 x 900 at 60 Hz (non-interlaced) CVT Compliant */
	MR_VO_OUTPUT_1280x800_60,           /* 1280*800@60Hz VGA@60Hz*/
	MR_VO_OUTPUT_640x480_60,			/* VESA 640 x 480 at 60 Hz (non-interlaced) CVT */

	MR_VO_OUTPUT_1080P59,				// 1080P59.94
	MR_VO_OUTPUT_1080I59,				// 1080I59.94
	MR_VO_OUTPUT_1080P29,				// 1080P29.97	
	MR_VO_OUTPUT_720P59,				// 720P59.94
	MR_VO_OUTPUT_720P29,				// 720O29.97
	MR_VO_OUTPUT_720P25,
	MR_VO_OUTPUT_720P30,
	MR_VO_OUTPUT_720P15,				// 1280 x 720 @ 15
	MR_VO_OUTPUT_720P10,				// 1280 x 720 @ 10
	MR_VO_OUTPUT_960x540P30,			// 960 x 540 @ 30
	MR_VO_OUTPUT_640x360P30,			// 640 x 360 @ 30
	MR_VO_OUTPUT_640x480P30,			// 640 x 480 @ 30
	MR_VO_OUTPUT_352x288P30,			// 352 x 288 @ 30
	MR_VO_OUTPUT_800x600P30,			// 800 x 600 @ 30
	MR_VO_OUTPUT_1080P15,               // 1080P15
	MR_VO_OUTPUT_1024X576P30,           // 1024X576P30
	MR_VO_OUTPUT_768X448P30,            // 768X448P30
	MR_VO_OUTPUT_512X288P30,            // 512X288P30
	MR_VO_OUTPUT_336X192P30,            // 336X192P30
	MR_VO_OUTPUT_704X576P30,				//704X576P30
	MR_VO_OUTPUT_1024X576P15,           // 1024X576P15
	MR_VO_OUTPUT_768X448P15,            // 768X448P15
	MR_VO_OUTPUT_512X288P15,            // 512X288P15
	MR_VO_OUTPUT_336X192P15,            // 336X192P15
	MR_VO_OUTPUT_320X240P30,
	MR_VO_OUTPUT_176X144P30,
	MR_VO_OUTPUT_160X120P30,
	MR_VO_OUTPUT_3840X2160P30,          //4KP30
	MR_VO_OUTPUT_3840X2160P25,          //4kp25
}MR_VOOUTPUT_SYNC_TYPE;

// ֡
typedef enum{
	MR_VIDEOFILED_I = 0,	// 
	MR_VIDEOFILED_P,		// 
}MR_VIDEOFILED_TYPE;

// 
typedef enum{
	MR_BITRATE_CBR = 0,			//	
	MR_BITRATE_VBR = 1,			//	
}MR_BITRATE_TYPE;

enum AVMediaType{
    AVMEDIA_TYPE_UNKNOWN = 0,  ///< Usually treated as AVMEDIA_TYPE_DATA
	AVMEDIA_TYPE_VIDEO,
	AVMEDIA_TYPE_AUDIO,
	AVMEDIA_TYPE_DATA,          ///< Opaque data information usually continuous
	AVMEDIA_TYPE_SUBTITLE,
    AVMEDIA_TYPE_ATTACHMENT,    ///< Opaque data information usually sparse
	AVMEDIA_TYPE_NB
};

// Ƶ
typedef enum{
	MR_VCODEC_JPEG	= 0,
	MR_VCODEC_MJPEG,
	MR_VCODEC_MPEG1,
	MR_VCODEC_MPEG2,
	MR_VCODEC_MPEG4,
	MR_VCODEC_H264,
	MR_VCODEC_H263,
	MR_VCODEC_H265,
	MR_VCODEC_NUMS,
}MR_VIDEOCODEC_TYPE;

// Ƶ
typedef enum{
	MR_ACODEC_PCM	= 0,		// PCM
	MR_ACODEC_ADPCM,			// ADPCM
	MR_ACODEC_G711A,			// G711A
	MR_ACODEC_G711U,			// G722U
	MR_ACODEC_G722,				// G722
	MR_ACODEC_G726,				// G726
	MR_ACODEC_MP3,				// MP3
	MR_ACODEC_AAC,				// AAC
	MR_ACODEC_AMR,
	MR_ACODEC_AMR_WB,
	MR_ACODEC_G723,
	MR_ACODEC_G729,
	MR_ACODEC_NUMS,
}MR_AUDIOCODEC_TYPE;

// ֡
typedef enum{
	MR_FRAMETYPE_VIDEO_P = 0,  // Ƶ,p֡
	MR_FRAMETYPE_VIDEO_B = 1,  // Ƶ,b֡
	MR_FRAMETYPE_VIDEO_I = 2,  // Ƶ,i֡
	MR_FRAMETYPE_AUDIO   = 3,  // Ƶ
	MR_FRAMETYPE_DATA    = 4,
	MR_FRAMETYPE_HEAD	 = 10, // ͷϢ
}MR_FRAME_TYPE;

typedef enum{
	MR_VENC_PROFILE_BP = 0,		// base line
	MR_VENC_PROFILE_MP,			// main profile
	MR_VENC_PROFILE_HP,			// high profile
}MR_VENC_PROFILE_TYPE;

// ļʽ
typedef enum{
	MR_PACKTYPE_MINR = 0,	// ˽ļʽ
	MR_PACKTYPE_FLV,		// FLVļʽ
	MR_PACKTYPE_TS,			// TSļʽ
	MR_PACKTYPE_AVI,		// AVIļʽ
	MR_PACKTYPE_ASF,		// ASFļʽ
	MR_PACKTYPE_MP4,		// MP4ļʽ
	MR_PACKTYPE_HDAV,		// HDAVļʽ
}MR_PACKTYPE_TYPE;

// ļ
typedef enum{
	MR_FILETYPE_VIDEO = 0,		// Ƶ
	MR_FILETYPE_JPEG,			// JPEGͼƬ
}MR_FILETYPE_TYPE;

// Ƶ
typedef enum{
	MR_VIDEOIO_CVBS = 0,
	MR_VIDEOIO_VGA,
	MR_VIDEOIO_YPBPR,
	MR_VIDEOIO_HDMI,
	MR_VIDEOIO_HDSDI,
	MR_VIDEOIO_AUTO,		// Զ
	MR_VIDEOIO_DVI,
	MR_VIDEOIO_NUMS,
}MR_VIDEOIO_TYPE;


// ƽģʽ
typedef enum{
	MR_WHITEBALANCE_AUTO = 0,		//Զ
	MR_WHITEBALANCE_MANUAL,			//ֶ
	MR_WHITEBALANCE_INDOOR,			//
	MR_WHITEBALANCE_OUTDOOR,		//
	MR_WHITEBALANCE_OUTDOORAUTO,	//Զ
	MR_WHITEBALANCE_ONEPUSH,		//һƽģʽ
	MR_WHITEBALANCE_AUTOTRACK,		//Զģʽ
	MR_WHITEBALANCE_SUNNY,			//ģʽ
	MR_WHITEBALANCE_CLOUDY,			//ģʽ
	MR_WHITEBALANCE_GLITTER,		//ģʽ
	MR_WHITEBALANCE_FLUORE,			//ģʽ
	MR_WHITEBALANCE_FLUOREH,		//⣨Hģʽ
	MR_WHITEBALANCE_UNDERWATER,		//ˮģʽ
	MR_WHITEBALANCE_FLUOREAUTO,		//Զģʽ
	MR_WHITEBALANCE_SODIUMLAMPSAUTO,//ƵƹԶģʽ
	MR_WHITEBALANCE_SODIUMLAMPS,	//Ƶģʽ
	MR_WHITEBALANCE_LIGHT,			//׳ģʽ
	MR_WHITEBALANCE_D4000K,			//D4000K
	MR_WHITEBALANCE_D5000K,			//D5000K
	MR_WHITEBALANCE_CUSTOM,			//Զģʽ

}MR_VIDEOWHITEBALANCE_TYPE;


//۽ģʽ
typedef enum{
	MR_FOUCEMODE_AUTO = 0,		// Զ
	MR_FOUCEMODE_MANUAL,    	// ֶ
	MR_FOUCEMODE_PUSHTRIGGER, 	// ۽ģʽ
	MR_FOUCEMODE_INFINITY,   	// ۽ģʽ
	MR_FOUCEMODE_NEARLIMIT,  	// ۽ģʽ
}MR_VIDEOFOUCEMODE_TYPE;


//Զعģʽ
typedef enum{
	MR_AEMODE_AUTO = 0,		// Զ
	MR_AEMODE_AUTO_AER1,    // Զ+ת+/AER1
	MR_AEMODE_AUTO_AER2,    // Զ+ת+/AER2
	MR_AEMODE_AUTO_AEDDS,   // Զ+ع/(AE+DSS)
	MR_AEMODE_AUTO_AE1DDS,  // Զ+ع+ת+/((AER+1) + DSS)
	MR_AEMODE_AUTO_AE2DDS,  // Զ+ع+ת+/((AER+2) + DSS)
	MR_AEMODE_AUTO_AE3DDS,  // Զ+ع+ת+/((AER+3) + DSS)
	MR_AEMODE_SHUTPRIO,		// 
	MR_AEMODE_IRISPRIO,		// Ȧ
	MR_AEMODE_AGCPRIO,		// 
	MR_AEMODE_BRIGHTPRIO,	// 
	MR_AEMODE_MANUAL,		// ֶ

}MR_VIDEOAEMODE_TYPE;

//ٶ
typedef enum{
	MR_SHUTTERTIME_AUTO = 0,	// Զ
	MR_SHUTTERTIME_2 = 1,		// 2
	MR_SHUTTERTIME_1_1	,		// 1/1
	MR_SHUTTERTIME_1_2,			// 1/2
	MR_SHUTTERTIME_1_3,			// 1/3
	MR_SHUTTERTIME_1_3_125,		// 1/3.125
	MR_SHUTTERTIME_1_4,			// 1/4
	MR_SHUTTERTIME_1_5,			// 1/5
	MR_SHUTTERTIME_1_6,			// 1/6
	MR_SHUTTERTIME_1_6_25,		// 1/6.25
	MR_SHUTTERTIME_1_7_5,		// 1/7.5
	MR_SHUTTERTIME_1_8,			// 1/8
	MR_SHUTTERTIME_1_10,		// 1/10
	MR_SHUTTERTIME_1_12_5,		// 1/12.5
	MR_SHUTTERTIME_1_15,		// 1/15
	MR_SHUTTERTIME_1_20,		// 1/20
	MR_SHUTTERTIME_1_24,		// 1/24
	MR_SHUTTERTIME_1_25,		// 1/25
	MR_SHUTTERTIME_1_30,		// 1/30
	MR_SHUTTERTIME_1_50,		// 1/50
	MR_SHUTTERTIME_1_60,		// 1/60
	MR_SHUTTERTIME_1_75,		// 1/75
	MR_SHUTTERTIME_1_90,		// 1/90
	MR_SHUTTERTIME_1_100,		// 1/100
	MR_SHUTTERTIME_1_120,		// 1/120
	MR_SHUTTERTIME_1_125,		// 1/125
	MR_SHUTTERTIME_1_150,		// 1/150
	MR_SHUTTERTIME_1_180,		// 1/180
	MR_SHUTTERTIME_1_215,		// 1/215
	MR_SHUTTERTIME_1_240,		// 1/240
	MR_SHUTTERTIME_1_250,		// 1/250
	MR_SHUTTERTIME_1_300,		// 1/300
	MR_SHUTTERTIME_1_350,		// 1/350
	MR_SHUTTERTIME_1_425,		// 1/425
	MR_SHUTTERTIME_1_480,		// 1/480
	MR_SHUTTERTIME_1_500,		// 1/500
	MR_SHUTTERTIME_1_600,		// 1/600
	MR_SHUTTERTIME_1_725,		// 1/750
	MR_SHUTTERTIME_1_960,		// 1/960
	MR_SHUTTERTIME_1_1000,		// 1/1000
	MR_SHUTTERTIME_1_1024,		// 1/1024
	MR_SHUTTERTIME_1_1250,		// 1/1250
	MR_SHUTTERTIME_1_1500,		// 1/1500
	MR_SHUTTERTIME_1_1750,		// 1/1750
	MR_SHUTTERTIME_1_2000,		// 1/2000
	MR_SHUTTERTIME_1_3000,		// 1/3000
	MR_SHUTTERTIME_1_3500,		// 1/3500
	MR_SHUTTERTIME_1_4000,		// 1/4000
	MR_SHUTTERTIME_1_6000,		// 1/6000
	MR_SHUTTERTIME_1_8000,		// 1/8000
	MR_SHUTTERTIME_1_10000,		// 1/10000
}MR_VIDEOSHUTTERTIME_TYPE;

//Ȧ
typedef enum{
	MR_IRISLEVEL_1 = 1,		// F1.0
	MR_IRISLEVEL_1_2,		// F1.2
	MR_IRISLEVEL_1_4,		// F1.4
	MR_IRISLEVEL_1_6,		// F1.6
	MR_IRISLEVEL_2_0,		// F2.0
	MR_IRISLEVEL_2_2,		// F2.2
	MR_IRISLEVEL_2_4,		// F2.4
	MR_IRISLEVEL_2_8,		// F2.8
	MR_IRISLEVEL_3_2,		// F3.2
	MR_IRISLEVEL_3_4,		// F3.4
	MR_IRISLEVEL_4_0,		// F4.0
	MR_IRISLEVEL_4_4,		// F4.4
	MR_IRISLEVEL_4_8,		// F4.8
	MR_IRISLEVEL_5_6,		// F5.6
	MR_IRISLEVEL_6_4,		// F6.4
	MR_IRISLEVEL_6_8,		// F6.8
	MR_IRISLEVEL_8_0,		// F8.0
	MR_IRISLEVEL_8_8,		// F8.8
	MR_IRISLEVEL_9_6,		// F9.6
	MR_IRISLEVEL_11,		// F11
	MR_IRISLEVEL_12,		// F12
	MR_IRISLEVEL_14,		// F14
	MR_IRISLEVEL_16,		// F16
	MR_IRISLEVEL_17,		// F17
	MR_IRISLEVEL_19,		// F19
	MR_IRISLEVEL_22,		// F22
	MR_IRISLEVEL_24,		// F24
	MR_IRISLEVEL_32,		// F32
	MR_IRISLEVEL_34,		// F34
	MR_IRISLEVEL_45,		// F45
	MR_IRISLEVEL_64,		// F64

}MR_VIDEOIRISLEVEL_TYPE;


// Э
typedef enum{
	MR_NETSTMPRO_MRMS = 0,	// Э
	MR_NETSTMPRO_RTSP,		// rtsp
	MR_NETSTMPRO_RTMP,		// rtmp
}MR_NETSTMPRO_TYPE;

//	λ
typedef enum{
	MR_COMM_DATATBIT5 = 5,	// 5λ
	MR_COMM_DATATBIT6 = 6,	// 6λ
	MR_COMM_DATATBIT7 = 7,	// 7λ
	MR_COMM_DATATBIT8 = 8,	// 8λ
}MR_COMM_DATABIT_TYPE;

//	ֹͣλ
typedef enum{
	MR_COMM_STOPBIT1  = 1,	// 1λ
	MR_COMM_STOPBIT2  = 2,	// 2λ
}MR_COMM_STOPBIT_TYPE;

//	Уλ
typedef enum{
	MR_COMM_PARITY_NONE = 0,	//	У
	MR_COMM_PARITY_ODD,			//	У
	MR_COMM_PARITY_EVEN,		//	żУ
}MR_COMM_PARITY_TYPE;

//	ڲ
typedef enum{
	MR_COMM_BITRATE_300 = 0,	//	300
	MR_COMM_BITRATE_600,		//	600
	MR_COMM_BITRATE_1200,		//	1200
	MR_COMM_BITRATE_2400,		//	2400
	MR_COMM_BITRATE_4800,		//	4800
	MR_COMM_BITRATE_9600,		//	9600
	MR_COMM_BITRATE_19200,		//	19200
	MR_COMM_BITRATE_38400,		//	38400
	MR_COMM_BITRATE_57600,		//	57600
	MR_COMM_BITRATE_115200,		//	115200
	MR_COMM_BITRATE_NUMS,
}MR_COMM_BITRATE_TYPE;

// ͨЭ鶨
typedef enum{
	MR_UART_PROCOL_INVALID = 0,	// Ч
	MR_UART_PROCOL_AUTO,		// Զ
	MR_UART_PROCOL_PLC_D,		// PLC-D
	MR_UART_PROCOL_PLC_P,		// PLC-P
	MR_UART_PROCOL_VISCA,		// visca
	MR_UART_PROCOL_NUMS,
}MR_UART_PROCOL_TYPE;

// ʱ
typedef enum{
	MR_TIMEZONE_0,					// {0, 0*3600,"GMT+00:00"}
	MR_TIMEZONE_1,					// {1, 1*3600,"GMT+01:00"}
	MR_TIMEZONE_2,					// {2, 2*3600,"GMT+02:00"}
	MR_TIMEZONE_3,					// {3, 3*3600,"GMT+03:00"}
	MR_TIMEZONE_4,					// {4, 3*3600+1800,"GMT+03:30"}
	MR_TIMEZONE_5,					// {5, 4*3600,"GMT+04:00"}
	MR_TIMEZONE_6,					// {6, 4*3600+1800,"GMT+04:30"}
	MR_TIMEZONE_7,					// {7, 5*3600,"GMT+05:00"}
	MR_TIMEZONE_8,					// {8, 5*3600+1800,"GMT+05:30"}
	MR_TIMEZONE_9,					// {9, 5*3600+1800+900,"GMT+05:45"}
	MR_TIMEZONE_10,					// {10, 6*3600,"GMT+06:00"}
	MR_TIMEZONE_11,					// {11, 6*3600+1800,"GMT+06:30"}
	MR_TIMEZONE_12,					// {12, 7*3600,"GMT+07:00"}
	MR_TIMEZONE_13,					// {13, 8*3600,"GMT+08:00"}
	MR_TIMEZONE_14,					// {14, 9*3600,"GMT+09:00"}
	MR_TIMEZONE_15,					// {15, 9*3600+1800,"GMT+09:30"}
	MR_TIMEZONE_16,					// {16, 10*3600,"GMT+10:00"}
	MR_TIMEZONE_17,					// {17, 11*3600,"GMT+11:00"}
	MR_TIMEZONE_18,					// {18, 12*3600,"GMT+12:00"}
	MR_TIMEZONE_19,					// {19, 13*3600,"GMT+13:00"}
	MR_TIMEZONE_20,					// {20, -1*3600,"GMT-01:00"}
	MR_TIMEZONE_21,					// {21, -2*3600,"GMT-02:00"}
	MR_TIMEZONE_22,					// {22, -3*3600,"GMT-03:00"}
	MR_TIMEZONE_23,					// {23, -3*3600-1800,"GMT-03:30"}
	MR_TIMEZONE_24,					// {24, -4*3600,"GMT-04:00"}
	MR_TIMEZONE_25,					// {25, -5*3600,"GMT-05:00"}
	MR_TIMEZONE_26,					// {26, -6*3600,"GMT-06:00"}
	MR_TIMEZONE_27,					// {27, -7*3600,"GMT-07:00"}
	MR_TIMEZONE_28,					// {28, -8*3600,"GMT-08:00"}
	MR_TIMEZONE_29,					// {29, -9*3600,"GMT-09:00"}
	MR_TIMEZONE_30,					// {30, -10*3600,"GMT-10:00"}
	MR_TIMEZONE_31,					// {31, -11*3600,"GMT-11:00"}
	MR_TIMEZONE_32,					// {32, -12*3600,"GMT-12:00"}
	MR_TIMEZONE_NUMS,
}MR_TIMEZONE_TYPE;

// ̨λ
typedef	enum{
	MR_PTZPARK_NONE     = 0,		//޿λ
	MR_PTZPARK_PRESET1  = 1,		//Ԥλ1
									//Ԥλ2~7
	MR_PTZPARK_PRESET8  = 8,		//Ԥλ8

	MR_PTZPARK_AUTOSCAN = 12,		//Զɨ
	MR_PTZPARK_PTSCAN   = 13,		//ƻɨ

	MR_PTZPARK_CRUISE1  = 16,		//ԤλѲ1
									//ԤλѲ2~3
	MR_PTZPARK_CRUISE4  = 19,		//ԤλѲ4

	MR_PTZPARK_PATTEN1  = 24,		//ɨ1
									//ɨ2~3
	MR_PTZPARK_PATTEN4  = 27,		//ɨ4

	MR_PTZPARK_END,
}MR_PTZPARK_TYPE;

//	
typedef enum{
	MR_ALARMIN_TYPE_CLOSE = 0,	//	(͵ƽ)
	MR_ALARMIN_TYPE_OPEN  = 1,	//	(ߵƽ)
}MR_ALARMIN_TYPE;

// Ӳ
typedef enum{
	MR_HDDDEV_LOCALSATA = 0,	// SATAӲ
	MR_HDDDEV_LOCALIDE,			// IDEӲ
	MR_HDDDEV_MOBILEHDD,		// USBƶӲ
	MR_HDDDEV_SD,				// SD
	MR_HDDDEV_NAS,				// NASӲ
	MR_HDDDEV_ESATA,			// esataӲ
	MR_HDDDEV_ISCSI,			// iSCSIӲ
	MR_HDDDEV_ARRAY,			// arrayӲ
	MR_HDDDEV_NUMS,
}MR_HDDDEV_TYPE;

// Ƶʽ
typedef enum{
	MR_VIDEOSTAND_NTSC = 0,			// NTSC
	MR_VIDEOSTAND_PAL  = 1,			// PAL
}MR_VIDEOSTANDARD_TYPE;

// 
typedef enum{
	MR_IOCTRL_CLOSE = 0,	// ֶر
	MR_IOCTRL_OPEN,			// ֶ
	MR_IOCTRL_AUTO,			// Զ
}MR_IOCTRL_TYPE;

// NASЭ
typedef enum{
	MR_NASPROTOCL_NFS = 0,		// nfsЭ
	MR_NASPROTOCL_SMB,			// sambaЭ
	MR_NASPROTOCL_FTP,			// ftpЭ
}MR_NASPROTOCL_TYPE;

// ̨
typedef enum{
	MR_PTZLINK_TYPE_NONE = 0,	// ر
	MR_PTZLINK_TYPE_PRENO,		// Ԥõ
	MR_PTZLINK_TYPE_TRACK,		// 켣
	MR_PTZLINK_TYPE_CRUISE,		// Ѳ
}MR_PTZLINK_TYPE;

// Ӳ״̬
typedef enum{
	MR_HDDSTAT_OK =	0,			// 
	MR_HDDSTAT_UNFORMATTED,		// δʽ
	MR_HDDSTAT_ERROR,			// 
	MR_HDDSTAT_SMART_FAILED,	// SMART״̬
	MR_HDDSTAT_MISMATCH,		// ƥ
	MR_HDDSTAT_IDLE,			// 
	MR_HDDSTAT_OFFLINE,			// ̴δ״̬
}MR_HDDSTAT_TYPE;

// ر豸
typedef enum{
	MR_BACKUPDEV_USBDISK = 0,	// U/USBӲ
	MR_BACKUPDEV_SDCARD,		// SD
	MR_BACKUPDEV_USBDVD,		// USB
	MR_BACKUPDEV_SATADVD,		// SATA
	MR_BACKUPDEV_ESATAHDD,		// eSATAӲ
}MR_BACKUPDEV_TYPE;

// չ
typedef enum{
	MR_EXALARM_STORAGEFAILURE = 1,	// 洢豸ʳ
	MR_EXALARM_STORAGELOWSAPCE,		// 洢豸ռ䲻
	MR_EXALARM_NETSHUTDOWN,			// Ͽ
	MR_EXALARM_IPCONFLICT,			// IPͻ
	MR_EXALARM_DEVABORT,			// 豸쳣
	MR_EXALARM_NUMS,
}MR_EXALARM_TYPE;

// 豸
typedef enum{
	MR_DEVICE_IPC,			// 
	MR_DEVICE_ENC,			// 
	MR_DEVICE_DEC,			// 
	MR_DEVICE_ASK,			// Ѷն
	MR_DEVICE_CONFCAM,		// 
	MR_DEVICE_EDUHUB,		// 
	MR_DEVICE_EDUTEACHER,	// ʦ
	MR_DEVICE_EDUSTUDENT,	// ѧ
	MR_DEVICE_EDUBANSHU,	// 
}MR_DEVICE_TYPE;

// û
typedef enum{
	MR_USER_ADMIN = 1,			// Ա
	MR_USER_ADVANCED,			// Ա
	MR_USER_NORMAL,				// ͨû
}MR_USER_TYPE;

/****************************** ṹ ******************************************/
typedef struct{
	long left;
    long top;
    long right;
    long bottom;
}MR_RECT;

typedef struct{
	int nPosX;		// X λ
	int nPosY;		// Y λ
}MR_POINT;

typedef struct{
    int cx;			// 
    int cy;			// ߶
}MR_SIZE;

typedef struct{
	BYTE byRed;
    BYTE byGreen;
    BYTE byBlue;
    BYTE byAlpha;
}MR_RGBA;

// ͼڵ
typedef struct{
	BOOL					bEnable;
	MR_RECT					stRect;						// , ֱȣ0 - 10000
	MR_RGBA					stColor;					// ɫ
}MR_COVER_T;

typedef struct{
	DWORD				dwYear;					// 
	BYTE				byMonth;				// 
	BYTE				byDay;					// 
	BYTE				byHour;					// ʱ
	BYTE				byMinute;				// 
	BYTE				bySecond;				// 
}MR_TIME_T;

typedef struct{
	DWORD				dwYear;					// 
	BYTE				byMonth;				// 
	BYTE				byDay;					// 
	BYTE				byHour;					// ʱ
	BYTE				byMinute;				// 
	BYTE				bySecond;				// 
	DWORD               dwMillisecond;          // 
}MR_TIMEMS_T;

// ʱνṹ
typedef struct{
	BYTE				bEnable;
	BYTE				byBeginHour;
	BYTE				byBeginMin;
	BYTE				byBeginSec;
	BYTE				byEndHour;
	BYTE				byEndMin;
	BYTE				byEndSec;
	BYTE				byReserved;
}MR_TIMESECT_T;

// ʱṹ
typedef struct{
	int					nZone;		// ʱ
	BOOL				bTimeType;	// 0:UTCʱ 1ʱ
	MR_TIME_T			stDateTime;	// ʱ
}MR_TIMESET_T;

typedef struct{
	char				szDevName[64];		// Ӳ豸(ֻ)
	char				szPartName[64];		// Ӳ̷(ֻ)
	char				szMntDir[64];		// Ӳ̼Ŀ¼(ֻ)
	DWORD				dwCapacity;			// Ӳ̵(MB)(ֻ)
	DWORD				dwFreeSpace;		// Ӳ̵ʣռ(MB)(ֻ)
	
	MR_HDDDEV_TYPE		emHDType;			// Ӳ(ֻ)
	int					nStatus;			// Ӳ״̬־(ֻ), λ־, 
	// bit0: ɶд־
	// bit1: ɸʽ־
	// bit2: Ѹʽ־ 
	// bit3: ־
	// bit4: ߱־
	// bit5: ʹñ־
}MR_HDDSINGLE_T;
typedef struct{
	DWORD				dwHDCounts;				// Ӳ
	MR_HDDSINGLE_T		stHdd[MR_NMAX_HDDS];
}MR_HDDS_T;

// Ϣ
typedef struct{
	int		id;					// idδʹ
	int64_t duration;			// ʱ䳤()
	int     codec_type;			// ý, AVMediaType
	int		codec_id;			// ѹ, MR_AUDIOCODEC_TYPE or MR_VIDEOCODEC_TYPE
	
	int nWidth;					// 
	int nHeight;				// ߶
	int nFrameRate;				// ֡
	int nBitRate;				//  kbps
	int nSampleRate;			// ƵƵ(eg: 8000, 16000)
	int nSampleBits;			// Ƶ(eg: 8, 16)
	int nChannel;				// Ƶͨ(eg: 1, 2)
	unsigned int framenum;		// ֡
	
	unsigned char *extradata;	// չ
    int extradata_size;			// չݳ
}MRAVSTREAM_T;

// ѹ֡Ϣ
typedef struct{
	unsigned char *data;	// 
	int is_dyn_buff;		// 1 - ڲ̬, ʹɺfree(data)
	int nInSize;			// ڴ泤
	int nOutSize;			// 
}MRAVEncFrame;

// չ
typedef struct{
	unsigned char extradata[256];	// չ
    int extradata_size;				// չݳ
}MRSTREAM_EXTDATA_T;

// ֡Ϣ
typedef struct{
	int			  stream_index;		// (0 - n)
	int			  media_type;		// ý, AVMediaType
	int			  nFrameType;		// ֡MR_FRAME_TYPE
	unsigned int  pts;				// ʱ(λ룬0ʼ)
	unsigned int  frameno;			// ֡(0ʼ)
	unsigned char *data;			// ֡
	int			  size;				// ֡
	int			  is_dyn_buff;		// 1 - ڲ̬, ʹɺfree(data)
	int64_t		  pos;				// ֡λ(ڲʹ)
}MRAVFrame;

typedef struct{
	int			  nMaxCount;		// stTime(ֻ)
	int			  nTimeCount;		// stTime
	MR_TIMESECT_T stTime[MR_NMAX_TIMESECT];
}MR_TIESECTWEEK_T;


// ڻ
typedef struct{
	MR_COMM_DATABIT_TYPE	emDataBit;					// λ
	MR_COMM_STOPBIT_TYPE	emStopBit;					// ֹͣλ
	MR_COMM_PARITY_TYPE		emParity;					// Уλ
	MR_COMM_BITRATE_TYPE	emBaudRate;					// 
}MR_COMMATTR_T;

// ̨
typedef struct{
	BYTE			byAddress;
	MR_COMMATTR_T	stComAttr;
}MR_PTZATTR_T;

typedef struct{
	int		imgSrcWidth;	// Դͼ
	int		imgSrcHeight;	// Դͼ
	int		cWidth;			// ǰ
	int		cHeight;		// ǰ
	int		cx;				// ǰx
	int		cy;				// ǰy
	BOOL	bZoomIn;		// TRUE - Ŵ FALSE - С
}MR_PTZ3DLOCAL_T;

typedef struct{
	MR_AUDIOCODEC_TYPE	emCodecType;	// ѹ
	int					nSampleBits;	// λ, 8 or 16 
	int					nSampleRate;	// Ƶ  8000, 16000 eg
	int					nChannels;		// ͨ
	int					nBitRate;		// ѹ
}MR_AUDIOPARAM_T;


//̨PTZλ
typedef struct{
	USHORT				nPanAngle;		// ˮƽǶ  ֵ36000
	USHORT				nTileAngle;		// Ƕ  ֵ36000
	USHORT				nZoom;			// 䱶  1X 2X.......
}MR_PTZPOS_T;

// ϵͳʱ
typedef struct{
	BOOL					bEnable;					//	ʹ
	int						nHostPort;					//	NTP˿,Ĭ϶˿Ϊ123
	int						nUpdateInterval;			//	¼(, 1 - 10)
	char					szHostUrl[MR_SLEN_URLADDR];	//	NTPַ
}MR_NTP_T;

// ̨
typedef struct{
	int			nChannel;
	const char *szPtzCmd;
	BYTE		byValue;
}MR_PTZCTRL_T;

// IPַ֪ͨ
typedef struct{
	BOOL  bEnable;							// ʹܱ־
	int   nDevMask;							// 0x01 - eth, 0x02 - wlan, 0x04 - 4g
	char  szHostIPAddr[MR_SLEN_URLADDR];	// IPַ
	WORD  wHostPort;						// ˿
	int	  nInterval;						// (10 - 600)
}MR_IPADDR_NOTIFY_CFG;

typedef struct{
	int			nXSpeed;//ˮƽٶ
	int			nYSpeed;//ٶ
	float		fXAngle;//ˮƽǶ [-170, 170]
	float		fYAngle;//ֱǶ (-30, 90)
	float		fZAngle;//[0, 1]
}MR_PTZ_ABSOLUTE_RELATIVE_T;

#endif//__MRCOMM_H__
